<?php
/**
 * MetierBonWebConnectBonClient
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierBonWebConnectBonClient Class Doc Comment
 *
 * @category Class
 * @description (fullname : piu_GestionStock.Metier.Vente.MetierBon.WebConnectBonClient)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierBonWebConnectBonClient implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierBon_WebConnectBonClient';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'client' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientMinimal',
        'ref_ext' => 'string',
        'libelle' => 'string',
        'code' => 'string',
        'type' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TTypeBon',
        'montant' => 'float',
        'pourcentage' => 'float',
        'date_emission' => '\DateTime',
        'date_validite' => '\DateTime',
        'a_ete_utilise' => 'bool',
        'est_valide' => 'bool',
        'quarantaine' => 'bool',
        'derniere_modification' => '\DateTime',
        'exterieur' => 'bool',
        'plus_cher' => 'bool',
        'seuil' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'client' => null,
        'ref_ext' => null,
        'libelle' => null,
        'code' => null,
        'type' => null,
        'montant' => 'decimal',
        'pourcentage' => 'decimal',
        'date_emission' => 'date-time',
        'date_validite' => 'date-time',
        'a_ete_utilise' => null,
        'est_valide' => null,
        'quarantaine' => null,
        'derniere_modification' => 'date-time',
        'exterieur' => null,
        'plus_cher' => null,
        'seuil' => 'decimal'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'client' => false,
        'ref_ext' => false,
        'libelle' => false,
        'code' => false,
        'type' => false,
        'montant' => true,
        'pourcentage' => true,
        'date_emission' => false,
        'date_validite' => true,
        'a_ete_utilise' => false,
        'est_valide' => false,
        'quarantaine' => false,
        'derniere_modification' => false,
        'exterieur' => false,
        'plus_cher' => false,
        'seuil' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'client' => 'Client',
        'ref_ext' => 'RefExt',
        'libelle' => 'Libelle',
        'code' => 'Code',
        'type' => 'Type',
        'montant' => 'Montant',
        'pourcentage' => 'Pourcentage',
        'date_emission' => 'DateEmission',
        'date_validite' => 'DateValidite',
        'a_ete_utilise' => 'AEteUtilise',
        'est_valide' => 'EstValide',
        'quarantaine' => 'Quarantaine',
        'derniere_modification' => 'DerniereModification',
        'exterieur' => 'Exterieur',
        'plus_cher' => 'PlusCher',
        'seuil' => 'Seuil'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'client' => 'setClient',
        'ref_ext' => 'setRefExt',
        'libelle' => 'setLibelle',
        'code' => 'setCode',
        'type' => 'setType',
        'montant' => 'setMontant',
        'pourcentage' => 'setPourcentage',
        'date_emission' => 'setDateEmission',
        'date_validite' => 'setDateValidite',
        'a_ete_utilise' => 'setAEteUtilise',
        'est_valide' => 'setEstValide',
        'quarantaine' => 'setQuarantaine',
        'derniere_modification' => 'setDerniereModification',
        'exterieur' => 'setExterieur',
        'plus_cher' => 'setPlusCher',
        'seuil' => 'setSeuil'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'client' => 'getClient',
        'ref_ext' => 'getRefExt',
        'libelle' => 'getLibelle',
        'code' => 'getCode',
        'type' => 'getType',
        'montant' => 'getMontant',
        'pourcentage' => 'getPourcentage',
        'date_emission' => 'getDateEmission',
        'date_validite' => 'getDateValidite',
        'a_ete_utilise' => 'getAEteUtilise',
        'est_valide' => 'getEstValide',
        'quarantaine' => 'getQuarantaine',
        'derniere_modification' => 'getDerniereModification',
        'exterieur' => 'getExterieur',
        'plus_cher' => 'getPlusCher',
        'seuil' => 'getSeuil'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('client', $data ?? [], null);
        $this->setIfExists('ref_ext', $data ?? [], null);
        $this->setIfExists('libelle', $data ?? [], null);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('montant', $data ?? [], null);
        $this->setIfExists('pourcentage', $data ?? [], null);
        $this->setIfExists('date_emission', $data ?? [], null);
        $this->setIfExists('date_validite', $data ?? [], null);
        $this->setIfExists('a_ete_utilise', $data ?? [], false);
        $this->setIfExists('est_valide', $data ?? [], false);
        $this->setIfExists('quarantaine', $data ?? [], false);
        $this->setIfExists('derniere_modification', $data ?? [], null);
        $this->setIfExists('exterieur', $data ?? [], false);
        $this->setIfExists('plus_cher', $data ?? [], false);
        $this->setIfExists('seuil', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets client
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientMinimal|null
     */
    public function getClient()
    {
        return $this->container['client'];
    }

    /**
     * Sets client
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientMinimal|null $client client
     *
     * @return self
     */
    public function setClient($client)
    {
        if (is_null($client)) {
            throw new \InvalidArgumentException('non-nullable client cannot be null');
        }
        $this->container['client'] = $client;

        return $this;
    }

    /**
     * Gets ref_ext
     *
     * @return string|null
     */
    public function getRefExt()
    {
        return $this->container['ref_ext'];
    }

    /**
     * Sets ref_ext
     *
     * @param string|null $ref_ext Votre référence de bon    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setRefExt($ref_ext)
    {
        if (is_null($ref_ext)) {
            throw new \InvalidArgumentException('non-nullable ref_ext cannot be null');
        }
        $this->container['ref_ext'] = $ref_ext;

        return $this;
    }

    /**
     * Gets libelle
     *
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->container['libelle'];
    }

    /**
     * Sets libelle
     *
     * @param string|null $libelle Libellé du bon    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setLibelle($libelle)
    {
        if (is_null($libelle)) {
            throw new \InvalidArgumentException('non-nullable libelle cannot be null');
        }
        $this->container['libelle'] = $libelle;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Code barres identifiant le bon    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets type
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TTypeBon|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TTypeBon|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets montant
     *
     * @return float|null
     */
    public function getMontant()
    {
        return $this->container['montant'];
    }

    /**
     * Sets montant
     *
     * @param float|null $montant Valeur du bon si le bon est un bon de type montant (pourcentage est nul)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setMontant($montant)
    {
        if (is_null($montant)) {
            array_push($this->openAPINullablesSetToNull, 'montant');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('montant', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['montant'] = $montant;

        return $this;
    }

    /**
     * Gets pourcentage
     *
     * @return float|null
     */
    public function getPourcentage()
    {
        return $this->container['pourcentage'];
    }

    /**
     * Sets pourcentage
     *
     * @param float|null $pourcentage Pourcentage de remise accordée par le bon si le bon est de type pourcentage (montant est nul).    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPourcentage($pourcentage)
    {
        if (is_null($pourcentage)) {
            array_push($this->openAPINullablesSetToNull, 'pourcentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('pourcentage', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['pourcentage'] = $pourcentage;

        return $this;
    }

    /**
     * Gets date_emission
     *
     * @return \DateTime|null
     */
    public function getDateEmission()
    {
        return $this->container['date_emission'];
    }

    /**
     * Sets date_emission
     *
     * @param \DateTime|null $date_emission Date d'émission du bon    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDateEmission($date_emission)
    {
        if (is_null($date_emission)) {
            throw new \InvalidArgumentException('non-nullable date_emission cannot be null');
        }
        $this->container['date_emission'] = $date_emission;

        return $this;
    }

    /**
     * Gets date_validite
     *
     * @return \DateTime|null
     */
    public function getDateValidite()
    {
        return $this->container['date_validite'];
    }

    /**
     * Sets date_validite
     *
     * @param \DateTime|null $date_validite Date de validité sur les bons qui ont une durée de vie    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDateValidite($date_validite)
    {
        if (is_null($date_validite)) {
            array_push($this->openAPINullablesSetToNull, 'date_validite');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_validite', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_validite'] = $date_validite;

        return $this;
    }

    /**
     * Gets a_ete_utilise
     *
     * @return bool|null
     */
    public function getAEteUtilise()
    {
        return $this->container['a_ete_utilise'];
    }

    /**
     * Sets a_ete_utilise
     *
     * @param bool|null $a_ete_utilise Indique vrai lorsque le bon a déjà été utilisé    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setAEteUtilise($a_ete_utilise)
    {
        if (is_null($a_ete_utilise)) {
            throw new \InvalidArgumentException('non-nullable a_ete_utilise cannot be null');
        }
        $this->container['a_ete_utilise'] = $a_ete_utilise;

        return $this;
    }

    /**
     * Gets est_valide
     *
     * @return bool|null
     */
    public function getEstValide()
    {
        return $this->container['est_valide'];
    }

    /**
     * Sets est_valide
     *
     * @param bool|null $est_valide Indique vrai lorsque le bon peut-être utilisé (date d'émission passée, date de validité non dépassée, bon non utilisé ni marqué comme supprimé)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEstValide($est_valide)
    {
        if (is_null($est_valide)) {
            throw new \InvalidArgumentException('non-nullable est_valide cannot be null');
        }
        $this->container['est_valide'] = $est_valide;

        return $this;
    }

    /**
     * Gets quarantaine
     *
     * @return bool|null
     */
    public function getQuarantaine()
    {
        return $this->container['quarantaine'];
    }

    /**
     * Sets quarantaine
     *
     * @param bool|null $quarantaine Vrai quand le bon est marqué pour suppression et devrait être supprimé dans les bases des tiers    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setQuarantaine($quarantaine)
    {
        if (is_null($quarantaine)) {
            throw new \InvalidArgumentException('non-nullable quarantaine cannot be null');
        }
        $this->container['quarantaine'] = $quarantaine;

        return $this;
    }

    /**
     * Gets derniere_modification
     *
     * @return \DateTime|null
     */
    public function getDerniereModification()
    {
        return $this->container['derniere_modification'];
    }

    /**
     * Sets derniere_modification
     *
     * @param \DateTime|null $derniere_modification Date de dernière modification du bon    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereModification($derniere_modification)
    {
        if (is_null($derniere_modification)) {
            throw new \InvalidArgumentException('non-nullable derniere_modification cannot be null');
        }
        $this->container['derniere_modification'] = $derniere_modification;

        return $this;
    }

    /**
     * Gets exterieur
     *
     * @return bool|null
     */
    public function getExterieur()
    {
        return $this->container['exterieur'];
    }

    /**
     * Sets exterieur
     *
     * @param bool|null $exterieur Le bon a t'il été créer par API    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setExterieur($exterieur)
    {
        if (is_null($exterieur)) {
            throw new \InvalidArgumentException('non-nullable exterieur cannot be null');
        }
        $this->container['exterieur'] = $exterieur;

        return $this;
    }

    /**
     * Gets plus_cher
     *
     * @return bool|null
     */
    public function getPlusCher()
    {
        return $this->container['plus_cher'];
    }

    /**
     * Sets plus_cher
     *
     * @param bool|null $plus_cher Le pourcentage est sur l'article le plus cher    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPlusCher($plus_cher)
    {
        if (is_null($plus_cher)) {
            throw new \InvalidArgumentException('non-nullable plus_cher cannot be null');
        }
        $this->container['plus_cher'] = $plus_cher;

        return $this;
    }

    /**
     * Gets seuil
     *
     * @return float|null
     */
    public function getSeuil()
    {
        return $this->container['seuil'];
    }

    /**
     * Sets seuil
     *
     * @param float|null $seuil Seuil d'activation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setSeuil($seuil)
    {
        if (is_null($seuil)) {
            throw new \InvalidArgumentException('non-nullable seuil cannot be null');
        }
        $this->container['seuil'] = $seuil;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


