<?php
/**
 * MetierClientWebConnextDetailVente
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierClientWebConnextDetailVente Class Doc Comment
 *
 * @category Class
 * @description Article vendue   (fullname : piu_Clients.MetierClient.WebConnextDetailVente)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierClientWebConnextDetailVente implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierClient_WebConnextDetailVente';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'code' => 'string',
        'designation' => 'string',
        'qte' => 'int',
        'pvu' => 'float',
        'pvt' => 'float',
        'pvtht' => 'float',
        'tva' => 'float',
        'taux_tva' => 'float',
        'ensemble' => 'bool',
        'type_ensemble' => 'string',
        'derniere_modification' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'code' => null,
        'designation' => null,
        'qte' => 'int32',
        'pvu' => 'decimal',
        'pvt' => 'decimal',
        'pvtht' => 'decimal',
        'tva' => 'decimal',
        'taux_tva' => 'decimal',
        'ensemble' => null,
        'type_ensemble' => null,
        'derniere_modification' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'code' => false,
        'designation' => false,
        'qte' => false,
        'pvu' => false,
        'pvt' => false,
        'pvtht' => false,
        'tva' => false,
        'taux_tva' => true,
        'ensemble' => false,
        'type_ensemble' => false,
        'derniere_modification' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'code' => 'code',
        'designation' => 'designation',
        'qte' => 'Qte',
        'pvu' => 'PVU',
        'pvt' => 'PVT',
        'pvtht' => 'PVTHT',
        'tva' => 'TVA',
        'taux_tva' => 'TauxTVA',
        'ensemble' => 'Ensemble',
        'type_ensemble' => 'TypeEnsemble',
        'derniere_modification' => 'DerniereModification'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'code' => 'setCode',
        'designation' => 'setDesignation',
        'qte' => 'setQte',
        'pvu' => 'setPvu',
        'pvt' => 'setPvt',
        'pvtht' => 'setPvtht',
        'tva' => 'setTva',
        'taux_tva' => 'setTauxTva',
        'ensemble' => 'setEnsemble',
        'type_ensemble' => 'setTypeEnsemble',
        'derniere_modification' => 'setDerniereModification'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'code' => 'getCode',
        'designation' => 'getDesignation',
        'qte' => 'getQte',
        'pvu' => 'getPvu',
        'pvt' => 'getPvt',
        'pvtht' => 'getPvtht',
        'tva' => 'getTva',
        'taux_tva' => 'getTauxTva',
        'ensemble' => 'getEnsemble',
        'type_ensemble' => 'getTypeEnsemble',
        'derniere_modification' => 'getDerniereModification'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('designation', $data ?? [], null);
        $this->setIfExists('qte', $data ?? [], null);
        $this->setIfExists('pvu', $data ?? [], null);
        $this->setIfExists('pvt', $data ?? [], null);
        $this->setIfExists('pvtht', $data ?? [], null);
        $this->setIfExists('tva', $data ?? [], null);
        $this->setIfExists('taux_tva', $data ?? [], null);
        $this->setIfExists('ensemble', $data ?? [], false);
        $this->setIfExists('type_ensemble', $data ?? [], null);
        $this->setIfExists('derniere_modification', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Code barre de la vente    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets designation
     *
     * @return string|null
     */
    public function getDesignation()
    {
        return $this->container['designation'];
    }

    /**
     * Sets designation
     *
     * @param string|null $designation Désignation sur le ticket    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDesignation($designation)
    {
        if (is_null($designation)) {
            throw new \InvalidArgumentException('non-nullable designation cannot be null');
        }
        $this->container['designation'] = $designation;

        return $this;
    }

    /**
     * Gets qte
     *
     * @return int|null
     */
    public function getQte()
    {
        return $this->container['qte'];
    }

    /**
     * Sets qte
     *
     * @param int|null $qte Quantité vendue, elle est négative pour les retours    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setQte($qte)
    {
        if (is_null($qte)) {
            throw new \InvalidArgumentException('non-nullable qte cannot be null');
        }
        $this->container['qte'] = $qte;

        return $this;
    }

    /**
     * Gets pvu
     *
     * @return float|null
     */
    public function getPvu()
    {
        return $this->container['pvu'];
    }

    /**
     * Sets pvu
     *
     * @param float|null $pvu Prix de vente unitaire    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPvu($pvu)
    {
        if (is_null($pvu)) {
            throw new \InvalidArgumentException('non-nullable pvu cannot be null');
        }
        $this->container['pvu'] = $pvu;

        return $this;
    }

    /**
     * Gets pvt
     *
     * @return float|null
     */
    public function getPvt()
    {
        return $this->container['pvt'];
    }

    /**
     * Sets pvt
     *
     * @param float|null $pvt Prix de vente total    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPvt($pvt)
    {
        if (is_null($pvt)) {
            throw new \InvalidArgumentException('non-nullable pvt cannot be null');
        }
        $this->container['pvt'] = $pvt;

        return $this;
    }

    /**
     * Gets pvtht
     *
     * @return float|null
     */
    public function getPvtht()
    {
        return $this->container['pvtht'];
    }

    /**
     * Sets pvtht
     *
     * @param float|null $pvtht Prix de vente total hors taxe    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPvtht($pvtht)
    {
        if (is_null($pvtht)) {
            throw new \InvalidArgumentException('non-nullable pvtht cannot be null');
        }
        $this->container['pvtht'] = $pvtht;

        return $this;
    }

    /**
     * Gets tva
     *
     * @return float|null
     */
    public function getTva()
    {
        return $this->container['tva'];
    }

    /**
     * Sets tva
     *
     * @param float|null $tva TVA    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setTva($tva)
    {
        if (is_null($tva)) {
            throw new \InvalidArgumentException('non-nullable tva cannot be null');
        }
        $this->container['tva'] = $tva;

        return $this;
    }

    /**
     * Gets taux_tva
     *
     * @return float|null
     */
    public function getTauxTva()
    {
        return $this->container['taux_tva'];
    }

    /**
     * Sets taux_tva
     *
     * @param float|null $taux_tva Taux de TVA appliqué ou vide pour TVA automatique    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setTauxTva($taux_tva)
    {
        if (is_null($taux_tva)) {
            array_push($this->openAPINullablesSetToNull, 'taux_tva');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('taux_tva', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['taux_tva'] = $taux_tva;

        return $this;
    }

    /**
     * Gets ensemble
     *
     * @return bool|null
     */
    public function getEnsemble()
    {
        return $this->container['ensemble'];
    }

    /**
     * Sets ensemble
     *
     * @param bool|null $ensemble Cette article fait partie d'une vente par ensemble    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEnsemble($ensemble)
    {
        if (is_null($ensemble)) {
            throw new \InvalidArgumentException('non-nullable ensemble cannot be null');
        }
        $this->container['ensemble'] = $ensemble;

        return $this;
    }

    /**
     * Gets type_ensemble
     *
     * @return string|null
     */
    public function getTypeEnsemble()
    {
        return $this->container['type_ensemble'];
    }

    /**
     * Sets type_ensemble
     *
     * @param string|null $type_ensemble Libellé de la vente par ensemble utilisé pour ce détail    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setTypeEnsemble($type_ensemble)
    {
        if (is_null($type_ensemble)) {
            throw new \InvalidArgumentException('non-nullable type_ensemble cannot be null');
        }
        $this->container['type_ensemble'] = $type_ensemble;

        return $this;
    }

    /**
     * Gets derniere_modification
     *
     * @return \DateTime|null
     */
    public function getDerniereModification()
    {
        return $this->container['derniere_modification'];
    }

    /**
     * Sets derniere_modification
     *
     * @param \DateTime|null $derniere_modification Date de dernière modification du détail de promotion    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereModification($derniere_modification)
    {
        if (is_null($derniere_modification)) {
            throw new \InvalidArgumentException('non-nullable derniere_modification cannot be null');
        }
        $this->container['derniere_modification'] = $derniere_modification;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


