<?php
namespace PrestaShop\Module\PolarisPrestaConnector\Models;

/**
 * Objet d'interface contenant la définition d'une promotion article
 */
class Discount extends SanitizedObject
{
    /**
     * Identifiants du produit sous le backoffice
     * 
     * @param array<string> Références
     */    
    public array $refs;

    /**
     * EAN fournisseurs
     * 
     * @param array<string> Références
     */    
    public ?array $eans;

    /**
     * Remise accordée
     */
    public float $discount;

    /**
     * Active ou à supprimer
     */
    public bool $active = true;
    
    /**
     * Nouveau stock
     * 
     * @param array<string> $refs code barres de la référence
     */
    public function __construct(
        array $refs
        )
    {
        $this->refs = $refs;
    }

    /**
     * Nettoyage de la donnée sur les standards Prestashop
     */
    public function sanitize()
    {
        for ($i = 0; $i < count($this->eans); $i++)
            $this->eans[$i] = $this->sanitizeStr($this->eans[$i], 32);
    }
}