<?php

namespace PrestaShop\Module\PolarisPrestaConnector\Forms;

use PrestaShop\Module\PolarisPrestaConnector\SyncConfiguration;
use PrestaShopBundle\Form\Admin\Type\CustomContentType;
use Symfony\Component\Form\FormBuilderInterface;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class StocksType extends ConnectorType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        /**
         * Stock de sécurité
         */
        $builder
            ->add('secured_stock', TextType::class, [
                'label' => 'Stock de sécurité',                
                'required' => false,
                'help' => 'Cette valeur est déduite du stock de chaque taille de produit lors de l\'importation du stock.', // should be set to enable help block
                'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_SECURED_STOCK),
            ]);

        /**
         * Cacher/montrer les produits en stock
         */
        $builder
            ->add('hide_stock_method', ChoiceType::class, [
                'label' => 'Visibilité des produits en rupture de stock',                
                //'choice_attr' => $this->productVisibilityChoiceProvider->getChoicesAttributes(),
                'choices' => [
                    'Ne pas changer la visibilité du produit' => '',
                    'Produit visible' => 'both',
                    'Cacher le produit' => 'none',
                    'Produit uniquement visible dans le parcours catalogue' => 'catalog',
                    'Produit uniquement visible lors d\'une recherche' => 'search',
                ],

                'expanded' => false,
                'required' => false,
                // placeholder false is important to avoid empty option in radio select despite required being false
                'placeholder' => false,
                'column_breaker' => true,
                'help' => '', // should be set to enable help block
                'data' => $this->module->getCfg()->get(SyncConfiguration::CFG_NO_STOCK_PRODUCT_VISIBILITY ),
            ]);

        $builder->add('title_stock', CustomContentType::class, [
            'label' => false,
            'template' => $this->titleFormTemplatePath,
            'data' => [
                'hr' => true,
                'title' => 'Composition du stock en ligne',
                'help' => "<p>Choisissez les magasins qui participent aux stocks des ventes en ligne. </p>
                            <ul>
                            <li>Le stock de chaque produit sera la somme des stocks de ces magasins.</li>
                            <li>Si vous ne sélectionnez aucun magasin, le stock de chaque produit sera la somme des stocks de tous les magasins.</li>
                            <li>Si vous changez cette option, vous devrez déclencher une <strong>synchronisation complète</strong> pour mettre à jour les stocks.</li>
                            </ul>",
            ],
        ]);

        // On va créer une coche pour chaque magasin (présent sous la clé de configuration CFP_MAP_STORES)
        $stores = $this->module->getCfg()->get(SyncConfiguration::CFG_MAP_STORES_NAME);
        $selected_stock_stores = $this->module->getCfg()->get(SyncConfiguration::CFG_ONLINE_STOCK_STORES) ?? [];
        $choices = [];
        $data = [];

        if ($stores)
        {
            foreach ($stores as $storeId => $name) {
                if ($storeId != '*')
                    $choices[$name] = $storeId;
                if (isset($selected_stock_stores[$storeId]) && $selected_stock_stores[$storeId])
                    $data[] = $storeId;
            }

            // Si on triait, en conservant les associations
            asort($choices);
            

            $builder->add('stock_stores', ChoiceType::class, [
                'label' => 'Magasins qui participent aux stocks des ventes en ligne',
                'choices' => $choices,
                'multiple' => true,
                'expanded' => true,
                'required' => false,
                'data' => $data,
            ]);
        }
        else
        {
            $builder->add('stock_stores', ChoiceType::class, [
                'label' => 'Magasins qui participent aux stocks des ventes en ligne',
                'choices' => ["Aucun magasin trouvé" => "*"],
                'multiple' => true,
                'expanded' => true,
                'required' => false,
                'disabled' => true,
                'data' => $data,
            ]);
        }
        
        $this->module->getBridge()->hookAdminForm($builder, $options);

        // Bouton de sauvegarde
        $builder->add('Enregistrer', SubmitType::class, [
            'attr' => ['class' => 'btn-form-valid btn-primary']
        ]);
    }
}