<?php
/**
 * WebConnectReservationDetail
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * WebConnectReservationDetail Class Doc Comment
 *
 * @category Class
 * @description Détail de réservation   (fullname : piu_Ventes.CdeClient.WebConnect.WebConnectReservationDetail)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class WebConnectReservationDetail implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WebConnectReservationDetail';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'nom_variante' => 'string',
        'code' => 'string',
        'code_ref' => 'int',
        'nom_produit' => 'string',
        'taille' => 'string',
        'refs' => 'string[]',
        'eans' => 'string[]',
        'pvuttc' => 'float',
        'pvuttc_normal' => 'float',
        'taux_taxe1' => 'float',
        'taux_taxe2' => 'float',
        'qte_reservee' => 'int',
        'qte_annulee' => 'int',
        'qte_achetee' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'nom_variante' => null,
        'code' => null,
        'code_ref' => 'int64',
        'nom_produit' => null,
        'taille' => null,
        'refs' => null,
        'eans' => null,
        'pvuttc' => 'decimal',
        'pvuttc_normal' => 'decimal',
        'taux_taxe1' => 'decimal',
        'taux_taxe2' => 'decimal',
        'qte_reservee' => 'int32',
        'qte_annulee' => 'int32',
        'qte_achetee' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'nom_variante' => false,
        'code' => false,
        'code_ref' => false,
        'nom_produit' => false,
        'taille' => false,
        'refs' => false,
        'eans' => false,
        'pvuttc' => false,
        'pvuttc_normal' => false,
        'taux_taxe1' => false,
        'taux_taxe2' => false,
        'qte_reservee' => false,
        'qte_annulee' => false,
        'qte_achetee' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'nom_variante' => 'NomVariante',
        'code' => 'Code',
        'code_ref' => 'CodeRef',
        'nom_produit' => 'NomProduit',
        'taille' => 'Taille',
        'refs' => 'Refs',
        'eans' => 'Eans',
        'pvuttc' => 'PVUTTC',
        'pvuttc_normal' => 'PVUTTC_Normal',
        'taux_taxe1' => 'TauxTaxe1',
        'taux_taxe2' => 'TauxTaxe2',
        'qte_reservee' => 'QteReservee',
        'qte_annulee' => 'QteAnnulee',
        'qte_achetee' => 'QteAchetee'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'nom_variante' => 'setNomVariante',
        'code' => 'setCode',
        'code_ref' => 'setCodeRef',
        'nom_produit' => 'setNomProduit',
        'taille' => 'setTaille',
        'refs' => 'setRefs',
        'eans' => 'setEans',
        'pvuttc' => 'setPvuttc',
        'pvuttc_normal' => 'setPvuttcNormal',
        'taux_taxe1' => 'setTauxTaxe1',
        'taux_taxe2' => 'setTauxTaxe2',
        'qte_reservee' => 'setQteReservee',
        'qte_annulee' => 'setQteAnnulee',
        'qte_achetee' => 'setQteAchetee'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'nom_variante' => 'getNomVariante',
        'code' => 'getCode',
        'code_ref' => 'getCodeRef',
        'nom_produit' => 'getNomProduit',
        'taille' => 'getTaille',
        'refs' => 'getRefs',
        'eans' => 'getEans',
        'pvuttc' => 'getPvuttc',
        'pvuttc_normal' => 'getPvuttcNormal',
        'taux_taxe1' => 'getTauxTaxe1',
        'taux_taxe2' => 'getTauxTaxe2',
        'qte_reservee' => 'getQteReservee',
        'qte_annulee' => 'getQteAnnulee',
        'qte_achetee' => 'getQteAchetee'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('nom_variante', $data ?? [], null);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('code_ref', $data ?? [], 0);
        $this->setIfExists('nom_produit', $data ?? [], null);
        $this->setIfExists('taille', $data ?? [], null);
        $this->setIfExists('refs', $data ?? [], null);
        $this->setIfExists('eans', $data ?? [], null);
        $this->setIfExists('pvuttc', $data ?? [], null);
        $this->setIfExists('pvuttc_normal', $data ?? [], null);
        $this->setIfExists('taux_taxe1', $data ?? [], null);
        $this->setIfExists('taux_taxe2', $data ?? [], null);
        $this->setIfExists('qte_reservee', $data ?? [], 0);
        $this->setIfExists('qte_annulee', $data ?? [], 0);
        $this->setIfExists('qte_achetee', $data ?? [], 0);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets nom_variante
     *
     * @return string|null
     */
    public function getNomVariante()
    {
        return $this->container['nom_variante'];
    }

    /**
     * Sets nom_variante
     *
     * @param string|null $nom_variante Nom de la variante du produit, non triable
     *
     * @return self
     */
    public function setNomVariante($nom_variante)
    {
        if (is_null($nom_variante)) {
            throw new \InvalidArgumentException('non-nullable nom_variante cannot be null');
        }
        $this->container['nom_variante'] = $nom_variante;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Code du produit    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets code_ref
     *
     * @return int|null
     */
    public function getCodeRef()
    {
        return $this->container['code_ref'];
    }

    /**
     * Sets code_ref
     *
     * @param int|null $code_ref Code numérique alternatif de référence pour la déclinaison, si fonctionnalité activée dans Polaris    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodeRef($code_ref)
    {
        if (is_null($code_ref)) {
            throw new \InvalidArgumentException('non-nullable code_ref cannot be null');
        }
        $this->container['code_ref'] = $code_ref;

        return $this;
    }

    /**
     * Gets nom_produit
     *
     * @return string|null
     */
    public function getNomProduit()
    {
        return $this->container['nom_produit'];
    }

    /**
     * Sets nom_produit
     *
     * @param string|null $nom_produit Nom du produit    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setNomProduit($nom_produit)
    {
        if (is_null($nom_produit)) {
            throw new \InvalidArgumentException('non-nullable nom_produit cannot be null');
        }
        $this->container['nom_produit'] = $nom_produit;

        return $this;
    }

    /**
     * Gets taille
     *
     * @return string|null
     */
    public function getTaille()
    {
        return $this->container['taille'];
    }

    /**
     * Sets taille
     *
     * @param string|null $taille Taille    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setTaille($taille)
    {
        if (is_null($taille)) {
            throw new \InvalidArgumentException('non-nullable taille cannot be null');
        }
        $this->container['taille'] = $taille;

        return $this;
    }

    /**
     * Gets refs
     *
     * @return string[]|null
     */
    public function getRefs()
    {
        return $this->container['refs'];
    }

    /**
     * Sets refs
     *
     * @param string[]|null $refs Codes barres Polaris    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setRefs($refs)
    {
        if (is_null($refs)) {
            throw new \InvalidArgumentException('non-nullable refs cannot be null');
        }
        $this->container['refs'] = $refs;

        return $this;
    }

    /**
     * Gets eans
     *
     * @return string[]|null
     */
    public function getEans()
    {
        return $this->container['eans'];
    }

    /**
     * Sets eans
     *
     * @param string[]|null $eans Codes barres Fournisseur (si existant)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEans($eans)
    {
        if (is_null($eans)) {
            throw new \InvalidArgumentException('non-nullable eans cannot be null');
        }
        $this->container['eans'] = $eans;

        return $this;
    }

    /**
     * Gets pvuttc
     *
     * @return float|null
     */
    public function getPvuttc()
    {
        return $this->container['pvuttc'];
    }

    /**
     * Sets pvuttc
     *
     * @param float|null $pvuttc Prix unitaire toutes taxes comprises consenti de l'article pour la réservation    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPvuttc($pvuttc)
    {
        if (is_null($pvuttc)) {
            throw new \InvalidArgumentException('non-nullable pvuttc cannot be null');
        }
        $this->container['pvuttc'] = $pvuttc;

        return $this;
    }

    /**
     * Gets pvuttc_normal
     *
     * @return float|null
     */
    public function getPvuttcNormal()
    {
        return $this->container['pvuttc_normal'];
    }

    /**
     * Sets pvuttc_normal
     *
     * @param float|null $pvuttc_normal Prix unitaire toutes taxes comprises de l'article en temps normal    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPvuttcNormal($pvuttc_normal)
    {
        if (is_null($pvuttc_normal)) {
            throw new \InvalidArgumentException('non-nullable pvuttc_normal cannot be null');
        }
        $this->container['pvuttc_normal'] = $pvuttc_normal;

        return $this;
    }

    /**
     * Gets taux_taxe1
     *
     * @return float|null
     */
    public function getTauxTaxe1()
    {
        return $this->container['taux_taxe1'];
    }

    /**
     * Sets taux_taxe1
     *
     * @param float|null $taux_taxe1 Taux de la taxe 1 (TVA)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setTauxTaxe1($taux_taxe1)
    {
        if (is_null($taux_taxe1)) {
            throw new \InvalidArgumentException('non-nullable taux_taxe1 cannot be null');
        }
        $this->container['taux_taxe1'] = $taux_taxe1;

        return $this;
    }

    /**
     * Gets taux_taxe2
     *
     * @return float|null
     */
    public function getTauxTaxe2()
    {
        return $this->container['taux_taxe2'];
    }

    /**
     * Sets taux_taxe2
     *
     * @param float|null $taux_taxe2 Taux de la taxe 2    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setTauxTaxe2($taux_taxe2)
    {
        if (is_null($taux_taxe2)) {
            throw new \InvalidArgumentException('non-nullable taux_taxe2 cannot be null');
        }
        $this->container['taux_taxe2'] = $taux_taxe2;

        return $this;
    }

    /**
     * Gets qte_reservee
     *
     * @return int|null
     */
    public function getQteReservee()
    {
        return $this->container['qte_reservee'];
    }

    /**
     * Sets qte_reservee
     *
     * @param int|null $qte_reservee Quantité réservée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setQteReservee($qte_reservee)
    {
        if (is_null($qte_reservee)) {
            throw new \InvalidArgumentException('non-nullable qte_reservee cannot be null');
        }
        $this->container['qte_reservee'] = $qte_reservee;

        return $this;
    }

    /**
     * Gets qte_annulee
     *
     * @return int|null
     */
    public function getQteAnnulee()
    {
        return $this->container['qte_annulee'];
    }

    /**
     * Sets qte_annulee
     *
     * @param int|null $qte_annulee Quantité annulée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setQteAnnulee($qte_annulee)
    {
        if (is_null($qte_annulee)) {
            throw new \InvalidArgumentException('non-nullable qte_annulee cannot be null');
        }
        $this->container['qte_annulee'] = $qte_annulee;

        return $this;
    }

    /**
     * Gets qte_achetee
     *
     * @return int|null
     */
    public function getQteAchetee()
    {
        return $this->container['qte_achetee'];
    }

    /**
     * Sets qte_achetee
     *
     * @param int|null $qte_achetee Quantité achetée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setQteAchetee($qte_achetee)
    {
        if (is_null($qte_achetee)) {
            throw new \InvalidArgumentException('non-nullable qte_achetee cannot be null');
        }
        $this->container['qte_achetee'] = $qte_achetee;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


