<?php
/**
 * MetierClientWebConnectClientUpdateable
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierClientWebConnectClientUpdateable Class Doc Comment
 *
 * @category Class
 * @description Structure représentant une identification client   (fullname : piu_Clients.MetierClient.WebConnectClientUpdateable)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierClientWebConnectClientUpdateable implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierClient_WebConnectClientUpdateable';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'ajouter_a_liste_diffusions' => 'int[]',
        'retirer_de_liste_diffusions' => 'int[]',
        'memo' => 'string',
        'code_magasin' => 'int',
        'evenements' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientEvents',
        'ident' => 'string',
        'nom' => 'string',
        'prenom' => 'string',
        'telephone' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\Telephone',
        'mobile' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\Telephone',
        'crit1' => 'string',
        'crit2' => 'string',
        'crit3' => 'string',
        'adresse' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectAdresse',
        'no' => 'int',
        'mail' => 'string',
        'refs_ext' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'ajouter_a_liste_diffusions' => 'int64',
        'retirer_de_liste_diffusions' => 'int64',
        'memo' => null,
        'code_magasin' => 'int32',
        'evenements' => null,
        'ident' => null,
        'nom' => null,
        'prenom' => null,
        'telephone' => null,
        'mobile' => null,
        'crit1' => null,
        'crit2' => null,
        'crit3' => null,
        'adresse' => null,
        'no' => 'int64',
        'mail' => null,
        'refs_ext' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'ajouter_a_liste_diffusions' => false,
        'retirer_de_liste_diffusions' => false,
        'memo' => false,
        'code_magasin' => true,
        'evenements' => false,
        'ident' => false,
        'nom' => false,
        'prenom' => false,
        'telephone' => false,
        'mobile' => false,
        'crit1' => false,
        'crit2' => false,
        'crit3' => false,
        'adresse' => false,
        'no' => true,
        'mail' => false,
        'refs_ext' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'ajouter_a_liste_diffusions' => 'AjouterAListeDiffusions',
        'retirer_de_liste_diffusions' => 'RetirerDeListeDiffusions',
        'memo' => 'Memo',
        'code_magasin' => 'CodeMagasin',
        'evenements' => 'Evenements',
        'ident' => 'Ident',
        'nom' => 'Nom',
        'prenom' => 'Prenom',
        'telephone' => 'Telephone',
        'mobile' => 'Mobile',
        'crit1' => 'Crit1',
        'crit2' => 'Crit2',
        'crit3' => 'Crit3',
        'adresse' => 'Adresse',
        'no' => 'No',
        'mail' => 'Mail',
        'refs_ext' => 'RefsExt'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'ajouter_a_liste_diffusions' => 'setAjouterAListeDiffusions',
        'retirer_de_liste_diffusions' => 'setRetirerDeListeDiffusions',
        'memo' => 'setMemo',
        'code_magasin' => 'setCodeMagasin',
        'evenements' => 'setEvenements',
        'ident' => 'setIdent',
        'nom' => 'setNom',
        'prenom' => 'setPrenom',
        'telephone' => 'setTelephone',
        'mobile' => 'setMobile',
        'crit1' => 'setCrit1',
        'crit2' => 'setCrit2',
        'crit3' => 'setCrit3',
        'adresse' => 'setAdresse',
        'no' => 'setNo',
        'mail' => 'setMail',
        'refs_ext' => 'setRefsExt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'ajouter_a_liste_diffusions' => 'getAjouterAListeDiffusions',
        'retirer_de_liste_diffusions' => 'getRetirerDeListeDiffusions',
        'memo' => 'getMemo',
        'code_magasin' => 'getCodeMagasin',
        'evenements' => 'getEvenements',
        'ident' => 'getIdent',
        'nom' => 'getNom',
        'prenom' => 'getPrenom',
        'telephone' => 'getTelephone',
        'mobile' => 'getMobile',
        'crit1' => 'getCrit1',
        'crit2' => 'getCrit2',
        'crit3' => 'getCrit3',
        'adresse' => 'getAdresse',
        'no' => 'getNo',
        'mail' => 'getMail',
        'refs_ext' => 'getRefsExt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('ajouter_a_liste_diffusions', $data ?? [], null);
        $this->setIfExists('retirer_de_liste_diffusions', $data ?? [], null);
        $this->setIfExists('memo', $data ?? [], null);
        $this->setIfExists('code_magasin', $data ?? [], null);
        $this->setIfExists('evenements', $data ?? [], null);
        $this->setIfExists('ident', $data ?? [], null);
        $this->setIfExists('nom', $data ?? [], null);
        $this->setIfExists('prenom', $data ?? [], null);
        $this->setIfExists('telephone', $data ?? [], null);
        $this->setIfExists('mobile', $data ?? [], null);
        $this->setIfExists('crit1', $data ?? [], null);
        $this->setIfExists('crit2', $data ?? [], null);
        $this->setIfExists('crit3', $data ?? [], null);
        $this->setIfExists('adresse', $data ?? [], null);
        $this->setIfExists('no', $data ?? [], null);
        $this->setIfExists('mail', $data ?? [], null);
        $this->setIfExists('refs_ext', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets ajouter_a_liste_diffusions
     *
     * @return int[]|null
     */
    public function getAjouterAListeDiffusions()
    {
        return $this->container['ajouter_a_liste_diffusions'];
    }

    /**
     * Sets ajouter_a_liste_diffusions
     *
     * @param int[]|null $ajouter_a_liste_diffusions Listes de diffusions auxsquelles il faut ajouter le client. Utilisez les valeurs suivantes :  MailingParCourrier = 16384 MailingParMail = 32768 MailingParSMS = 49152 MailingParTel = 81920 TicketParMail = 65536
     *
     * @return self
     */
    public function setAjouterAListeDiffusions($ajouter_a_liste_diffusions)
    {
        if (is_null($ajouter_a_liste_diffusions)) {
            throw new \InvalidArgumentException('non-nullable ajouter_a_liste_diffusions cannot be null');
        }
        $this->container['ajouter_a_liste_diffusions'] = $ajouter_a_liste_diffusions;

        return $this;
    }

    /**
     * Gets retirer_de_liste_diffusions
     *
     * @return int[]|null
     */
    public function getRetirerDeListeDiffusions()
    {
        return $this->container['retirer_de_liste_diffusions'];
    }

    /**
     * Sets retirer_de_liste_diffusions
     *
     * @param int[]|null $retirer_de_liste_diffusions Listes de diffusions desquelles retirer le client
     *
     * @return self
     */
    public function setRetirerDeListeDiffusions($retirer_de_liste_diffusions)
    {
        if (is_null($retirer_de_liste_diffusions)) {
            throw new \InvalidArgumentException('non-nullable retirer_de_liste_diffusions cannot be null');
        }
        $this->container['retirer_de_liste_diffusions'] = $retirer_de_liste_diffusions;

        return $this;
    }

    /**
     * Gets memo
     *
     * @return string|null
     */
    public function getMemo()
    {
        return $this->container['memo'];
    }

    /**
     * Sets memo
     *
     * @param string|null $memo Mémo    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setMemo($memo)
    {
        if (is_null($memo)) {
            throw new \InvalidArgumentException('non-nullable memo cannot be null');
        }
        $this->container['memo'] = $memo;

        return $this;
    }

    /**
     * Gets code_magasin
     *
     * @return int|null
     */
    public function getCodeMagasin()
    {
        return $this->container['code_magasin'];
    }

    /**
     * Sets code_magasin
     *
     * @param int|null $code_magasin Code du magasin auquel ce client est attaché    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodeMagasin($code_magasin)
    {
        if (is_null($code_magasin)) {
            array_push($this->openAPINullablesSetToNull, 'code_magasin');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('code_magasin', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['code_magasin'] = $code_magasin;

        return $this;
    }

    /**
     * Gets evenements
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientEvents|null
     */
    public function getEvenements()
    {
        return $this->container['evenements'];
    }

    /**
     * Sets evenements
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientEvents|null $evenements evenements
     *
     * @return self
     */
    public function setEvenements($evenements)
    {
        if (is_null($evenements)) {
            throw new \InvalidArgumentException('non-nullable evenements cannot be null');
        }
        $this->container['evenements'] = $evenements;

        return $this;
    }

    /**
     * Gets ident
     *
     * @return string|null
     */
    public function getIdent()
    {
        return $this->container['ident'];
    }

    /**
     * Sets ident
     *
     * @param string|null $ident Titre de civilité    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setIdent($ident)
    {
        if (is_null($ident)) {
            throw new \InvalidArgumentException('non-nullable ident cannot be null');
        }
        $this->container['ident'] = $ident;

        return $this;
    }

    /**
     * Gets nom
     *
     * @return string|null
     */
    public function getNom()
    {
        return $this->container['nom'];
    }

    /**
     * Sets nom
     *
     * @param string|null $nom Nom de famille    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setNom($nom)
    {
        if (is_null($nom)) {
            throw new \InvalidArgumentException('non-nullable nom cannot be null');
        }
        $this->container['nom'] = $nom;

        return $this;
    }

    /**
     * Gets prenom
     *
     * @return string|null
     */
    public function getPrenom()
    {
        return $this->container['prenom'];
    }

    /**
     * Sets prenom
     *
     * @param string|null $prenom Prénom    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPrenom($prenom)
    {
        if (is_null($prenom)) {
            throw new \InvalidArgumentException('non-nullable prenom cannot be null');
        }
        $this->container['prenom'] = $prenom;

        return $this;
    }

    /**
     * Gets telephone
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\Telephone|null
     */
    public function getTelephone()
    {
        return $this->container['telephone'];
    }

    /**
     * Sets telephone
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\Telephone|null $telephone telephone
     *
     * @return self
     */
    public function setTelephone($telephone)
    {
        if (is_null($telephone)) {
            throw new \InvalidArgumentException('non-nullable telephone cannot be null');
        }
        $this->container['telephone'] = $telephone;

        return $this;
    }

    /**
     * Gets mobile
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\Telephone|null
     */
    public function getMobile()
    {
        return $this->container['mobile'];
    }

    /**
     * Sets mobile
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\Telephone|null $mobile mobile
     *
     * @return self
     */
    public function setMobile($mobile)
    {
        if (is_null($mobile)) {
            throw new \InvalidArgumentException('non-nullable mobile cannot be null');
        }
        $this->container['mobile'] = $mobile;

        return $this;
    }

    /**
     * Gets crit1
     *
     * @return string|null
     */
    public function getCrit1()
    {
        return $this->container['crit1'];
    }

    /**
     * Sets crit1
     *
     * @param string|null $crit1 Critère client 1 : attention, ce champ doit être déclaré conformément au RGPD.
     *
     * @return self
     */
    public function setCrit1($crit1)
    {
        if (is_null($crit1)) {
            throw new \InvalidArgumentException('non-nullable crit1 cannot be null');
        }
        $this->container['crit1'] = $crit1;

        return $this;
    }

    /**
     * Gets crit2
     *
     * @return string|null
     */
    public function getCrit2()
    {
        return $this->container['crit2'];
    }

    /**
     * Sets crit2
     *
     * @param string|null $crit2 Critère client 2 : attention, ce champ doit être déclaré conformément au RGPD.
     *
     * @return self
     */
    public function setCrit2($crit2)
    {
        if (is_null($crit2)) {
            throw new \InvalidArgumentException('non-nullable crit2 cannot be null');
        }
        $this->container['crit2'] = $crit2;

        return $this;
    }

    /**
     * Gets crit3
     *
     * @return string|null
     */
    public function getCrit3()
    {
        return $this->container['crit3'];
    }

    /**
     * Sets crit3
     *
     * @param string|null $crit3 Critère client 3 : attention, ce champ doit être déclaré conformément au RGPD.
     *
     * @return self
     */
    public function setCrit3($crit3)
    {
        if (is_null($crit3)) {
            throw new \InvalidArgumentException('non-nullable crit3 cannot be null');
        }
        $this->container['crit3'] = $crit3;

        return $this;
    }

    /**
     * Gets adresse
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectAdresse|null
     */
    public function getAdresse()
    {
        return $this->container['adresse'];
    }

    /**
     * Sets adresse
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectAdresse|null $adresse adresse
     *
     * @return self
     */
    public function setAdresse($adresse)
    {
        if (is_null($adresse)) {
            throw new \InvalidArgumentException('non-nullable adresse cannot be null');
        }
        $this->container['adresse'] = $adresse;

        return $this;
    }

    /**
     * Gets no
     *
     * @return int|null
     */
    public function getNo()
    {
        return $this->container['no'];
    }

    /**
     * Sets no
     *
     * @param int|null $no Numéro interne du client (code client, en lecture seule uniquement)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setNo($no)
    {
        if (is_null($no)) {
            array_push($this->openAPINullablesSetToNull, 'no');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('no', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['no'] = $no;

        return $this;
    }

    /**
     * Gets mail
     *
     * @return string|null
     */
    public function getMail()
    {
        return $this->container['mail'];
    }

    /**
     * Sets mail
     *
     * @param string|null $mail Adresse mail du client    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setMail($mail)
    {
        if (is_null($mail)) {
            throw new \InvalidArgumentException('non-nullable mail cannot be null');
        }
        $this->container['mail'] = $mail;

        return $this;
    }

    /**
     * Gets refs_ext
     *
     * @return string[]|null
     */
    public function getRefsExt()
    {
        return $this->container['refs_ext'];
    }

    /**
     * Sets refs_ext
     *
     * @param string[]|null $refs_ext Vos références    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setRefsExt($refs_ext)
    {
        if (is_null($refs_ext)) {
            throw new \InvalidArgumentException('non-nullable refs_ext cannot be null');
        }
        $this->container['refs_ext'] = $refs_ext;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


