<?php
/**
 * Configuration
 * PHP version 7.2
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib;

use Http\Client\Common\Plugin;
use Http\Promise\Promise;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use function is_resource;

/**
 * Configuration Class Doc Comment
 * PHP version 7.2
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DebugPlugin implements Plugin
{

    /**
     * @var resource
     */
    private $output;

    /**
     * DebuggingPlugin constructor.
     *
     * @param resource $output
     */
    public function __construct($output)
    {
        if (!is_resource($output)) {
            throw new \InvalidArgumentException('debugging resource is not valid');
        }
        $this->output = $output;
    }

    public function handleRequest(RequestInterface $request, callable $next, callable $first): Promise
    {
        return $next($request)->then(
            function (ResponseInterface $response) use ($request) {
                $this->logSuccess($request, $response);

                return $response;
            },
            function (ClientExceptionInterface $exception) use ($request) {
                $this->logError($request, $exception);

                throw $exception;
            }
        );
    }

    private function logSuccess(RequestInterface $request, ResponseInterface $response): void
    {
        $methodAndPath = $request->getMethod() . ' ' . $request->getUri()->getPath();
        $protocol = $response->getProtocolVersion();
        $responseCode = $response->getStatusCode();
        \fprintf($this->output, '<%s HTTP/%s> %s', $methodAndPath, $protocol, $responseCode);
        \fwrite($this->output, "\n");
    }

    private function logError(RequestInterface $request, ClientExceptionInterface $exception): void
    {
        $methodAndPath = $request->getMethod() . ' ' . $request->getUri()->getPath();
        $protocol = $request->getProtocolVersion();
        $error = $exception->getMessage();
        $responseCode = $exception->getCode();
        \fprintf($this->output, '<%s HTTP/%s> %s %s', $methodAndPath, $responseCode, $error, $protocol);
        \fwrite($this->output, "\n");
    }
}