<?php
/**
 * MetierMarqueWebConnectMarque
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierMarqueWebConnectMarque Class Doc Comment
 *
 * @category Class
 * @description Marque de produits   (fullname : piu_GestionStock.Metier.BaseSetup.MetierMarque.WebConnectMarque)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierMarqueWebConnectMarque implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierMarque_WebConnectMarque';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'no' => 'int',
        'nom' => 'string',
        'main_photo' => 'int',
        'derniere_modification' => '\DateTime',
        'quarantaine' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'no' => 'int64',
        'nom' => null,
        'main_photo' => 'int64',
        'derniere_modification' => 'date-time',
        'quarantaine' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'no' => false,
        'nom' => false,
        'main_photo' => true,
        'derniere_modification' => false,
        'quarantaine' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'no' => 'No',
        'nom' => 'Nom',
        'main_photo' => 'MainPhoto',
        'derniere_modification' => 'DerniereModification',
        'quarantaine' => 'Quarantaine'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'no' => 'setNo',
        'nom' => 'setNom',
        'main_photo' => 'setMainPhoto',
        'derniere_modification' => 'setDerniereModification',
        'quarantaine' => 'setQuarantaine'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'no' => 'getNo',
        'nom' => 'getNom',
        'main_photo' => 'getMainPhoto',
        'derniere_modification' => 'getDerniereModification',
        'quarantaine' => 'getQuarantaine'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('no', $data ?? [], 0);
        $this->setIfExists('nom', $data ?? [], null);
        $this->setIfExists('main_photo', $data ?? [], null);
        $this->setIfExists('derniere_modification', $data ?? [], null);
        $this->setIfExists('quarantaine', $data ?? [], false);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets no
     *
     * @return int|null
     */
    public function getNo()
    {
        return $this->container['no'];
    }

    /**
     * Sets no
     *
     * @param int|null $no Numéro d'identification de la marque (unique)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setNo($no)
    {
        if (is_null($no)) {
            throw new \InvalidArgumentException('non-nullable no cannot be null');
        }
        $this->container['no'] = $no;

        return $this;
    }

    /**
     * Gets nom
     *
     * @return string|null
     */
    public function getNom()
    {
        return $this->container['nom'];
    }

    /**
     * Sets nom
     *
     * @param string|null $nom Nom de la marque    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setNom($nom)
    {
        if (is_null($nom)) {
            throw new \InvalidArgumentException('non-nullable nom cannot be null');
        }
        $this->container['nom'] = $nom;

        return $this;
    }

    /**
     * Gets main_photo
     *
     * @return int|null
     */
    public function getMainPhoto()
    {
        return $this->container['main_photo'];
    }

    /**
     * Sets main_photo
     *
     * @param int|null $main_photo Identifiant de la photo principale    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setMainPhoto($main_photo)
    {
        if (is_null($main_photo)) {
            array_push($this->openAPINullablesSetToNull, 'main_photo');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('main_photo', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['main_photo'] = $main_photo;

        return $this;
    }

    /**
     * Gets derniere_modification
     *
     * @return \DateTime|null
     */
    public function getDerniereModification()
    {
        return $this->container['derniere_modification'];
    }

    /**
     * Sets derniere_modification
     *
     * @param \DateTime|null $derniere_modification Date de la dernière modification de cette marque    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereModification($derniere_modification)
    {
        if (is_null($derniere_modification)) {
            throw new \InvalidArgumentException('non-nullable derniere_modification cannot be null');
        }
        $this->container['derniere_modification'] = $derniere_modification;

        return $this;
    }

    /**
     * Gets quarantaine
     *
     * @return bool|null
     */
    public function getQuarantaine()
    {
        return $this->container['quarantaine'];
    }

    /**
     * Sets quarantaine
     *
     * @param bool|null $quarantaine Vrai si la marque n'est plus utilisée et sera supprimée à terme    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setQuarantaine($quarantaine)
    {
        if (is_null($quarantaine)) {
            throw new \InvalidArgumentException('non-nullable quarantaine cannot be null');
        }
        $this->container['quarantaine'] = $quarantaine;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


