<?php
/**
 * FiltreProduit
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * FiltreProduit Class Doc Comment
 *
 * @category Class
 * @description Structure représentant un filtage du catalogue   (fullname : ApiCatalog.Model.FiltreProduit)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FiltreProduit implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FiltreProduit';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'no_produits' => 'int[]',
        'no_modeles' => 'int[]',
        'codes_ref' => 'int[]',
        'ref_ean_polaris' => 'int[]',
        'no_marques' => 'int[]',
        'no_classifications' => 'int[]',
        'no_magasins' => 'int[]',
        'no_tailles' => 'int[]',
        'no_collections' => 'int[]',
        'no_saisons' => 'int[]',
        'no_categories1' => 'int[]',
        'no_categories2' => 'int[]',
        'no_categories3' => 'int[]',
        'no_categories4' => 'int[]',
        'no_niveaux1' => 'int[]',
        'no_niveaux2' => 'int[]',
        'no_niveaux3' => 'int[]',
        'no_niveaux4' => 'int[]',
        'tailles' => 'string[]',
        'en_ligne' => 'bool',
        'avec_stock' => 'bool',
        'avec_photo' => 'bool',
        'recherche_txt' => 'string',
        'derniere_date_modif' => '\DateTime',
        'derniere_date_changement' => '\DateTime',
        'type_media' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TypeMedia'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'no_produits' => 'int64',
        'no_modeles' => 'int64',
        'codes_ref' => 'int64',
        'ref_ean_polaris' => 'int64',
        'no_marques' => 'int64',
        'no_classifications' => 'int64',
        'no_magasins' => 'int64',
        'no_tailles' => 'int64',
        'no_collections' => 'int64',
        'no_saisons' => 'int64',
        'no_categories1' => 'int64',
        'no_categories2' => 'int64',
        'no_categories3' => 'int64',
        'no_categories4' => 'int64',
        'no_niveaux1' => 'int64',
        'no_niveaux2' => 'int64',
        'no_niveaux3' => 'int64',
        'no_niveaux4' => 'int64',
        'tailles' => null,
        'en_ligne' => null,
        'avec_stock' => null,
        'avec_photo' => null,
        'recherche_txt' => null,
        'derniere_date_modif' => 'date-time',
        'derniere_date_changement' => 'date-time',
        'type_media' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'no_produits' => false,
        'no_modeles' => false,
        'codes_ref' => false,
        'ref_ean_polaris' => false,
        'no_marques' => false,
        'no_classifications' => false,
        'no_magasins' => false,
        'no_tailles' => false,
        'no_collections' => false,
        'no_saisons' => false,
        'no_categories1' => false,
        'no_categories2' => false,
        'no_categories3' => false,
        'no_categories4' => false,
        'no_niveaux1' => false,
        'no_niveaux2' => false,
        'no_niveaux3' => false,
        'no_niveaux4' => false,
        'tailles' => false,
        'en_ligne' => false,
        'avec_stock' => false,
        'avec_photo' => false,
        'recherche_txt' => false,
        'derniere_date_modif' => true,
        'derniere_date_changement' => true,
        'type_media' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'no_produits' => 'NoProduits',
        'no_modeles' => 'NoModeles',
        'codes_ref' => 'CodesRef',
        'ref_ean_polaris' => 'RefEanPolaris',
        'no_marques' => 'NoMarques',
        'no_classifications' => 'NoClassifications',
        'no_magasins' => 'NoMagasins',
        'no_tailles' => 'NoTailles',
        'no_collections' => 'NoCollections',
        'no_saisons' => 'NoSaisons',
        'no_categories1' => 'NoCategories1',
        'no_categories2' => 'NoCategories2',
        'no_categories3' => 'NoCategories3',
        'no_categories4' => 'NoCategories4',
        'no_niveaux1' => 'NoNiveaux1',
        'no_niveaux2' => 'NoNiveaux2',
        'no_niveaux3' => 'NoNiveaux3',
        'no_niveaux4' => 'NoNiveaux4',
        'tailles' => 'Tailles',
        'en_ligne' => 'EnLigne',
        'avec_stock' => 'AvecStock',
        'avec_photo' => 'AvecPhoto',
        'recherche_txt' => 'RechercheTxt',
        'derniere_date_modif' => 'DerniereDateModif',
        'derniere_date_changement' => 'DerniereDateChangement',
        'type_media' => 'TypeMedia'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'no_produits' => 'setNoProduits',
        'no_modeles' => 'setNoModeles',
        'codes_ref' => 'setCodesRef',
        'ref_ean_polaris' => 'setRefEanPolaris',
        'no_marques' => 'setNoMarques',
        'no_classifications' => 'setNoClassifications',
        'no_magasins' => 'setNoMagasins',
        'no_tailles' => 'setNoTailles',
        'no_collections' => 'setNoCollections',
        'no_saisons' => 'setNoSaisons',
        'no_categories1' => 'setNoCategories1',
        'no_categories2' => 'setNoCategories2',
        'no_categories3' => 'setNoCategories3',
        'no_categories4' => 'setNoCategories4',
        'no_niveaux1' => 'setNoNiveaux1',
        'no_niveaux2' => 'setNoNiveaux2',
        'no_niveaux3' => 'setNoNiveaux3',
        'no_niveaux4' => 'setNoNiveaux4',
        'tailles' => 'setTailles',
        'en_ligne' => 'setEnLigne',
        'avec_stock' => 'setAvecStock',
        'avec_photo' => 'setAvecPhoto',
        'recherche_txt' => 'setRechercheTxt',
        'derniere_date_modif' => 'setDerniereDateModif',
        'derniere_date_changement' => 'setDerniereDateChangement',
        'type_media' => 'setTypeMedia'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'no_produits' => 'getNoProduits',
        'no_modeles' => 'getNoModeles',
        'codes_ref' => 'getCodesRef',
        'ref_ean_polaris' => 'getRefEanPolaris',
        'no_marques' => 'getNoMarques',
        'no_classifications' => 'getNoClassifications',
        'no_magasins' => 'getNoMagasins',
        'no_tailles' => 'getNoTailles',
        'no_collections' => 'getNoCollections',
        'no_saisons' => 'getNoSaisons',
        'no_categories1' => 'getNoCategories1',
        'no_categories2' => 'getNoCategories2',
        'no_categories3' => 'getNoCategories3',
        'no_categories4' => 'getNoCategories4',
        'no_niveaux1' => 'getNoNiveaux1',
        'no_niveaux2' => 'getNoNiveaux2',
        'no_niveaux3' => 'getNoNiveaux3',
        'no_niveaux4' => 'getNoNiveaux4',
        'tailles' => 'getTailles',
        'en_ligne' => 'getEnLigne',
        'avec_stock' => 'getAvecStock',
        'avec_photo' => 'getAvecPhoto',
        'recherche_txt' => 'getRechercheTxt',
        'derniere_date_modif' => 'getDerniereDateModif',
        'derniere_date_changement' => 'getDerniereDateChangement',
        'type_media' => 'getTypeMedia'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('no_produits', $data ?? [], null);
        $this->setIfExists('no_modeles', $data ?? [], null);
        $this->setIfExists('codes_ref', $data ?? [], null);
        $this->setIfExists('ref_ean_polaris', $data ?? [], null);
        $this->setIfExists('no_marques', $data ?? [], null);
        $this->setIfExists('no_classifications', $data ?? [], null);
        $this->setIfExists('no_magasins', $data ?? [], null);
        $this->setIfExists('no_tailles', $data ?? [], null);
        $this->setIfExists('no_collections', $data ?? [], null);
        $this->setIfExists('no_saisons', $data ?? [], null);
        $this->setIfExists('no_categories1', $data ?? [], null);
        $this->setIfExists('no_categories2', $data ?? [], null);
        $this->setIfExists('no_categories3', $data ?? [], null);
        $this->setIfExists('no_categories4', $data ?? [], null);
        $this->setIfExists('no_niveaux1', $data ?? [], null);
        $this->setIfExists('no_niveaux2', $data ?? [], null);
        $this->setIfExists('no_niveaux3', $data ?? [], null);
        $this->setIfExists('no_niveaux4', $data ?? [], null);
        $this->setIfExists('tailles', $data ?? [], null);
        $this->setIfExists('en_ligne', $data ?? [], false);
        $this->setIfExists('avec_stock', $data ?? [], false);
        $this->setIfExists('avec_photo', $data ?? [], false);
        $this->setIfExists('recherche_txt', $data ?? [], null);
        $this->setIfExists('derniere_date_modif', $data ?? [], null);
        $this->setIfExists('derniere_date_changement', $data ?? [], null);
        $this->setIfExists('type_media', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets no_produits
     *
     * @return int[]|null
     */
    public function getNoProduits()
    {
        return $this->container['no_produits'];
    }

    /**
     * Sets no_produits
     *
     * @param int[]|null $no_produits Filtre les produits spécifiés par numéro d'identification (numéro interne de la déclinaison du modèle - unique)
     *
     * @return self
     */
    public function setNoProduits($no_produits)
    {
        if (is_null($no_produits)) {
            throw new \InvalidArgumentException('non-nullable no_produits cannot be null');
        }
        $this->container['no_produits'] = $no_produits;

        return $this;
    }

    /**
     * Gets no_modeles
     *
     * @return int[]|null
     */
    public function getNoModeles()
    {
        return $this->container['no_modeles'];
    }

    /**
     * Sets no_modeles
     *
     * @param int[]|null $no_modeles Filtre les produits spécifiés par numéro d'identification de leur modèle
     *
     * @return self
     */
    public function setNoModeles($no_modeles)
    {
        if (is_null($no_modeles)) {
            throw new \InvalidArgumentException('non-nullable no_modeles cannot be null');
        }
        $this->container['no_modeles'] = $no_modeles;

        return $this;
    }

    /**
     * Gets codes_ref
     *
     * @return int[]|null
     */
    public function getCodesRef()
    {
        return $this->container['codes_ref'];
    }

    /**
     * Sets codes_ref
     *
     * @param int[]|null $codes_ref Filtre les produits spécifiés par leur code de référence alternatif, si fonctionnalité activée dans Polaris
     *
     * @return self
     */
    public function setCodesRef($codes_ref)
    {
        if (is_null($codes_ref)) {
            throw new \InvalidArgumentException('non-nullable codes_ref cannot be null');
        }
        $this->container['codes_ref'] = $codes_ref;

        return $this;
    }

    /**
     * Gets ref_ean_polaris
     *
     * @return int[]|null
     */
    public function getRefEanPolaris()
    {
        return $this->container['ref_ean_polaris'];
    }

    /**
     * Sets ref_ean_polaris
     *
     * @param int[]|null $ref_ean_polaris Filtre les produits spécifiés par code barres Polaris
     *
     * @return self
     */
    public function setRefEanPolaris($ref_ean_polaris)
    {
        if (is_null($ref_ean_polaris)) {
            throw new \InvalidArgumentException('non-nullable ref_ean_polaris cannot be null');
        }
        $this->container['ref_ean_polaris'] = $ref_ean_polaris;

        return $this;
    }

    /**
     * Gets no_marques
     *
     * @return int[]|null
     */
    public function getNoMarques()
    {
        return $this->container['no_marques'];
    }

    /**
     * Sets no_marques
     *
     * @param int[]|null $no_marques Filtre les marques spécifiées
     *
     * @return self
     */
    public function setNoMarques($no_marques)
    {
        if (is_null($no_marques)) {
            throw new \InvalidArgumentException('non-nullable no_marques cannot be null');
        }
        $this->container['no_marques'] = $no_marques;

        return $this;
    }

    /**
     * Gets no_classifications
     *
     * @return int[]|null
     */
    public function getNoClassifications()
    {
        return $this->container['no_classifications'];
    }

    /**
     * Sets no_classifications
     *
     * @param int[]|null $no_classifications Filtre les classifications spécifiées
     *
     * @return self
     */
    public function setNoClassifications($no_classifications)
    {
        if (is_null($no_classifications)) {
            throw new \InvalidArgumentException('non-nullable no_classifications cannot be null');
        }
        $this->container['no_classifications'] = $no_classifications;

        return $this;
    }

    /**
     * Gets no_magasins
     *
     * @return int[]|null
     */
    public function getNoMagasins()
    {
        return $this->container['no_magasins'];
    }

    /**
     * Sets no_magasins
     *
     * @param int[]|null $no_magasins Filtre les magasins spécifiés
     *
     * @return self
     */
    public function setNoMagasins($no_magasins)
    {
        if (is_null($no_magasins)) {
            throw new \InvalidArgumentException('non-nullable no_magasins cannot be null');
        }
        $this->container['no_magasins'] = $no_magasins;

        return $this;
    }

    /**
     * Gets no_tailles
     *
     * @return int[]|null
     */
    public function getNoTailles()
    {
        return $this->container['no_tailles'];
    }

    /**
     * Sets no_tailles
     *
     * @param int[]|null $no_tailles Filtre sur les tailles spécifiées
     *
     * @return self
     */
    public function setNoTailles($no_tailles)
    {
        if (is_null($no_tailles)) {
            throw new \InvalidArgumentException('non-nullable no_tailles cannot be null');
        }
        $this->container['no_tailles'] = $no_tailles;

        return $this;
    }

    /**
     * Gets no_collections
     *
     * @return int[]|null
     */
    public function getNoCollections()
    {
        return $this->container['no_collections'];
    }

    /**
     * Sets no_collections
     *
     * @param int[]|null $no_collections Filtre sur les collections spécifiés
     *
     * @return self
     */
    public function setNoCollections($no_collections)
    {
        if (is_null($no_collections)) {
            throw new \InvalidArgumentException('non-nullable no_collections cannot be null');
        }
        $this->container['no_collections'] = $no_collections;

        return $this;
    }

    /**
     * Gets no_saisons
     *
     * @return int[]|null
     */
    public function getNoSaisons()
    {
        return $this->container['no_saisons'];
    }

    /**
     * Sets no_saisons
     *
     * @param int[]|null $no_saisons Filtre sur les saisons spécifiés
     *
     * @return self
     */
    public function setNoSaisons($no_saisons)
    {
        if (is_null($no_saisons)) {
            throw new \InvalidArgumentException('non-nullable no_saisons cannot be null');
        }
        $this->container['no_saisons'] = $no_saisons;

        return $this;
    }

    /**
     * Gets no_categories1
     *
     * @return int[]|null
     */
    public function getNoCategories1()
    {
        return $this->container['no_categories1'];
    }

    /**
     * Sets no_categories1
     *
     * @param int[]|null $no_categories1 Filtre sur les catégories de type 1 spécifiées
     *
     * @return self
     */
    public function setNoCategories1($no_categories1)
    {
        if (is_null($no_categories1)) {
            throw new \InvalidArgumentException('non-nullable no_categories1 cannot be null');
        }
        $this->container['no_categories1'] = $no_categories1;

        return $this;
    }

    /**
     * Gets no_categories2
     *
     * @return int[]|null
     */
    public function getNoCategories2()
    {
        return $this->container['no_categories2'];
    }

    /**
     * Sets no_categories2
     *
     * @param int[]|null $no_categories2 Filtre sur les catégories de type 2 spécifiées
     *
     * @return self
     */
    public function setNoCategories2($no_categories2)
    {
        if (is_null($no_categories2)) {
            throw new \InvalidArgumentException('non-nullable no_categories2 cannot be null');
        }
        $this->container['no_categories2'] = $no_categories2;

        return $this;
    }

    /**
     * Gets no_categories3
     *
     * @return int[]|null
     */
    public function getNoCategories3()
    {
        return $this->container['no_categories3'];
    }

    /**
     * Sets no_categories3
     *
     * @param int[]|null $no_categories3 Filtre sur les catégories de type 3 spécifiées
     *
     * @return self
     */
    public function setNoCategories3($no_categories3)
    {
        if (is_null($no_categories3)) {
            throw new \InvalidArgumentException('non-nullable no_categories3 cannot be null');
        }
        $this->container['no_categories3'] = $no_categories3;

        return $this;
    }

    /**
     * Gets no_categories4
     *
     * @return int[]|null
     */
    public function getNoCategories4()
    {
        return $this->container['no_categories4'];
    }

    /**
     * Sets no_categories4
     *
     * @param int[]|null $no_categories4 Filtre sur les catégories de type 4 spécifiées
     *
     * @return self
     */
    public function setNoCategories4($no_categories4)
    {
        if (is_null($no_categories4)) {
            throw new \InvalidArgumentException('non-nullable no_categories4 cannot be null');
        }
        $this->container['no_categories4'] = $no_categories4;

        return $this;
    }

    /**
     * Gets no_niveaux1
     *
     * @return int[]|null
     */
    public function getNoNiveaux1()
    {
        return $this->container['no_niveaux1'];
    }

    /**
     * Sets no_niveaux1
     *
     * @param int[]|null $no_niveaux1 Filtre sur les niveaux de type 1 spécifiés
     *
     * @return self
     */
    public function setNoNiveaux1($no_niveaux1)
    {
        if (is_null($no_niveaux1)) {
            throw new \InvalidArgumentException('non-nullable no_niveaux1 cannot be null');
        }
        $this->container['no_niveaux1'] = $no_niveaux1;

        return $this;
    }

    /**
     * Gets no_niveaux2
     *
     * @return int[]|null
     */
    public function getNoNiveaux2()
    {
        return $this->container['no_niveaux2'];
    }

    /**
     * Sets no_niveaux2
     *
     * @param int[]|null $no_niveaux2 Filtre sur les niveaux de type 2 spécifiés
     *
     * @return self
     */
    public function setNoNiveaux2($no_niveaux2)
    {
        if (is_null($no_niveaux2)) {
            throw new \InvalidArgumentException('non-nullable no_niveaux2 cannot be null');
        }
        $this->container['no_niveaux2'] = $no_niveaux2;

        return $this;
    }

    /**
     * Gets no_niveaux3
     *
     * @return int[]|null
     */
    public function getNoNiveaux3()
    {
        return $this->container['no_niveaux3'];
    }

    /**
     * Sets no_niveaux3
     *
     * @param int[]|null $no_niveaux3 Filtre sur les niveaux de type 3 spécifiés
     *
     * @return self
     */
    public function setNoNiveaux3($no_niveaux3)
    {
        if (is_null($no_niveaux3)) {
            throw new \InvalidArgumentException('non-nullable no_niveaux3 cannot be null');
        }
        $this->container['no_niveaux3'] = $no_niveaux3;

        return $this;
    }

    /**
     * Gets no_niveaux4
     *
     * @return int[]|null
     */
    public function getNoNiveaux4()
    {
        return $this->container['no_niveaux4'];
    }

    /**
     * Sets no_niveaux4
     *
     * @param int[]|null $no_niveaux4 Filtre sur les niveaux de type 4 spécifiés
     *
     * @return self
     */
    public function setNoNiveaux4($no_niveaux4)
    {
        if (is_null($no_niveaux4)) {
            throw new \InvalidArgumentException('non-nullable no_niveaux4 cannot be null');
        }
        $this->container['no_niveaux4'] = $no_niveaux4;

        return $this;
    }

    /**
     * Gets tailles
     *
     * @return string[]|null
     */
    public function getTailles()
    {
        return $this->container['tailles'];
    }

    /**
     * Sets tailles
     *
     * @param string[]|null $tailles Filtre sur les tailles aux noms spécifiés
     *
     * @return self
     */
    public function setTailles($tailles)
    {
        if (is_null($tailles)) {
            throw new \InvalidArgumentException('non-nullable tailles cannot be null');
        }
        $this->container['tailles'] = $tailles;

        return $this;
    }

    /**
     * Gets en_ligne
     *
     * @return bool|null
     */
    public function getEnLigne()
    {
        return $this->container['en_ligne'];
    }

    /**
     * Sets en_ligne
     *
     * @param bool|null $en_ligne Uniquement les références marquées comme étant publiées sur le site Internet. [obsolète : selon la configuration, les produits ne sont plus visibles lorsqu'ils sont dépubliés. Utilisez plutôt le Endpoint ProduitInvalides pour tirer les produits qui ne sont plus en ligne !]
     *
     * @return self
     */
    public function setEnLigne($en_ligne)
    {
        if (is_null($en_ligne)) {
            throw new \InvalidArgumentException('non-nullable en_ligne cannot be null');
        }
        $this->container['en_ligne'] = $en_ligne;

        return $this;
    }

    /**
     * Gets avec_stock
     *
     * @return bool|null
     */
    public function getAvecStock()
    {
        return $this->container['avec_stock'];
    }

    /**
     * Sets avec_stock
     *
     * @param bool|null $avec_stock Filtre sur les articles en stock uniquement
     *
     * @return self
     */
    public function setAvecStock($avec_stock)
    {
        if (is_null($avec_stock)) {
            throw new \InvalidArgumentException('non-nullable avec_stock cannot be null');
        }
        $this->container['avec_stock'] = $avec_stock;

        return $this;
    }

    /**
     * Gets avec_photo
     *
     * @return bool|null
     */
    public function getAvecPhoto()
    {
        return $this->container['avec_photo'];
    }

    /**
     * Sets avec_photo
     *
     * @param bool|null $avec_photo Filtre les articles qui ont une photo
     *
     * @return self
     */
    public function setAvecPhoto($avec_photo)
    {
        if (is_null($avec_photo)) {
            throw new \InvalidArgumentException('non-nullable avec_photo cannot be null');
        }
        $this->container['avec_photo'] = $avec_photo;

        return $this;
    }

    /**
     * Gets recherche_txt
     *
     * @return string|null
     */
    public function getRechercheTxt()
    {
        return $this->container['recherche_txt'];
    }

    /**
     * Sets recherche_txt
     *
     * @param string|null $recherche_txt Recherche sur les mots clés
     *
     * @return self
     */
    public function setRechercheTxt($recherche_txt)
    {
        if (is_null($recherche_txt)) {
            throw new \InvalidArgumentException('non-nullable recherche_txt cannot be null');
        }
        $this->container['recherche_txt'] = $recherche_txt;

        return $this;
    }

    /**
     * Gets derniere_date_modif
     *
     * @return \DateTime|null
     */
    public function getDerniereDateModif()
    {
        return $this->container['derniere_date_modif'];
    }

    /**
     * Sets derniere_date_modif
     *
     * @param \DateTime|null $derniere_date_modif Ne renvoyer que les produits modifiés depuis la date spécifiée
     *
     * @return self
     */
    public function setDerniereDateModif($derniere_date_modif)
    {
        if (is_null($derniere_date_modif)) {
            array_push($this->openAPINullablesSetToNull, 'derniere_date_modif');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('derniere_date_modif', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['derniere_date_modif'] = $derniere_date_modif;

        return $this;
    }

    /**
     * Gets derniere_date_changement
     *
     * @return \DateTime|null
     */
    public function getDerniereDateChangement()
    {
        return $this->container['derniere_date_changement'];
    }

    /**
     * Sets derniere_date_changement
     *
     * @param \DateTime|null $derniere_date_changement Ne renvoyer que les produits modifiés, prix et stock depuis la date spécifiée
     *
     * @return self
     */
    public function setDerniereDateChangement($derniere_date_changement)
    {
        if (is_null($derniere_date_changement)) {
            array_push($this->openAPINullablesSetToNull, 'derniere_date_changement');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('derniere_date_changement', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['derniere_date_changement'] = $derniere_date_changement;

        return $this;
    }

    /**
     * Gets type_media
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TypeMedia|null
     */
    public function getTypeMedia()
    {
        return $this->container['type_media'];
    }

    /**
     * Sets type_media
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TypeMedia|null $type_media type_media
     *
     * @return self
     */
    public function setTypeMedia($type_media)
    {
        if (is_null($type_media)) {
            throw new \InvalidArgumentException('non-nullable type_media cannot be null');
        }
        $this->container['type_media'] = $type_media;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


