<?php
/**
 * MetierBonWebConnectBonClientUpdateable
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierBonWebConnectBonClientUpdateable Class Doc Comment
 *
 * @category Class
 * @description (fullname : piu_GestionStock.Metier.Vente.MetierBon.WebConnectBonClientUpdateable)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierBonWebConnectBonClientUpdateable implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierBon_WebConnectBonClientUpdateable';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'client' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientId',
        'ref_ext' => 'string',
        'libelle' => 'string',
        'type' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TTypeBon',
        'montant' => 'float',
        'pourcentage' => 'float',
        'date_validite' => '\DateTime',
        'plus_cher' => 'bool',
        'seuil' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'client' => null,
        'ref_ext' => null,
        'libelle' => null,
        'type' => null,
        'montant' => 'decimal',
        'pourcentage' => 'decimal',
        'date_validite' => 'date-time',
        'plus_cher' => null,
        'seuil' => 'decimal'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'client' => false,
        'ref_ext' => false,
        'libelle' => false,
        'type' => false,
        'montant' => true,
        'pourcentage' => true,
        'date_validite' => true,
        'plus_cher' => true,
        'seuil' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'client' => 'Client',
        'ref_ext' => 'RefExt',
        'libelle' => 'Libelle',
        'type' => 'Type',
        'montant' => 'Montant',
        'pourcentage' => 'Pourcentage',
        'date_validite' => 'DateValidite',
        'plus_cher' => 'PlusCher',
        'seuil' => 'Seuil'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'client' => 'setClient',
        'ref_ext' => 'setRefExt',
        'libelle' => 'setLibelle',
        'type' => 'setType',
        'montant' => 'setMontant',
        'pourcentage' => 'setPourcentage',
        'date_validite' => 'setDateValidite',
        'plus_cher' => 'setPlusCher',
        'seuil' => 'setSeuil'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'client' => 'getClient',
        'ref_ext' => 'getRefExt',
        'libelle' => 'getLibelle',
        'type' => 'getType',
        'montant' => 'getMontant',
        'pourcentage' => 'getPourcentage',
        'date_validite' => 'getDateValidite',
        'plus_cher' => 'getPlusCher',
        'seuil' => 'getSeuil'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('client', $data ?? [], null);
        $this->setIfExists('ref_ext', $data ?? [], null);
        $this->setIfExists('libelle', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('montant', $data ?? [], null);
        $this->setIfExists('pourcentage', $data ?? [], null);
        $this->setIfExists('date_validite', $data ?? [], null);
        $this->setIfExists('plus_cher', $data ?? [], null);
        $this->setIfExists('seuil', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets client
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientId|null
     */
    public function getClient()
    {
        return $this->container['client'];
    }

    /**
     * Sets client
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientId|null $client client
     *
     * @return self
     */
    public function setClient($client)
    {
        if (is_null($client)) {
            throw new \InvalidArgumentException('non-nullable client cannot be null');
        }
        $this->container['client'] = $client;

        return $this;
    }

    /**
     * Gets ref_ext
     *
     * @return string|null
     */
    public function getRefExt()
    {
        return $this->container['ref_ext'];
    }

    /**
     * Sets ref_ext
     *
     * @param string|null $ref_ext Votre référence de bon
     *
     * @return self
     */
    public function setRefExt($ref_ext)
    {
        if (is_null($ref_ext)) {
            throw new \InvalidArgumentException('non-nullable ref_ext cannot be null');
        }
        $this->container['ref_ext'] = $ref_ext;

        return $this;
    }

    /**
     * Gets libelle
     *
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->container['libelle'];
    }

    /**
     * Sets libelle
     *
     * @param string|null $libelle Libellé du bon
     *
     * @return self
     */
    public function setLibelle($libelle)
    {
        if (is_null($libelle)) {
            throw new \InvalidArgumentException('non-nullable libelle cannot be null');
        }
        $this->container['libelle'] = $libelle;

        return $this;
    }

    /**
     * Gets type
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TTypeBon|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\TTypeBon|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets montant
     *
     * @return float|null
     */
    public function getMontant()
    {
        return $this->container['montant'];
    }

    /**
     * Sets montant
     *
     * @param float|null $montant Valeur du bon si le bon est un bon de type montant (pourcentage est nul)
     *
     * @return self
     */
    public function setMontant($montant)
    {
        if (is_null($montant)) {
            array_push($this->openAPINullablesSetToNull, 'montant');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('montant', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['montant'] = $montant;

        return $this;
    }

    /**
     * Gets pourcentage
     *
     * @return float|null
     */
    public function getPourcentage()
    {
        return $this->container['pourcentage'];
    }

    /**
     * Sets pourcentage
     *
     * @param float|null $pourcentage Pourcentage de remise accordée par le bon si le bon est de type pourcentage (montant est nul).
     *
     * @return self
     */
    public function setPourcentage($pourcentage)
    {
        if (is_null($pourcentage)) {
            array_push($this->openAPINullablesSetToNull, 'pourcentage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('pourcentage', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['pourcentage'] = $pourcentage;

        return $this;
    }

    /**
     * Gets date_validite
     *
     * @return \DateTime|null
     */
    public function getDateValidite()
    {
        return $this->container['date_validite'];
    }

    /**
     * Sets date_validite
     *
     * @param \DateTime|null $date_validite Date de validité sur les bons qui ont une durée de vie
     *
     * @return self
     */
    public function setDateValidite($date_validite)
    {
        if (is_null($date_validite)) {
            array_push($this->openAPINullablesSetToNull, 'date_validite');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_validite', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_validite'] = $date_validite;

        return $this;
    }

    /**
     * Gets plus_cher
     *
     * @return bool|null
     */
    public function getPlusCher()
    {
        return $this->container['plus_cher'];
    }

    /**
     * Sets plus_cher
     *
     * @param bool|null $plus_cher Le pourcentage est sur l'article le plus cher
     *
     * @return self
     */
    public function setPlusCher($plus_cher)
    {
        if (is_null($plus_cher)) {
            array_push($this->openAPINullablesSetToNull, 'plus_cher');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('plus_cher', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['plus_cher'] = $plus_cher;

        return $this;
    }

    /**
     * Gets seuil
     *
     * @return float|null
     */
    public function getSeuil()
    {
        return $this->container['seuil'];
    }

    /**
     * Sets seuil
     *
     * @param float|null $seuil Seuil d'activation
     *
     * @return self
     */
    public function setSeuil($seuil)
    {
        if (is_null($seuil)) {
            array_push($this->openAPINullablesSetToNull, 'seuil');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('seuil', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['seuil'] = $seuil;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


