<?php
/**
 * InfoCatalogue
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * InfoCatalogue Class Doc Comment
 *
 * @category Class
 * @description Informations sur le catalogue   (fullname : ApiPolaris.WebConnect.Models.InfoCatalogue)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class InfoCatalogue implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InfoCatalogue';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'nom' => 'string',
        'img_ratio' => 'float',
        'mode_gestion' => 'bool',
        'big_show' => 'bool',
        'theme_primary_color' => 'string',
        'theme_secondary_color' => 'string',
        'theme_accent_color' => 'string',
        'infos' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\InfoConnect'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'nom' => null,
        'img_ratio' => 'float',
        'mode_gestion' => null,
        'big_show' => null,
        'theme_primary_color' => null,
        'theme_secondary_color' => null,
        'theme_accent_color' => null,
        'infos' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'nom' => false,
        'img_ratio' => false,
        'mode_gestion' => false,
        'big_show' => false,
        'theme_primary_color' => false,
        'theme_secondary_color' => false,
        'theme_accent_color' => false,
        'infos' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'nom' => 'Nom',
        'img_ratio' => 'ImgRatio',
        'mode_gestion' => 'ModeGestion',
        'big_show' => 'BigShow',
        'theme_primary_color' => 'ThemePrimaryColor',
        'theme_secondary_color' => 'ThemeSecondaryColor',
        'theme_accent_color' => 'ThemeAccentColor',
        'infos' => 'Infos'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'nom' => 'setNom',
        'img_ratio' => 'setImgRatio',
        'mode_gestion' => 'setModeGestion',
        'big_show' => 'setBigShow',
        'theme_primary_color' => 'setThemePrimaryColor',
        'theme_secondary_color' => 'setThemeSecondaryColor',
        'theme_accent_color' => 'setThemeAccentColor',
        'infos' => 'setInfos'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'nom' => 'getNom',
        'img_ratio' => 'getImgRatio',
        'mode_gestion' => 'getModeGestion',
        'big_show' => 'getBigShow',
        'theme_primary_color' => 'getThemePrimaryColor',
        'theme_secondary_color' => 'getThemeSecondaryColor',
        'theme_accent_color' => 'getThemeAccentColor',
        'infos' => 'getInfos'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('nom', $data ?? [], null);
        $this->setIfExists('img_ratio', $data ?? [], null);
        $this->setIfExists('mode_gestion', $data ?? [], false);
        $this->setIfExists('big_show', $data ?? [], false);
        $this->setIfExists('theme_primary_color', $data ?? [], null);
        $this->setIfExists('theme_secondary_color', $data ?? [], null);
        $this->setIfExists('theme_accent_color', $data ?? [], null);
        $this->setIfExists('infos', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets nom
     *
     * @return string|null
     */
    public function getNom()
    {
        return $this->container['nom'];
    }

    /**
     * Sets nom
     *
     * @param string|null $nom Nom du catalogue
     *
     * @return self
     */
    public function setNom($nom)
    {
        if (is_null($nom)) {
            throw new \InvalidArgumentException('non-nullable nom cannot be null');
        }
        $this->container['nom'] = $nom;

        return $this;
    }

    /**
     * Gets img_ratio
     *
     * @return float|null
     */
    public function getImgRatio()
    {
        return $this->container['img_ratio'];
    }

    /**
     * Sets img_ratio
     *
     * @param float|null $img_ratio Ratio des images
     *
     * @return self
     */
    public function setImgRatio($img_ratio)
    {
        if (is_null($img_ratio)) {
            throw new \InvalidArgumentException('non-nullable img_ratio cannot be null');
        }
        $this->container['img_ratio'] = $img_ratio;

        return $this;
    }

    /**
     * Gets mode_gestion
     *
     * @return bool|null
     */
    public function getModeGestion()
    {
        return $this->container['mode_gestion'];
    }

    /**
     * Sets mode_gestion
     *
     * @param bool|null $mode_gestion Mode gestion activé : l'utilitaire s'adresse au personnel du magasin plutôt qu'à sa clientèle
     *
     * @return self
     */
    public function setModeGestion($mode_gestion)
    {
        if (is_null($mode_gestion)) {
            throw new \InvalidArgumentException('non-nullable mode_gestion cannot be null');
        }
        $this->container['mode_gestion'] = $mode_gestion;

        return $this;
    }

    /**
     * Gets big_show
     *
     * @return bool|null
     */
    public function getBigShow()
    {
        return $this->container['big_show'];
    }

    /**
     * Sets big_show
     *
     * @param bool|null $big_show Diminue le nombre de colonnes à l'écran pour permettre l'affichage de photo plus grande
     *
     * @return self
     */
    public function setBigShow($big_show)
    {
        if (is_null($big_show)) {
            throw new \InvalidArgumentException('non-nullable big_show cannot be null');
        }
        $this->container['big_show'] = $big_show;

        return $this;
    }

    /**
     * Gets theme_primary_color
     *
     * @return string|null
     */
    public function getThemePrimaryColor()
    {
        return $this->container['theme_primary_color'];
    }

    /**
     * Sets theme_primary_color
     *
     * @param string|null $theme_primary_color Couleur principale du thème
     *
     * @return self
     */
    public function setThemePrimaryColor($theme_primary_color)
    {
        if (is_null($theme_primary_color)) {
            throw new \InvalidArgumentException('non-nullable theme_primary_color cannot be null');
        }
        $this->container['theme_primary_color'] = $theme_primary_color;

        return $this;
    }

    /**
     * Gets theme_secondary_color
     *
     * @return string|null
     */
    public function getThemeSecondaryColor()
    {
        return $this->container['theme_secondary_color'];
    }

    /**
     * Sets theme_secondary_color
     *
     * @param string|null $theme_secondary_color Couleur secondaire du thème
     *
     * @return self
     */
    public function setThemeSecondaryColor($theme_secondary_color)
    {
        if (is_null($theme_secondary_color)) {
            throw new \InvalidArgumentException('non-nullable theme_secondary_color cannot be null');
        }
        $this->container['theme_secondary_color'] = $theme_secondary_color;

        return $this;
    }

    /**
     * Gets theme_accent_color
     *
     * @return string|null
     */
    public function getThemeAccentColor()
    {
        return $this->container['theme_accent_color'];
    }

    /**
     * Sets theme_accent_color
     *
     * @param string|null $theme_accent_color Couleur d'accentuation du thème
     *
     * @return self
     */
    public function setThemeAccentColor($theme_accent_color)
    {
        if (is_null($theme_accent_color)) {
            throw new \InvalidArgumentException('non-nullable theme_accent_color cannot be null');
        }
        $this->container['theme_accent_color'] = $theme_accent_color;

        return $this;
    }

    /**
     * Gets infos
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\InfoConnect|null
     */
    public function getInfos()
    {
        return $this->container['infos'];
    }

    /**
     * Sets infos
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\InfoConnect|null $infos infos
     *
     * @return self
     */
    public function setInfos($infos)
    {
        if (is_null($infos)) {
            throw new \InvalidArgumentException('non-nullable infos cannot be null');
        }
        $this->container['infos'] = $infos;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


