<?php
/**
 * CatalogApi
 * PHP version 7.2
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Api;

use GuzzleHttp\Psr7\MultipartStream;
use Http\Client\Common\Plugin\ErrorPlugin;
use Http\Client\Common\Plugin\RedirectPlugin;
use Http\Client\Common\PluginClient;
use Http\Client\Common\PluginClientFactory;
use Http\Client\Exception\HttpException;
use Http\Client\HttpAsyncClient;
use Http\Discovery\HttpAsyncClientDiscovery;
use Http\Discovery\Psr17FactoryDiscovery;
use Http\Discovery\Psr18ClientDiscovery;
use Http\Message\RequestFactory;
use Http\Promise\Promise;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Configuration;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\DebugPlugin;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\HeaderSelector;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestFactoryInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\StreamFactoryInterface;
use Psr\Http\Message\UriFactoryInterface;
use Psr\Http\Message\UriInterface;
use function sprintf;

/**
 * CatalogApi Class Doc Comment
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CatalogApi
{
    /**
     * @var PluginClient
     */
    protected $httpClient;

    /**
     * @var PluginClient
     */
    protected $httpAsyncClient;

    /**
     * @var UriFactoryInterface
     */
    protected $uriFactory;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @var RequestFactoryInterface
     */
    protected $requestFactory;

    /**
     * @var StreamFactoryInterface
     */
    protected $streamFactory;

    public function __construct(
        ClientInterface $httpClient = null,
        Configuration $config = null,
        HttpAsyncClient $httpAsyncClient = null,
        UriFactoryInterface $uriFactory = null,
        RequestFactoryInterface $requestFactory = null,
        StreamFactoryInterface $streamFactory = null,
        HeaderSelector $selector = null,
        ?array $plugins = null,
        $hostIndex = 0
    ) {
        $this->config = $config ?? (new Configuration())->setHost('https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api/WebConnect');
        $this->requestFactory = $requestFactory ?? Psr17FactoryDiscovery::findRequestFactory();
        $this->streamFactory = $streamFactory ?? Psr17FactoryDiscovery::findStreamFactory();

        $plugins = $plugins ?? [
            new RedirectPlugin(['strict' => true]),
            new ErrorPlugin(),
        ];

        if ($this->config->getDebug()) {
            $plugins[] = new DebugPlugin(fopen($this->config->getDebugFile(), 'ab'));
        }

        $this->httpClient = (new PluginClientFactory())->createClient(
            $httpClient ?? Psr18ClientDiscovery::find(),
            $plugins
        );

        $this->httpAsyncClient = (new PluginClientFactory())->createClient(
            $httpAsyncClient ?? HttpAsyncClientDiscovery::find(),
            $plugins
        );

        $this->uriFactory = $uriFactory ?? Psr17FactoryDiscovery::findUriFactory();

        $this->headerSelector = $selector ?? new HeaderSelector();

        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation catalogGetCategories1
     *
     * Obtient les informations de catégories de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie
     */
    public function catalogGetCategories1($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetCategories1WithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetCategories1WithHttpInfo
     *
     * Obtient les informations de catégories de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetCategories1WithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetCategories1Request($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetCategories1Async
     *
     * Obtient les informations de catégories de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories1Async($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetCategories1AsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetCategories1AsyncWithHttpInfo
     *
     * Obtient les informations de catégories de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories1AsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie';
        $request = $this->catalogGetCategories1Request($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetCategories1'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetCategories1Request($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Categories1';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetCategories1Ext
     *
     * Obtient les informations étendues de catégories de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete
     */
    public function catalogGetCategories1Ext($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetCategories1ExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetCategories1ExtWithHttpInfo
     *
     * Obtient les informations étendues de catégories de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetCategories1ExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetCategories1ExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetCategories1ExtAsync
     *
     * Obtient les informations étendues de catégories de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories1ExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetCategories1ExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetCategories1ExtAsyncWithHttpInfo
     *
     * Obtient les informations étendues de catégories de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories1ExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete';
        $request = $this->catalogGetCategories1ExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetCategories1Ext'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetCategories1ExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Categories1Ext';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetCategories2
     *
     * Obtient les informations de catégories de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie
     */
    public function catalogGetCategories2($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetCategories2WithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetCategories2WithHttpInfo
     *
     * Obtient les informations de catégories de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetCategories2WithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetCategories2Request($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetCategories2Async
     *
     * Obtient les informations de catégories de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories2Async($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetCategories2AsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetCategories2AsyncWithHttpInfo
     *
     * Obtient les informations de catégories de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories2AsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie';
        $request = $this->catalogGetCategories2Request($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetCategories2'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetCategories2Request($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Categories2';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetCategories2Ext
     *
     * Obtient les informations étendues de catégories de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete
     */
    public function catalogGetCategories2Ext($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetCategories2ExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetCategories2ExtWithHttpInfo
     *
     * Obtient les informations étendues de catégories de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetCategories2ExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetCategories2ExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetCategories2ExtAsync
     *
     * Obtient les informations étendues de catégories de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories2ExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetCategories2ExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetCategories2ExtAsyncWithHttpInfo
     *
     * Obtient les informations étendues de catégories de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories2ExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete';
        $request = $this->catalogGetCategories2ExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetCategories2Ext'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetCategories2ExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Categories2Ext';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetCategories3
     *
     * Obtient les informations de catégories de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie
     */
    public function catalogGetCategories3($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetCategories3WithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetCategories3WithHttpInfo
     *
     * Obtient les informations de catégories de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetCategories3WithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetCategories3Request($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetCategories3Async
     *
     * Obtient les informations de catégories de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories3Async($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetCategories3AsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetCategories3AsyncWithHttpInfo
     *
     * Obtient les informations de catégories de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories3AsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie';
        $request = $this->catalogGetCategories3Request($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetCategories3'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetCategories3Request($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Categories3';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetCategories3Ext
     *
     * Obtient les informations étendues de catégories de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete
     */
    public function catalogGetCategories3Ext($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetCategories3ExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetCategories3ExtWithHttpInfo
     *
     * Obtient les informations étendues de catégories de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetCategories3ExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetCategories3ExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetCategories3ExtAsync
     *
     * Obtient les informations étendues de catégories de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories3ExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetCategories3ExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetCategories3ExtAsyncWithHttpInfo
     *
     * Obtient les informations étendues de catégories de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories3ExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete';
        $request = $this->catalogGetCategories3ExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetCategories3Ext'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetCategories3ExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Categories3Ext';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetCategories4
     *
     * Obtient les informations de catégories de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marqcatégoriesues ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie
     */
    public function catalogGetCategories4($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetCategories4WithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetCategories4WithHttpInfo
     *
     * Obtient les informations de catégories de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marqcatégoriesues ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetCategories4WithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetCategories4Request($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetCategories4Async
     *
     * Obtient les informations de catégories de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marqcatégoriesues ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories4Async($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetCategories4AsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetCategories4AsyncWithHttpInfo
     *
     * Obtient les informations de catégories de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marqcatégoriesues ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories4AsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorie';
        $request = $this->catalogGetCategories4Request($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetCategories4'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marqcatégoriesues ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetCategories4Request($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Categories4';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetCategories4Ext
     *
     * Obtient les informations étendues de catégories de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete
     */
    public function catalogGetCategories4Ext($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetCategories4ExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetCategories4ExtWithHttpInfo
     *
     * Obtient les informations étendues de catégories de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetCategories4ExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetCategories4ExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetCategories4ExtAsync
     *
     * Obtient les informations étendues de catégories de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories4ExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetCategories4ExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetCategories4ExtAsyncWithHttpInfo
     *
     * Obtient les informations étendues de catégories de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCategories4ExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCategorieWebConnectCategorieComplete';
        $request = $this->catalogGetCategories4ExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetCategories4Ext'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les catégories des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les catégories ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetCategories4ExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Categories4Ext';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetClassification
     *
     * Obtient les informations d&#39;une classification de produits
     *
     * @param  int $no Numéro interne de la classification à récupérer (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassificationComplete
     */
    public function catalogGetClassification($no)
    {
        list($response) = $this->catalogGetClassificationWithHttpInfo($no);
        return $response;
    }

    /**
     * Operation catalogGetClassificationWithHttpInfo
     *
     * Obtient les informations d&#39;une classification de produits
     *
     * @param  int $no Numéro interne de la classification à récupérer (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassificationComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetClassificationWithHttpInfo($no)
    {
        $request = $this->catalogGetClassificationRequest($no);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassificationComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassificationComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassificationComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassificationComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetClassificationAsync
     *
     * Obtient les informations d&#39;une classification de produits
     *
     * @param  int $no Numéro interne de la classification à récupérer (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetClassificationAsync($no)
    {
        return $this->catalogGetClassificationAsyncWithHttpInfo($no)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetClassificationAsyncWithHttpInfo
     *
     * Obtient les informations d&#39;une classification de produits
     *
     * @param  int $no Numéro interne de la classification à récupérer (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetClassificationAsyncWithHttpInfo($no)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassificationComplete';
        $request = $this->catalogGetClassificationRequest($no);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetClassification'
     *
     * @param  int $no Numéro interne de la classification à récupérer (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetClassificationRequest($no)
    {
        // verify the required parameter 'no' is set
        if ($no === null || (is_array($no) && count($no) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $no when calling catalogGetClassification'
            );
        }

        $resourcePath = '/Catalog/Classification';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($no !== null) {
            if('form' === 'form' && is_array($no)) {
                foreach($no as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['no'] = $no;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetClassifications
     *
     * Obtient la liste des classifications utilisées des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondants au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassification
     */
    public function catalogGetClassifications($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetClassificationsWithHttpInfo($filtre_produit, $no_parent, $niveau, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetClassificationsWithHttpInfo
     *
     * Obtient la liste des classifications utilisées des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondants au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassification, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetClassificationsWithHttpInfo($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetClassificationsRequest($filtre_produit, $no_parent, $niveau, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassification' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassification', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassification';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassification',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetClassificationsAsync
     *
     * Obtient la liste des classifications utilisées des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondants au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetClassificationsAsync($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetClassificationsAsyncWithHttpInfo($filtre_produit, $no_parent, $niveau, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetClassificationsAsyncWithHttpInfo
     *
     * Obtient la liste des classifications utilisées des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondants au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetClassificationsAsyncWithHttpInfo($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassification';
        $request = $this->catalogGetClassificationsRequest($filtre_produit, $no_parent, $niveau, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetClassifications'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondants au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetClassificationsRequest($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Classifications';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($no_parent !== null) {
            if('form' === 'form' && is_array($no_parent)) {
                foreach($no_parent as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['noParent'] = $no_parent;
            }
        }
        // query params
        if ($niveau !== null) {
            if('form' === 'form' && is_array($niveau)) {
                foreach($niveau as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['niveau'] = $niveau;
            }
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetClassificationsExt
     *
     * Obtient les informations de classification des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondant au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassificationComplete
     */
    public function catalogGetClassificationsExt($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetClassificationsExtWithHttpInfo($filtre_produit, $no_parent, $niveau, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetClassificationsExtWithHttpInfo
     *
     * Obtient les informations de classification des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondant au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassificationComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetClassificationsExtWithHttpInfo($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetClassificationsExtRequest($filtre_produit, $no_parent, $niveau, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassificationComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassificationComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassificationComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassificationComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetClassificationsExtAsync
     *
     * Obtient les informations de classification des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondant au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetClassificationsExtAsync($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetClassificationsExtAsyncWithHttpInfo($filtre_produit, $no_parent, $niveau, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetClassificationsExtAsyncWithHttpInfo
     *
     * Obtient les informations de classification des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondant au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetClassificationsExtAsyncWithHttpInfo($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClassificationWebConnectClassificationComplete';
        $request = $this->catalogGetClassificationsExtRequest($filtre_produit, $no_parent, $niveau, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetClassificationsExt'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les classifications des produits correspondant au filtrage (optional)
     * @param  int $no_parent Si précisé, ne renvoi que les classifications filles de la classification indiquée (optional)
     * @param  int $niveau Si précisé, ne renvoi que les classifications du niveau souhaité (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les classifications ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetClassificationsExtRequest($filtre_produit = null, $no_parent = null, $niveau = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/ClassificationsExt';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($no_parent !== null) {
            if('form' === 'form' && is_array($no_parent)) {
                foreach($no_parent as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['noParent'] = $no_parent;
            }
        }
        // query params
        if ($niveau !== null) {
            if('form' === 'form' && is_array($niveau)) {
                foreach($niveau as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['niveau'] = $niveau;
            }
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetCollections
     *
     * Obtient les informations de collections des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les collections des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les collections ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCollectionWebConnectCollection
     */
    public function catalogGetCollections($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetCollectionsWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetCollectionsWithHttpInfo
     *
     * Obtient les informations de collections des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les collections des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les collections ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCollectionWebConnectCollection, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetCollectionsWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetCollectionsRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCollectionWebConnectCollection' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCollectionWebConnectCollection', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCollectionWebConnectCollection';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCollectionWebConnectCollection',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetCollectionsAsync
     *
     * Obtient les informations de collections des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les collections des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les collections ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCollectionsAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetCollectionsAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetCollectionsAsyncWithHttpInfo
     *
     * Obtient les informations de collections des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les collections des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les collections ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetCollectionsAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCollectionWebConnectCollection';
        $request = $this->catalogGetCollectionsRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetCollections'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les collections des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les collections ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetCollectionsRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Collections';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetGroupesThemes
     *
     * Obtient les informations des groupes de thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les groupes de thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les groupes de thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierGroupeThemesWebConnectGroupeThemes
     */
    public function catalogGetGroupesThemes($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetGroupesThemesWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetGroupesThemesWithHttpInfo
     *
     * Obtient les informations des groupes de thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les groupes de thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les groupes de thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierGroupeThemesWebConnectGroupeThemes, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetGroupesThemesWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetGroupesThemesRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierGroupeThemesWebConnectGroupeThemes' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierGroupeThemesWebConnectGroupeThemes', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierGroupeThemesWebConnectGroupeThemes';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierGroupeThemesWebConnectGroupeThemes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetGroupesThemesAsync
     *
     * Obtient les informations des groupes de thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les groupes de thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les groupes de thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetGroupesThemesAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetGroupesThemesAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetGroupesThemesAsyncWithHttpInfo
     *
     * Obtient les informations des groupes de thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les groupes de thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les groupes de thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetGroupesThemesAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierGroupeThemesWebConnectGroupeThemes';
        $request = $this->catalogGetGroupesThemesRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetGroupesThemes'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les groupes de thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les groupes de thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetGroupesThemesRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/GroupesThemes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetMagasin
     *
     * Obtient les informations d&#39;un magasin
     *
     * @param  int $no Numéro interne du magasin à récupérer (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMagasinWebConnectMagasinComplet
     */
    public function catalogGetMagasin($no)
    {
        list($response) = $this->catalogGetMagasinWithHttpInfo($no);
        return $response;
    }

    /**
     * Operation catalogGetMagasinWithHttpInfo
     *
     * Obtient les informations d&#39;un magasin
     *
     * @param  int $no Numéro interne du magasin à récupérer (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMagasinWebConnectMagasinComplet, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetMagasinWithHttpInfo($no)
    {
        $request = $this->catalogGetMagasinRequest($no);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMagasinWebConnectMagasinComplet' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMagasinWebConnectMagasinComplet', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMagasinWebConnectMagasinComplet';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMagasinWebConnectMagasinComplet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetMagasinAsync
     *
     * Obtient les informations d&#39;un magasin
     *
     * @param  int $no Numéro interne du magasin à récupérer (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMagasinAsync($no)
    {
        return $this->catalogGetMagasinAsyncWithHttpInfo($no)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetMagasinAsyncWithHttpInfo
     *
     * Obtient les informations d&#39;un magasin
     *
     * @param  int $no Numéro interne du magasin à récupérer (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMagasinAsyncWithHttpInfo($no)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMagasinWebConnectMagasinComplet';
        $request = $this->catalogGetMagasinRequest($no);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetMagasin'
     *
     * @param  int $no Numéro interne du magasin à récupérer (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetMagasinRequest($no)
    {
        // verify the required parameter 'no' is set
        if ($no === null || (is_array($no) && count($no) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $no when calling catalogGetMagasin'
            );
        }

        $resourcePath = '/Catalog/Magasin';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($no !== null) {
            if('form' === 'form' && is_array($no)) {
                foreach($no as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['no'] = $no;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetMagasins
     *
     * Obtient les informations de magasins
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasin
     */
    public function catalogGetMagasins($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetMagasinsWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetMagasinsWithHttpInfo
     *
     * Obtient les informations de magasins
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasin, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetMagasinsWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetMagasinsRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasin' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasin', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasin';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasin',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetMagasinsAsync
     *
     * Obtient les informations de magasins
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMagasinsAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetMagasinsAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetMagasinsAsyncWithHttpInfo
     *
     * Obtient les informations de magasins
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMagasinsAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasin';
        $request = $this->catalogGetMagasinsRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetMagasins'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetMagasinsRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Magasins';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetMagasinsExt
     *
     * Obtient les informations de magasins des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasinComplet
     */
    public function catalogGetMagasinsExt($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetMagasinsExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetMagasinsExtWithHttpInfo
     *
     * Obtient les informations de magasins des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasinComplet, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetMagasinsExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetMagasinsExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasinComplet' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasinComplet', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasinComplet';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasinComplet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetMagasinsExtAsync
     *
     * Obtient les informations de magasins des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMagasinsExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetMagasinsExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetMagasinsExtAsyncWithHttpInfo
     *
     * Obtient les informations de magasins des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMagasinsExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMagasinWebConnectMagasinComplet';
        $request = $this->catalogGetMagasinsExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetMagasinsExt'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les magasins correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les magasins ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetMagasinsExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/MagasinsExt';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetMarque
     *
     * Obtient les informations d&#39;une marque de produits
     *
     * @param  int $no Numéro interne de la marque à récupérer (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarqueComplete
     */
    public function catalogGetMarque($no)
    {
        list($response) = $this->catalogGetMarqueWithHttpInfo($no);
        return $response;
    }

    /**
     * Operation catalogGetMarqueWithHttpInfo
     *
     * Obtient les informations d&#39;une marque de produits
     *
     * @param  int $no Numéro interne de la marque à récupérer (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarqueComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetMarqueWithHttpInfo($no)
    {
        $request = $this->catalogGetMarqueRequest($no);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarqueComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarqueComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarqueComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarqueComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetMarqueAsync
     *
     * Obtient les informations d&#39;une marque de produits
     *
     * @param  int $no Numéro interne de la marque à récupérer (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMarqueAsync($no)
    {
        return $this->catalogGetMarqueAsyncWithHttpInfo($no)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetMarqueAsyncWithHttpInfo
     *
     * Obtient les informations d&#39;une marque de produits
     *
     * @param  int $no Numéro interne de la marque à récupérer (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMarqueAsyncWithHttpInfo($no)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarqueComplete';
        $request = $this->catalogGetMarqueRequest($no);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetMarque'
     *
     * @param  int $no Numéro interne de la marque à récupérer (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetMarqueRequest($no)
    {
        // verify the required parameter 'no' is set
        if ($no === null || (is_array($no) && count($no) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $no when calling catalogGetMarque'
            );
        }

        $resourcePath = '/Catalog/Marque';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($no !== null) {
            if('form' === 'form' && is_array($no)) {
                foreach($no as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['no'] = $no;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetMarques
     *
     * Obtient les informations de marques des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarque
     */
    public function catalogGetMarques($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetMarquesWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetMarquesWithHttpInfo
     *
     * Obtient les informations de marques des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarque, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetMarquesWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetMarquesRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarque' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarque', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarque';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarque',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetMarquesAsync
     *
     * Obtient les informations de marques des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMarquesAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetMarquesAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetMarquesAsyncWithHttpInfo
     *
     * Obtient les informations de marques des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMarquesAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarque';
        $request = $this->catalogGetMarquesRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetMarques'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetMarquesRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Marques';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetMarquesExt
     *
     * Obtient les informations de marques des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarqueComplete
     */
    public function catalogGetMarquesExt($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetMarquesExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetMarquesExtWithHttpInfo
     *
     * Obtient les informations de marques des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarqueComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetMarquesExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetMarquesExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarqueComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarqueComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarqueComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarqueComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetMarquesExtAsync
     *
     * Obtient les informations de marques des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMarquesExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetMarquesExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetMarquesExtAsyncWithHttpInfo
     *
     * Obtient les informations de marques des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetMarquesExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierMarqueWebConnectMarqueComplete';
        $request = $this->catalogGetMarquesExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetMarquesExt'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les marques des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les marques ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetMarquesExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/MarquesExt';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetNiveaux1
     *
     * Obtient les informations de niveaux de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau
     */
    public function catalogGetNiveaux1($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetNiveaux1WithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetNiveaux1WithHttpInfo
     *
     * Obtient les informations de niveaux de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetNiveaux1WithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetNiveaux1Request($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetNiveaux1Async
     *
     * Obtient les informations de niveaux de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux1Async($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetNiveaux1AsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetNiveaux1AsyncWithHttpInfo
     *
     * Obtient les informations de niveaux de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux1AsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau';
        $request = $this->catalogGetNiveaux1Request($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetNiveaux1'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetNiveaux1Request($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Niveaux1';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetNiveaux1Ext
     *
     * Obtient les informations étendues de niveaux de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete
     */
    public function catalogGetNiveaux1Ext($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetNiveaux1ExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetNiveaux1ExtWithHttpInfo
     *
     * Obtient les informations étendues de niveaux de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetNiveaux1ExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetNiveaux1ExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetNiveaux1ExtAsync
     *
     * Obtient les informations étendues de niveaux de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux1ExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetNiveaux1ExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetNiveaux1ExtAsyncWithHttpInfo
     *
     * Obtient les informations étendues de niveaux de type 1 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux1ExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete';
        $request = $this->catalogGetNiveaux1ExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetNiveaux1Ext'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetNiveaux1ExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Niveaux1Ext';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetNiveaux2
     *
     * Obtient les informations de niveaux de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau
     */
    public function catalogGetNiveaux2($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetNiveaux2WithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetNiveaux2WithHttpInfo
     *
     * Obtient les informations de niveaux de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetNiveaux2WithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetNiveaux2Request($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetNiveaux2Async
     *
     * Obtient les informations de niveaux de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux2Async($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetNiveaux2AsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetNiveaux2AsyncWithHttpInfo
     *
     * Obtient les informations de niveaux de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux2AsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau';
        $request = $this->catalogGetNiveaux2Request($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetNiveaux2'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetNiveaux2Request($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Niveaux2';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetNiveaux2Ext
     *
     * Obtient les informations étendues de niveaux de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete
     */
    public function catalogGetNiveaux2Ext($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetNiveaux2ExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetNiveaux2ExtWithHttpInfo
     *
     * Obtient les informations étendues de niveaux de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetNiveaux2ExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetNiveaux2ExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetNiveaux2ExtAsync
     *
     * Obtient les informations étendues de niveaux de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux2ExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetNiveaux2ExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetNiveaux2ExtAsyncWithHttpInfo
     *
     * Obtient les informations étendues de niveaux de type 2 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux2ExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete';
        $request = $this->catalogGetNiveaux2ExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetNiveaux2Ext'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetNiveaux2ExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Niveaux2Ext';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetNiveaux3
     *
     * Obtient les informations de niveaux de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau
     */
    public function catalogGetNiveaux3($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetNiveaux3WithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetNiveaux3WithHttpInfo
     *
     * Obtient les informations de niveaux de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetNiveaux3WithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetNiveaux3Request($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetNiveaux3Async
     *
     * Obtient les informations de niveaux de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux3Async($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetNiveaux3AsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetNiveaux3AsyncWithHttpInfo
     *
     * Obtient les informations de niveaux de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux3AsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau';
        $request = $this->catalogGetNiveaux3Request($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetNiveaux3'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetNiveaux3Request($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Niveaux3';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetNiveaux3Ext
     *
     * Obtient les informations étendues de niveaux de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete
     */
    public function catalogGetNiveaux3Ext($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetNiveaux3ExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetNiveaux3ExtWithHttpInfo
     *
     * Obtient les informations étendues de niveaux de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetNiveaux3ExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetNiveaux3ExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetNiveaux3ExtAsync
     *
     * Obtient les informations étendues de niveaux de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux3ExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetNiveaux3ExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetNiveaux3ExtAsyncWithHttpInfo
     *
     * Obtient les informations étendues de niveaux de type 3 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux3ExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete';
        $request = $this->catalogGetNiveaux3ExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetNiveaux3Ext'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetNiveaux3ExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Niveaux3Ext';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetNiveaux4
     *
     * Obtient les informations de niveaux de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau
     */
    public function catalogGetNiveaux4($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetNiveaux4WithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetNiveaux4WithHttpInfo
     *
     * Obtient les informations de niveaux de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetNiveaux4WithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetNiveaux4Request($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetNiveaux4Async
     *
     * Obtient les informations de niveaux de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux4Async($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetNiveaux4AsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetNiveaux4AsyncWithHttpInfo
     *
     * Obtient les informations de niveaux de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux4AsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveau';
        $request = $this->catalogGetNiveaux4Request($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetNiveaux4'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetNiveaux4Request($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Niveaux4';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetNiveaux4Ext
     *
     * Obtient les informations étendues de niveaux de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete
     */
    public function catalogGetNiveaux4Ext($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetNiveaux4ExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetNiveaux4ExtWithHttpInfo
     *
     * Obtient les informations étendues de niveaux de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetNiveaux4ExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetNiveaux4ExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetNiveaux4ExtAsync
     *
     * Obtient les informations étendues de niveaux de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux4ExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetNiveaux4ExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetNiveaux4ExtAsyncWithHttpInfo
     *
     * Obtient les informations étendues de niveaux de type 4 des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetNiveaux4ExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierNiveauWebConnectNiveauComplete';
        $request = $this->catalogGetNiveaux4ExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetNiveaux4Ext'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les niveaux des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les niveaux ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetNiveaux4ExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Niveaux4Ext';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetProduits
     *
     * Obtient les produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les produits ayant changés depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     * @param  \DateTime $derniere_changement Si précisé, ne renvoi que les produits ayant changés depuis cette date, (produit, prix et stock) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultProduit
     */
    public function catalogGetProduits($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null, $derniere_changement = null)
    {
        list($response) = $this->catalogGetProduitsWithHttpInfo($filtre_produit, $derniere_modification, $pager, $date_solde, $is_solde, $is_promo, $is_internet, $is_magasin, $code_promo, $derniere_changement);
        return $response;
    }

    /**
     * Operation catalogGetProduitsWithHttpInfo
     *
     * Obtient les produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les produits ayant changés depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     * @param  \DateTime $derniere_changement Si précisé, ne renvoi que les produits ayant changés depuis cette date, (produit, prix et stock) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultProduit, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetProduitsWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null, $derniere_changement = null)
    {
        $request = $this->catalogGetProduitsRequest($filtre_produit, $derniere_modification, $pager, $date_solde, $is_solde, $is_promo, $is_internet, $is_magasin, $code_promo, $derniere_changement);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultProduit' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultProduit', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultProduit';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultProduit',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetProduitsAsync
     *
     * Obtient les produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les produits ayant changés depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     * @param  \DateTime $derniere_changement Si précisé, ne renvoi que les produits ayant changés depuis cette date, (produit, prix et stock) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetProduitsAsync($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null, $derniere_changement = null)
    {
        return $this->catalogGetProduitsAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager, $date_solde, $is_solde, $is_promo, $is_internet, $is_magasin, $code_promo, $derniere_changement)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetProduitsAsyncWithHttpInfo
     *
     * Obtient les produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les produits ayant changés depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     * @param  \DateTime $derniere_changement Si précisé, ne renvoi que les produits ayant changés depuis cette date, (produit, prix et stock) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetProduitsAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null, $derniere_changement = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultProduit';
        $request = $this->catalogGetProduitsRequest($filtre_produit, $derniere_modification, $pager, $date_solde, $is_solde, $is_promo, $is_internet, $is_magasin, $code_promo, $derniere_changement);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetProduits'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les produits ayant changés depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     * @param  \DateTime $derniere_changement Si précisé, ne renvoi que les produits ayant changés depuis cette date, (produit, prix et stock) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetProduitsRequest($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null, $derniere_changement = null)
    {

        $resourcePath = '/Catalog/Produits';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }
        // query params
        if ($date_solde !== null) {
            if('form' === 'form' && is_array($date_solde)) {
                foreach($date_solde as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['dateSolde'] = $date_solde;
            }
        }
        // query params
        if ($is_solde !== null) {
            if('form' === 'form' && is_array($is_solde)) {
                foreach($is_solde as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['isSolde'] = $is_solde;
            }
        }
        // query params
        if ($is_promo !== null) {
            if('form' === 'form' && is_array($is_promo)) {
                foreach($is_promo as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['isPromo'] = $is_promo;
            }
        }
        // query params
        if ($is_internet !== null) {
            if('form' === 'form' && is_array($is_internet)) {
                foreach($is_internet as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['isInternet'] = $is_internet;
            }
        }
        // query params
        if ($is_magasin !== null) {
            if('form' === 'form' && is_array($is_magasin)) {
                foreach($is_magasin as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['isMagasin'] = $is_magasin;
            }
        }
        // query params
        if ($code_promo !== null) {
            if('form' === 'form' && is_array($code_promo)) {
                foreach($code_promo as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['codePromo'] = $code_promo;
            }
        }
        // query params
        if ($derniere_changement !== null) {
            if('form' === 'form' && is_array($derniere_changement)) {
                foreach($derniere_changement as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereChangement'] = $derniere_changement;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetProduitsInvalides
     *
     * Obtient les produits invalidés
     *
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultRefProduitInvalide
     */
    public function catalogGetProduitsInvalides($pager = null)
    {
        list($response) = $this->catalogGetProduitsInvalidesWithHttpInfo($pager);
        return $response;
    }

    /**
     * Operation catalogGetProduitsInvalidesWithHttpInfo
     *
     * Obtient les produits invalidés
     *
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultRefProduitInvalide, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetProduitsInvalidesWithHttpInfo($pager = null)
    {
        $request = $this->catalogGetProduitsInvalidesRequest($pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultRefProduitInvalide' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultRefProduitInvalide', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultRefProduitInvalide';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultRefProduitInvalide',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetProduitsInvalidesAsync
     *
     * Obtient les produits invalidés
     *
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetProduitsInvalidesAsync($pager = null)
    {
        return $this->catalogGetProduitsInvalidesAsyncWithHttpInfo($pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetProduitsInvalidesAsyncWithHttpInfo
     *
     * Obtient les produits invalidés
     *
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetProduitsInvalidesAsyncWithHttpInfo($pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultRefProduitInvalide';
        $request = $this->catalogGetProduitsInvalidesRequest($pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetProduitsInvalides'
     *
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetProduitsInvalidesRequest($pager = null)
    {

        $resourcePath = '/Catalog/ProduitsInvalides';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetSaisons
     *
     * Obtient les informations de saisons des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les saisons des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les saisons ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierSaisonWebConnectSaison
     */
    public function catalogGetSaisons($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetSaisonsWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetSaisonsWithHttpInfo
     *
     * Obtient les informations de saisons des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les saisons des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les saisons ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierSaisonWebConnectSaison, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetSaisonsWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetSaisonsRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierSaisonWebConnectSaison' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierSaisonWebConnectSaison', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierSaisonWebConnectSaison';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierSaisonWebConnectSaison',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetSaisonsAsync
     *
     * Obtient les informations de saisons des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les saisons des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les saisons ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetSaisonsAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetSaisonsAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetSaisonsAsyncWithHttpInfo
     *
     * Obtient les informations de saisons des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les saisons des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les saisons ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetSaisonsAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierSaisonWebConnectSaison';
        $request = $this->catalogGetSaisonsRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetSaisons'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les saisons des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les saisons ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetSaisonsRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Saisons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetTailles
     *
     * Obtient les informations de tailles des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les tailles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les tailles ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierTailleWebConnectTaille
     */
    public function catalogGetTailles($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetTaillesWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetTaillesWithHttpInfo
     *
     * Obtient les informations de tailles des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les tailles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les tailles ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierTailleWebConnectTaille, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetTaillesWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetTaillesRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierTailleWebConnectTaille' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierTailleWebConnectTaille', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierTailleWebConnectTaille';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierTailleWebConnectTaille',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetTaillesAsync
     *
     * Obtient les informations de tailles des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les tailles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les tailles ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetTaillesAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetTaillesAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetTaillesAsyncWithHttpInfo
     *
     * Obtient les informations de tailles des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les tailles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les tailles ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetTaillesAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierTailleWebConnectTaille';
        $request = $this->catalogGetTaillesRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetTailles'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les tailles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les tailles ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetTaillesRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Tailles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetThemes
     *
     * Obtient les informations des thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectTheme
     */
    public function catalogGetThemes($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetThemesWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetThemesWithHttpInfo
     *
     * Obtient les informations des thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectTheme, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetThemesWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetThemesRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectTheme' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectTheme', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectTheme';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectTheme',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetThemesAsync
     *
     * Obtient les informations des thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetThemesAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetThemesAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetThemesAsyncWithHttpInfo
     *
     * Obtient les informations des thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetThemesAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectTheme';
        $request = $this->catalogGetThemesRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetThemes'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetThemesRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/Themes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation catalogGetThemesExt
     *
     * Obtient les informations de thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectThemeComplete
     */
    public function catalogGetThemesExt($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->catalogGetThemesExtWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation catalogGetThemesExtWithHttpInfo
     *
     * Obtient les informations de thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectThemeComplete, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogGetThemesExtWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->catalogGetThemesExtRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectThemeComplete' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectThemeComplete', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectThemeComplete';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectThemeComplete',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogGetThemesExtAsync
     *
     * Obtient les informations de thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetThemesExtAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->catalogGetThemesExtAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogGetThemesExtAsyncWithHttpInfo
     *
     * Obtient les informations de thèmes des produits
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function catalogGetThemesExtAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierThemeWebConnectThemeComplete';
        $request = $this->catalogGetThemesExtRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogGetThemesExt'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les thèmes des produits correspondant au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les thèmes ayant changées depuis cette date (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function catalogGetThemesExtRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Catalog/ThemesExt';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }


    /**
     * @param string $method
     * @param string|UriInterface $uri
     * @param array $headers
     * @param string|StreamInterface|null $body
     *
     * @return RequestInterface
     */
    protected function createRequest(string $method, $uri, array $headers = [], $body = null): RequestInterface
    {
        if ($this->requestFactory instanceof RequestFactory) {
            return $this->requestFactory->createRequest(
                $method,
                $uri,
                $headers,
                $body
            );
        }

        if (is_string($body) && '' !== $body && null === $this->streamFactory) {
            throw new \RuntimeException('Cannot create request: A stream factory is required to create a request with a non-empty string body.');
        }

        $request = $this->requestFactory->createRequest($method, $uri);

        foreach ($headers as $key => $value) {
            $request = $request->withHeader($key, $value);
        }

        if (null !== $body && '' !== $body) {
            $request = $request->withBody(
                is_string($body) ? $this->streamFactory->createStream($body) : $body
            );
        }

        return $request;
    }

    private function createUri(
        string $operationHost,
        string $resourcePath,
        array $queryParams
    ): UriInterface {
        $parsedUrl = parse_url($operationHost);

        $host = $parsedUrl['host'] ?? null;
        $scheme = $parsedUrl['scheme'] ?? null;
        $basePath = $parsedUrl['path'] ?? null;
        $port = $parsedUrl['port'] ?? null;
        $user = $parsedUrl['user'] ?? null;
        $password = $parsedUrl['pass'] ?? null;

        $uri = $this->uriFactory->createUri($basePath . $resourcePath)
            ->withHost($host)
            ->withScheme($scheme)
            ->withPort($port)
            ->withQuery(ObjectSerializer::buildQuery($queryParams));

        if ($user) {
            $uri = $uri->withUserInfo($user, $password);
        }

        return $uri;
    }
}
