<?php
/**
 * ProduitDetailMagasin
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * ProduitDetailMagasin Class Doc Comment
 *
 * @category Class
 * @description Stock pour un produit et un magasin   (fullname : ApiPolaris.WebConnect.Models.ProduitDetailMagasin)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProduitDetailMagasin implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProduitDetailMagasin';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'code_magasin' => 'int',
        'dispo' => 'int',
        'a_recevoir' => 'int',
        'en_solde' => 'bool',
        'prix_ttc' => 'float',
        'prix_normal_ttc' => 'float',
        'devise' => 'string',
        'pcf' => 'float',
        'der_pa' => 'float',
        'pamp' => 'float',
        'dates_livr_prev' => '\DateTime[]',
        'cde' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'code_magasin' => 'int32',
        'dispo' => 'int32',
        'a_recevoir' => 'int32',
        'en_solde' => null,
        'prix_ttc' => 'decimal',
        'prix_normal_ttc' => 'decimal',
        'devise' => null,
        'pcf' => 'decimal',
        'der_pa' => 'decimal',
        'pamp' => 'decimal',
        'dates_livr_prev' => 'date-time',
        'cde' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'code_magasin' => false,
        'dispo' => false,
        'a_recevoir' => false,
        'en_solde' => false,
        'prix_ttc' => false,
        'prix_normal_ttc' => false,
        'devise' => false,
        'pcf' => false,
        'der_pa' => false,
        'pamp' => false,
        'dates_livr_prev' => false,
        'cde' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'code_magasin' => 'CodeMagasin',
        'dispo' => 'Dispo',
        'a_recevoir' => 'ARecevoir',
        'en_solde' => 'EnSolde',
        'prix_ttc' => 'PrixTTC',
        'prix_normal_ttc' => 'PrixNormalTTC',
        'devise' => 'Devise',
        'pcf' => 'PCF',
        'der_pa' => 'DerPA',
        'pamp' => 'PAMP',
        'dates_livr_prev' => 'DatesLivrPrev',
        'cde' => 'Cde'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'code_magasin' => 'setCodeMagasin',
        'dispo' => 'setDispo',
        'a_recevoir' => 'setARecevoir',
        'en_solde' => 'setEnSolde',
        'prix_ttc' => 'setPrixTtc',
        'prix_normal_ttc' => 'setPrixNormalTtc',
        'devise' => 'setDevise',
        'pcf' => 'setPcf',
        'der_pa' => 'setDerPa',
        'pamp' => 'setPamp',
        'dates_livr_prev' => 'setDatesLivrPrev',
        'cde' => 'setCde'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'code_magasin' => 'getCodeMagasin',
        'dispo' => 'getDispo',
        'a_recevoir' => 'getARecevoir',
        'en_solde' => 'getEnSolde',
        'prix_ttc' => 'getPrixTtc',
        'prix_normal_ttc' => 'getPrixNormalTtc',
        'devise' => 'getDevise',
        'pcf' => 'getPcf',
        'der_pa' => 'getDerPa',
        'pamp' => 'getPamp',
        'dates_livr_prev' => 'getDatesLivrPrev',
        'cde' => 'getCde'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('code_magasin', $data ?? [], 0);
        $this->setIfExists('dispo', $data ?? [], 0);
        $this->setIfExists('a_recevoir', $data ?? [], 0);
        $this->setIfExists('en_solde', $data ?? [], false);
        $this->setIfExists('prix_ttc', $data ?? [], null);
        $this->setIfExists('prix_normal_ttc', $data ?? [], null);
        $this->setIfExists('devise', $data ?? [], null);
        $this->setIfExists('pcf', $data ?? [], null);
        $this->setIfExists('der_pa', $data ?? [], null);
        $this->setIfExists('pamp', $data ?? [], null);
        $this->setIfExists('dates_livr_prev', $data ?? [], null);
        $this->setIfExists('cde', $data ?? [], 0);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets code_magasin
     *
     * @return int|null
     */
    public function getCodeMagasin()
    {
        return $this->container['code_magasin'];
    }

    /**
     * Sets code_magasin
     *
     * @param int|null $code_magasin Magasin pour lequel ces informations sont valables
     *
     * @return self
     */
    public function setCodeMagasin($code_magasin)
    {
        if (is_null($code_magasin)) {
            throw new \InvalidArgumentException('non-nullable code_magasin cannot be null');
        }
        $this->container['code_magasin'] = $code_magasin;

        return $this;
    }

    /**
     * Gets dispo
     *
     * @return int|null
     */
    public function getDispo()
    {
        return $this->container['dispo'];
    }

    /**
     * Sets dispo
     *
     * @param int|null $dispo Stock disponible (stock actuel - réservations/cde clients)
     *
     * @return self
     */
    public function setDispo($dispo)
    {
        if (is_null($dispo)) {
            throw new \InvalidArgumentException('non-nullable dispo cannot be null');
        }
        $this->container['dispo'] = $dispo;

        return $this;
    }

    /**
     * Gets a_recevoir
     *
     * @return int|null
     */
    public function getARecevoir()
    {
        return $this->container['a_recevoir'];
    }

    /**
     * Sets a_recevoir
     *
     * @param int|null $a_recevoir Stock à recevoir d'autre magasin
     *
     * @return self
     */
    public function setARecevoir($a_recevoir)
    {
        if (is_null($a_recevoir)) {
            throw new \InvalidArgumentException('non-nullable a_recevoir cannot be null');
        }
        $this->container['a_recevoir'] = $a_recevoir;

        return $this;
    }

    /**
     * Gets en_solde
     *
     * @return bool|null
     */
    public function getEnSolde()
    {
        return $this->container['en_solde'];
    }

    /**
     * Sets en_solde
     *
     * @param bool|null $en_solde En solde ?
     *
     * @return self
     */
    public function setEnSolde($en_solde)
    {
        if (is_null($en_solde)) {
            throw new \InvalidArgumentException('non-nullable en_solde cannot be null');
        }
        $this->container['en_solde'] = $en_solde;

        return $this;
    }

    /**
     * Gets prix_ttc
     *
     * @return float|null
     */
    public function getPrixTtc()
    {
        return $this->container['prix_ttc'];
    }

    /**
     * Sets prix_ttc
     *
     * @param float|null $prix_ttc Prix actuel, meilleure promotion appliquée
     *
     * @return self
     */
    public function setPrixTtc($prix_ttc)
    {
        if (is_null($prix_ttc)) {
            throw new \InvalidArgumentException('non-nullable prix_ttc cannot be null');
        }
        $this->container['prix_ttc'] = $prix_ttc;

        return $this;
    }

    /**
     * Gets prix_normal_ttc
     *
     * @return float|null
     */
    public function getPrixNormalTtc()
    {
        return $this->container['prix_normal_ttc'];
    }

    /**
     * Sets prix_normal_ttc
     *
     * @param float|null $prix_normal_ttc Prix actuel hors promo
     *
     * @return self
     */
    public function setPrixNormalTtc($prix_normal_ttc)
    {
        if (is_null($prix_normal_ttc)) {
            throw new \InvalidArgumentException('non-nullable prix_normal_ttc cannot be null');
        }
        $this->container['prix_normal_ttc'] = $prix_normal_ttc;

        return $this;
    }

    /**
     * Gets devise
     *
     * @return string|null
     */
    public function getDevise()
    {
        return $this->container['devise'];
    }

    /**
     * Sets devise
     *
     * @param string|null $devise Code international de la devise des prix exposés
     *
     * @return self
     */
    public function setDevise($devise)
    {
        if (is_null($devise)) {
            throw new \InvalidArgumentException('non-nullable devise cannot be null');
        }
        $this->container['devise'] = $devise;

        return $this;
    }

    /**
     * Gets pcf
     *
     * @return float|null
     */
    public function getPcf()
    {
        return $this->container['pcf'];
    }

    /**
     * Sets pcf
     *
     * @param float|null $pcf Prix d'achat de référence
     *
     * @return self
     */
    public function setPcf($pcf)
    {
        if (is_null($pcf)) {
            throw new \InvalidArgumentException('non-nullable pcf cannot be null');
        }
        $this->container['pcf'] = $pcf;

        return $this;
    }

    /**
     * Gets der_pa
     *
     * @return float|null
     */
    public function getDerPa()
    {
        return $this->container['der_pa'];
    }

    /**
     * Sets der_pa
     *
     * @param float|null $der_pa Dernier prix d'achat
     *
     * @return self
     */
    public function setDerPa($der_pa)
    {
        if (is_null($der_pa)) {
            throw new \InvalidArgumentException('non-nullable der_pa cannot be null');
        }
        $this->container['der_pa'] = $der_pa;

        return $this;
    }

    /**
     * Gets pamp
     *
     * @return float|null
     */
    public function getPamp()
    {
        return $this->container['pamp'];
    }

    /**
     * Sets pamp
     *
     * @param float|null $pamp PAMP
     *
     * @return self
     */
    public function setPamp($pamp)
    {
        if (is_null($pamp)) {
            throw new \InvalidArgumentException('non-nullable pamp cannot be null');
        }
        $this->container['pamp'] = $pamp;

        return $this;
    }

    /**
     * Gets dates_livr_prev
     *
     * @return \DateTime[]|null
     */
    public function getDatesLivrPrev()
    {
        return $this->container['dates_livr_prev'];
    }

    /**
     * Sets dates_livr_prev
     *
     * @param \DateTime[]|null $dates_livr_prev Dates prévisionnelles des réceptions
     *
     * @return self
     */
    public function setDatesLivrPrev($dates_livr_prev)
    {
        if (is_null($dates_livr_prev)) {
            throw new \InvalidArgumentException('non-nullable dates_livr_prev cannot be null');
        }
        $this->container['dates_livr_prev'] = $dates_livr_prev;

        return $this;
    }

    /**
     * Gets cde
     *
     * @return int|null
     */
    public function getCde()
    {
        return $this->container['cde'];
    }

    /**
     * Sets cde
     *
     * @param int|null $cde Commande en cours
     *
     * @return self
     */
    public function setCde($cde)
    {
        if (is_null($cde)) {
            throw new \InvalidArgumentException('non-nullable cde cannot be null');
        }
        $this->container['cde'] = $cde;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


