<?php
/**
 * Produit
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * Produit Class Doc Comment
 *
 * @category Class
 * @description Produit Polaris. Un produit est décliné en plusieurs tailles, chacune ayant une référence propre stable (code barres Polaris), que vous pouvez utiliser en SKU.   (fullname : ApiPolaris.WebConnect.Models.Produit)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Produit implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Produit';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'nom_variante' => 'string',
        'no' => 'int',
        'no_modele' => 'int',
        'code' => 'string',
        'grille_taille' => 'string',
        'code_ref' => 'int',
        'libelle' => 'string',
        'declinaison' => 'string',
        'zonage_modele' => 'string',
        'zonage_declinaison' => 'string',
        'niveau1' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau',
        'niveau2' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau',
        'niveau3' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau',
        'niveau4' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau',
        'categorie1' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie',
        'categorie2' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie',
        'categorie3' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie',
        'categorie4' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie',
        'classification' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassification',
        'marque' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarque',
        'collection' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCollectionWebConnectProductCollection',
        'saison' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierSaisonWebConnectSaison',
        'code_taric' => 'string',
        'code_pays_fabrication' => 'string',
        'encombrement' => 'int',
        'poids' => 'int',
        'volume' => 'int[]',
        'prix_ttc' => 'float',
        'prix_normal_ttc' => 'float',
        'taux_tva' => 'float',
        'eco_participation_ht' => 'float',
        'devise' => 'string',
        'en_solde' => 'bool',
        'est_lot' => 'bool',
        'est_service' => 'bool',
        'seo_modele' => 'string',
        'seo_declinaison' => 'string',
        'description' => 'string',
        'photos' => 'int[]',
        'en_ligne' => 'bool',
        'mis_en_ligne' => '\DateTime',
        'derniere_modification' => '\DateTime',
        'derniere_changement' => '\DateTime',
        'quarantaine' => 'bool',
        'themes' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\ProduitTheme[]',
        'proprietes' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\ProduitPropriete[]',
        'last_modif' => 'string',
        'last_changement' => 'string',
        'tailles' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\ProduitDetailTaille[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'nom_variante' => null,
        'no' => 'int64',
        'no_modele' => 'int64',
        'code' => null,
        'grille_taille' => null,
        'code_ref' => 'int64',
        'libelle' => null,
        'declinaison' => null,
        'zonage_modele' => null,
        'zonage_declinaison' => null,
        'niveau1' => null,
        'niveau2' => null,
        'niveau3' => null,
        'niveau4' => null,
        'categorie1' => null,
        'categorie2' => null,
        'categorie3' => null,
        'categorie4' => null,
        'classification' => null,
        'marque' => null,
        'collection' => null,
        'saison' => null,
        'code_taric' => null,
        'code_pays_fabrication' => null,
        'encombrement' => 'int32',
        'poids' => 'int32',
        'volume' => 'int32',
        'prix_ttc' => 'decimal',
        'prix_normal_ttc' => 'decimal',
        'taux_tva' => 'decimal',
        'eco_participation_ht' => 'decimal',
        'devise' => null,
        'en_solde' => null,
        'est_lot' => null,
        'est_service' => null,
        'seo_modele' => null,
        'seo_declinaison' => null,
        'description' => null,
        'photos' => 'int64',
        'en_ligne' => null,
        'mis_en_ligne' => 'date-time',
        'derniere_modification' => 'date-time',
        'derniere_changement' => 'date-time',
        'quarantaine' => null,
        'themes' => null,
        'proprietes' => null,
        'last_modif' => null,
        'last_changement' => null,
        'tailles' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'nom_variante' => false,
        'no' => false,
        'no_modele' => false,
        'code' => false,
        'grille_taille' => false,
        'code_ref' => false,
        'libelle' => false,
        'declinaison' => false,
        'zonage_modele' => false,
        'zonage_declinaison' => false,
        'niveau1' => false,
        'niveau2' => false,
        'niveau3' => false,
        'niveau4' => false,
        'categorie1' => false,
        'categorie2' => false,
        'categorie3' => false,
        'categorie4' => false,
        'classification' => false,
        'marque' => false,
        'collection' => false,
        'saison' => false,
        'code_taric' => false,
        'code_pays_fabrication' => false,
        'encombrement' => false,
        'poids' => false,
        'volume' => false,
        'prix_ttc' => false,
        'prix_normal_ttc' => false,
        'taux_tva' => false,
        'eco_participation_ht' => false,
        'devise' => false,
        'en_solde' => false,
        'est_lot' => false,
        'est_service' => false,
        'seo_modele' => false,
        'seo_declinaison' => false,
        'description' => false,
        'photos' => false,
        'en_ligne' => false,
        'mis_en_ligne' => true,
        'derniere_modification' => false,
        'derniere_changement' => false,
        'quarantaine' => false,
        'themes' => false,
        'proprietes' => false,
        'last_modif' => false,
        'last_changement' => false,
        'tailles' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'nom_variante' => 'NomVariante',
        'no' => 'No',
        'no_modele' => 'NoModele',
        'code' => 'Code',
        'grille_taille' => 'GrilleTaille',
        'code_ref' => 'CodeRef',
        'libelle' => 'Libelle',
        'declinaison' => 'Declinaison',
        'zonage_modele' => 'ZonageModele',
        'zonage_declinaison' => 'ZonageDeclinaison',
        'niveau1' => 'Niveau1',
        'niveau2' => 'Niveau2',
        'niveau3' => 'Niveau3',
        'niveau4' => 'Niveau4',
        'categorie1' => 'Categorie1',
        'categorie2' => 'Categorie2',
        'categorie3' => 'Categorie3',
        'categorie4' => 'Categorie4',
        'classification' => 'Classification',
        'marque' => 'Marque',
        'collection' => 'Collection',
        'saison' => 'Saison',
        'code_taric' => 'CodeTaric',
        'code_pays_fabrication' => 'CodePaysFabrication',
        'encombrement' => 'Encombrement',
        'poids' => 'Poids',
        'volume' => 'Volume',
        'prix_ttc' => 'PrixTTC',
        'prix_normal_ttc' => 'PrixNormalTTC',
        'taux_tva' => 'TauxTVA',
        'eco_participation_ht' => 'EcoParticipationHT',
        'devise' => 'Devise',
        'en_solde' => 'EnSolde',
        'est_lot' => 'EstLot',
        'est_service' => 'EstService',
        'seo_modele' => 'SeoModele',
        'seo_declinaison' => 'SeoDeclinaison',
        'description' => 'Description',
        'photos' => 'Photos',
        'en_ligne' => 'EnLigne',
        'mis_en_ligne' => 'MisEnLigne',
        'derniere_modification' => 'DerniereModification',
        'derniere_changement' => 'DerniereChangement',
        'quarantaine' => 'Quarantaine',
        'themes' => 'Themes',
        'proprietes' => 'Proprietes',
        'last_modif' => 'LastModif',
        'last_changement' => 'LastChangement',
        'tailles' => 'Tailles'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'nom_variante' => 'setNomVariante',
        'no' => 'setNo',
        'no_modele' => 'setNoModele',
        'code' => 'setCode',
        'grille_taille' => 'setGrilleTaille',
        'code_ref' => 'setCodeRef',
        'libelle' => 'setLibelle',
        'declinaison' => 'setDeclinaison',
        'zonage_modele' => 'setZonageModele',
        'zonage_declinaison' => 'setZonageDeclinaison',
        'niveau1' => 'setNiveau1',
        'niveau2' => 'setNiveau2',
        'niveau3' => 'setNiveau3',
        'niveau4' => 'setNiveau4',
        'categorie1' => 'setCategorie1',
        'categorie2' => 'setCategorie2',
        'categorie3' => 'setCategorie3',
        'categorie4' => 'setCategorie4',
        'classification' => 'setClassification',
        'marque' => 'setMarque',
        'collection' => 'setCollection',
        'saison' => 'setSaison',
        'code_taric' => 'setCodeTaric',
        'code_pays_fabrication' => 'setCodePaysFabrication',
        'encombrement' => 'setEncombrement',
        'poids' => 'setPoids',
        'volume' => 'setVolume',
        'prix_ttc' => 'setPrixTtc',
        'prix_normal_ttc' => 'setPrixNormalTtc',
        'taux_tva' => 'setTauxTva',
        'eco_participation_ht' => 'setEcoParticipationHt',
        'devise' => 'setDevise',
        'en_solde' => 'setEnSolde',
        'est_lot' => 'setEstLot',
        'est_service' => 'setEstService',
        'seo_modele' => 'setSeoModele',
        'seo_declinaison' => 'setSeoDeclinaison',
        'description' => 'setDescription',
        'photos' => 'setPhotos',
        'en_ligne' => 'setEnLigne',
        'mis_en_ligne' => 'setMisEnLigne',
        'derniere_modification' => 'setDerniereModification',
        'derniere_changement' => 'setDerniereChangement',
        'quarantaine' => 'setQuarantaine',
        'themes' => 'setThemes',
        'proprietes' => 'setProprietes',
        'last_modif' => 'setLastModif',
        'last_changement' => 'setLastChangement',
        'tailles' => 'setTailles'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'nom_variante' => 'getNomVariante',
        'no' => 'getNo',
        'no_modele' => 'getNoModele',
        'code' => 'getCode',
        'grille_taille' => 'getGrilleTaille',
        'code_ref' => 'getCodeRef',
        'libelle' => 'getLibelle',
        'declinaison' => 'getDeclinaison',
        'zonage_modele' => 'getZonageModele',
        'zonage_declinaison' => 'getZonageDeclinaison',
        'niveau1' => 'getNiveau1',
        'niveau2' => 'getNiveau2',
        'niveau3' => 'getNiveau3',
        'niveau4' => 'getNiveau4',
        'categorie1' => 'getCategorie1',
        'categorie2' => 'getCategorie2',
        'categorie3' => 'getCategorie3',
        'categorie4' => 'getCategorie4',
        'classification' => 'getClassification',
        'marque' => 'getMarque',
        'collection' => 'getCollection',
        'saison' => 'getSaison',
        'code_taric' => 'getCodeTaric',
        'code_pays_fabrication' => 'getCodePaysFabrication',
        'encombrement' => 'getEncombrement',
        'poids' => 'getPoids',
        'volume' => 'getVolume',
        'prix_ttc' => 'getPrixTtc',
        'prix_normal_ttc' => 'getPrixNormalTtc',
        'taux_tva' => 'getTauxTva',
        'eco_participation_ht' => 'getEcoParticipationHt',
        'devise' => 'getDevise',
        'en_solde' => 'getEnSolde',
        'est_lot' => 'getEstLot',
        'est_service' => 'getEstService',
        'seo_modele' => 'getSeoModele',
        'seo_declinaison' => 'getSeoDeclinaison',
        'description' => 'getDescription',
        'photos' => 'getPhotos',
        'en_ligne' => 'getEnLigne',
        'mis_en_ligne' => 'getMisEnLigne',
        'derniere_modification' => 'getDerniereModification',
        'derniere_changement' => 'getDerniereChangement',
        'quarantaine' => 'getQuarantaine',
        'themes' => 'getThemes',
        'proprietes' => 'getProprietes',
        'last_modif' => 'getLastModif',
        'last_changement' => 'getLastChangement',
        'tailles' => 'getTailles'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('nom_variante', $data ?? [], null);
        $this->setIfExists('no', $data ?? [], 0);
        $this->setIfExists('no_modele', $data ?? [], 0);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('grille_taille', $data ?? [], null);
        $this->setIfExists('code_ref', $data ?? [], 0);
        $this->setIfExists('libelle', $data ?? [], null);
        $this->setIfExists('declinaison', $data ?? [], null);
        $this->setIfExists('zonage_modele', $data ?? [], null);
        $this->setIfExists('zonage_declinaison', $data ?? [], null);
        $this->setIfExists('niveau1', $data ?? [], null);
        $this->setIfExists('niveau2', $data ?? [], null);
        $this->setIfExists('niveau3', $data ?? [], null);
        $this->setIfExists('niveau4', $data ?? [], null);
        $this->setIfExists('categorie1', $data ?? [], null);
        $this->setIfExists('categorie2', $data ?? [], null);
        $this->setIfExists('categorie3', $data ?? [], null);
        $this->setIfExists('categorie4', $data ?? [], null);
        $this->setIfExists('classification', $data ?? [], null);
        $this->setIfExists('marque', $data ?? [], null);
        $this->setIfExists('collection', $data ?? [], null);
        $this->setIfExists('saison', $data ?? [], null);
        $this->setIfExists('code_taric', $data ?? [], null);
        $this->setIfExists('code_pays_fabrication', $data ?? [], null);
        $this->setIfExists('encombrement', $data ?? [], 0);
        $this->setIfExists('poids', $data ?? [], 0);
        $this->setIfExists('volume', $data ?? [], null);
        $this->setIfExists('prix_ttc', $data ?? [], null);
        $this->setIfExists('prix_normal_ttc', $data ?? [], null);
        $this->setIfExists('taux_tva', $data ?? [], null);
        $this->setIfExists('eco_participation_ht', $data ?? [], null);
        $this->setIfExists('devise', $data ?? [], null);
        $this->setIfExists('en_solde', $data ?? [], true);
        $this->setIfExists('est_lot', $data ?? [], false);
        $this->setIfExists('est_service', $data ?? [], false);
        $this->setIfExists('seo_modele', $data ?? [], null);
        $this->setIfExists('seo_declinaison', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('photos', $data ?? [], null);
        $this->setIfExists('en_ligne', $data ?? [], false);
        $this->setIfExists('mis_en_ligne', $data ?? [], null);
        $this->setIfExists('derniere_modification', $data ?? [], null);
        $this->setIfExists('derniere_changement', $data ?? [], null);
        $this->setIfExists('quarantaine', $data ?? [], false);
        $this->setIfExists('themes', $data ?? [], null);
        $this->setIfExists('proprietes', $data ?? [], null);
        $this->setIfExists('last_modif', $data ?? [], null);
        $this->setIfExists('last_changement', $data ?? [], null);
        $this->setIfExists('tailles', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets nom_variante
     *
     * @return string|null
     */
    public function getNomVariante()
    {
        return $this->container['nom_variante'];
    }

    /**
     * Sets nom_variante
     *
     * @param string|null $nom_variante Nom de la variante du produit, non triable
     *
     * @return self
     */
    public function setNomVariante($nom_variante)
    {
        if (is_null($nom_variante)) {
            throw new \InvalidArgumentException('non-nullable nom_variante cannot be null');
        }
        $this->container['nom_variante'] = $nom_variante;

        return $this;
    }

    /**
     * Gets no
     *
     * @return int|null
     */
    public function getNo()
    {
        return $this->container['no'];
    }

    /**
     * Sets no
     *
     * @param int|null $no Numéro d'identification du produit (numéro interne de la déclinaison du modèle - unique)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setNo($no)
    {
        if (is_null($no)) {
            throw new \InvalidArgumentException('non-nullable no cannot be null');
        }
        $this->container['no'] = $no;

        return $this;
    }

    /**
     * Gets no_modele
     *
     * @return int|null
     */
    public function getNoModele()
    {
        return $this->container['no_modele'];
    }

    /**
     * Sets no_modele
     *
     * @param int|null $no_modele Numéro d'identification du modèle de produits, utile pour regrouper ou retrouver toutes les déclinaisons (coloris, matière, ...) d'un même modèle    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setNoModele($no_modele)
    {
        if (is_null($no_modele)) {
            throw new \InvalidArgumentException('non-nullable no_modele cannot be null');
        }
        $this->container['no_modele'] = $no_modele;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Code du produit    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets grille_taille
     *
     * @return string|null
     */
    public function getGrilleTaille()
    {
        return $this->container['grille_taille'];
    }

    /**
     * Sets grille_taille
     *
     * @param string|null $grille_taille Nom de la grille de taille du produit    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setGrilleTaille($grille_taille)
    {
        if (is_null($grille_taille)) {
            throw new \InvalidArgumentException('non-nullable grille_taille cannot be null');
        }
        $this->container['grille_taille'] = $grille_taille;

        return $this;
    }

    /**
     * Gets code_ref
     *
     * @return int|null
     */
    public function getCodeRef()
    {
        return $this->container['code_ref'];
    }

    /**
     * Sets code_ref
     *
     * @param int|null $code_ref Code numérique alternatif de référence pour la déclinaison, si fonctionnalité activée dans Polaris    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodeRef($code_ref)
    {
        if (is_null($code_ref)) {
            throw new \InvalidArgumentException('non-nullable code_ref cannot be null');
        }
        $this->container['code_ref'] = $code_ref;

        return $this;
    }

    /**
     * Gets libelle
     *
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->container['libelle'];
    }

    /**
     * Sets libelle
     *
     * @param string|null $libelle Nom du produit    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setLibelle($libelle)
    {
        if (is_null($libelle)) {
            throw new \InvalidArgumentException('non-nullable libelle cannot be null');
        }
        $this->container['libelle'] = $libelle;

        return $this;
    }

    /**
     * Gets declinaison
     *
     * @return string|null
     */
    public function getDeclinaison()
    {
        return $this->container['declinaison'];
    }

    /**
     * Sets declinaison
     *
     * @param string|null $declinaison Nom de la déclinaison    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDeclinaison($declinaison)
    {
        if (is_null($declinaison)) {
            throw new \InvalidArgumentException('non-nullable declinaison cannot be null');
        }
        $this->container['declinaison'] = $declinaison;

        return $this;
    }

    /**
     * Gets zonage_modele
     *
     * @return string|null
     */
    public function getZonageModele()
    {
        return $this->container['zonage_modele'];
    }

    /**
     * Sets zonage_modele
     *
     * @param string|null $zonage_modele Code zone du modèle    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setZonageModele($zonage_modele)
    {
        if (is_null($zonage_modele)) {
            throw new \InvalidArgumentException('non-nullable zonage_modele cannot be null');
        }
        $this->container['zonage_modele'] = $zonage_modele;

        return $this;
    }

    /**
     * Gets zonage_declinaison
     *
     * @return string|null
     */
    public function getZonageDeclinaison()
    {
        return $this->container['zonage_declinaison'];
    }

    /**
     * Sets zonage_declinaison
     *
     * @param string|null $zonage_declinaison Code zone de la déclinaison    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setZonageDeclinaison($zonage_declinaison)
    {
        if (is_null($zonage_declinaison)) {
            throw new \InvalidArgumentException('non-nullable zonage_declinaison cannot be null');
        }
        $this->container['zonage_declinaison'] = $zonage_declinaison;

        return $this;
    }

    /**
     * Gets niveau1
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau|null
     */
    public function getNiveau1()
    {
        return $this->container['niveau1'];
    }

    /**
     * Sets niveau1
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau|null $niveau1 niveau1
     *
     * @return self
     */
    public function setNiveau1($niveau1)
    {
        if (is_null($niveau1)) {
            throw new \InvalidArgumentException('non-nullable niveau1 cannot be null');
        }
        $this->container['niveau1'] = $niveau1;

        return $this;
    }

    /**
     * Gets niveau2
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau|null
     */
    public function getNiveau2()
    {
        return $this->container['niveau2'];
    }

    /**
     * Sets niveau2
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau|null $niveau2 niveau2
     *
     * @return self
     */
    public function setNiveau2($niveau2)
    {
        if (is_null($niveau2)) {
            throw new \InvalidArgumentException('non-nullable niveau2 cannot be null');
        }
        $this->container['niveau2'] = $niveau2;

        return $this;
    }

    /**
     * Gets niveau3
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau|null
     */
    public function getNiveau3()
    {
        return $this->container['niveau3'];
    }

    /**
     * Sets niveau3
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau|null $niveau3 niveau3
     *
     * @return self
     */
    public function setNiveau3($niveau3)
    {
        if (is_null($niveau3)) {
            throw new \InvalidArgumentException('non-nullable niveau3 cannot be null');
        }
        $this->container['niveau3'] = $niveau3;

        return $this;
    }

    /**
     * Gets niveau4
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau|null
     */
    public function getNiveau4()
    {
        return $this->container['niveau4'];
    }

    /**
     * Sets niveau4
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierNiveauWebConnectProductNiveau|null $niveau4 niveau4
     *
     * @return self
     */
    public function setNiveau4($niveau4)
    {
        if (is_null($niveau4)) {
            throw new \InvalidArgumentException('non-nullable niveau4 cannot be null');
        }
        $this->container['niveau4'] = $niveau4;

        return $this;
    }

    /**
     * Gets categorie1
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie|null
     */
    public function getCategorie1()
    {
        return $this->container['categorie1'];
    }

    /**
     * Sets categorie1
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie|null $categorie1 categorie1
     *
     * @return self
     */
    public function setCategorie1($categorie1)
    {
        if (is_null($categorie1)) {
            throw new \InvalidArgumentException('non-nullable categorie1 cannot be null');
        }
        $this->container['categorie1'] = $categorie1;

        return $this;
    }

    /**
     * Gets categorie2
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie|null
     */
    public function getCategorie2()
    {
        return $this->container['categorie2'];
    }

    /**
     * Sets categorie2
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie|null $categorie2 categorie2
     *
     * @return self
     */
    public function setCategorie2($categorie2)
    {
        if (is_null($categorie2)) {
            throw new \InvalidArgumentException('non-nullable categorie2 cannot be null');
        }
        $this->container['categorie2'] = $categorie2;

        return $this;
    }

    /**
     * Gets categorie3
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie|null
     */
    public function getCategorie3()
    {
        return $this->container['categorie3'];
    }

    /**
     * Sets categorie3
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie|null $categorie3 categorie3
     *
     * @return self
     */
    public function setCategorie3($categorie3)
    {
        if (is_null($categorie3)) {
            throw new \InvalidArgumentException('non-nullable categorie3 cannot be null');
        }
        $this->container['categorie3'] = $categorie3;

        return $this;
    }

    /**
     * Gets categorie4
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie|null
     */
    public function getCategorie4()
    {
        return $this->container['categorie4'];
    }

    /**
     * Sets categorie4
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCategorieWebConnectProductCategorie|null $categorie4 categorie4
     *
     * @return self
     */
    public function setCategorie4($categorie4)
    {
        if (is_null($categorie4)) {
            throw new \InvalidArgumentException('non-nullable categorie4 cannot be null');
        }
        $this->container['categorie4'] = $categorie4;

        return $this;
    }

    /**
     * Gets classification
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassification|null
     */
    public function getClassification()
    {
        return $this->container['classification'];
    }

    /**
     * Sets classification
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClassificationWebConnectClassification|null $classification classification
     *
     * @return self
     */
    public function setClassification($classification)
    {
        if (is_null($classification)) {
            throw new \InvalidArgumentException('non-nullable classification cannot be null');
        }
        $this->container['classification'] = $classification;

        return $this;
    }

    /**
     * Gets marque
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarque|null
     */
    public function getMarque()
    {
        return $this->container['marque'];
    }

    /**
     * Sets marque
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMarqueWebConnectMarque|null $marque marque
     *
     * @return self
     */
    public function setMarque($marque)
    {
        if (is_null($marque)) {
            throw new \InvalidArgumentException('non-nullable marque cannot be null');
        }
        $this->container['marque'] = $marque;

        return $this;
    }

    /**
     * Gets collection
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCollectionWebConnectProductCollection|null
     */
    public function getCollection()
    {
        return $this->container['collection'];
    }

    /**
     * Sets collection
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCollectionWebConnectProductCollection|null $collection collection
     *
     * @return self
     */
    public function setCollection($collection)
    {
        if (is_null($collection)) {
            throw new \InvalidArgumentException('non-nullable collection cannot be null');
        }
        $this->container['collection'] = $collection;

        return $this;
    }

    /**
     * Gets saison
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierSaisonWebConnectSaison|null
     */
    public function getSaison()
    {
        return $this->container['saison'];
    }

    /**
     * Sets saison
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierSaisonWebConnectSaison|null $saison saison
     *
     * @return self
     */
    public function setSaison($saison)
    {
        if (is_null($saison)) {
            throw new \InvalidArgumentException('non-nullable saison cannot be null');
        }
        $this->container['saison'] = $saison;

        return $this;
    }

    /**
     * Gets code_taric
     *
     * @return string|null
     */
    public function getCodeTaric()
    {
        return $this->container['code_taric'];
    }

    /**
     * Sets code_taric
     *
     * @param string|null $code_taric Code Taric (HS Code / douane)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodeTaric($code_taric)
    {
        if (is_null($code_taric)) {
            throw new \InvalidArgumentException('non-nullable code_taric cannot be null');
        }
        $this->container['code_taric'] = $code_taric;

        return $this;
    }

    /**
     * Gets code_pays_fabrication
     *
     * @return string|null
     */
    public function getCodePaysFabrication()
    {
        return $this->container['code_pays_fabrication'];
    }

    /**
     * Sets code_pays_fabrication
     *
     * @param string|null $code_pays_fabrication Code ISO 3166A3 du pays de fabrication    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCodePaysFabrication($code_pays_fabrication)
    {
        if (is_null($code_pays_fabrication)) {
            throw new \InvalidArgumentException('non-nullable code_pays_fabrication cannot be null');
        }
        $this->container['code_pays_fabrication'] = $code_pays_fabrication;

        return $this;
    }

    /**
     * Gets encombrement
     *
     * @return int|null
     */
    public function getEncombrement()
    {
        return $this->container['encombrement'];
    }

    /**
     * Sets encombrement
     *
     * @param int|null $encombrement Indice d'encombrement du produit (consultez l'administrateur du backoffice pour connaître comment il est calculé)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEncombrement($encombrement)
    {
        if (is_null($encombrement)) {
            throw new \InvalidArgumentException('non-nullable encombrement cannot be null');
        }
        $this->container['encombrement'] = $encombrement;

        return $this;
    }

    /**
     * Gets poids
     *
     * @return int|null
     */
    public function getPoids()
    {
        return $this->container['poids'];
    }

    /**
     * Sets poids
     *
     * @param int|null $poids Poids du produit, en grammes    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPoids($poids)
    {
        if (is_null($poids)) {
            throw new \InvalidArgumentException('non-nullable poids cannot be null');
        }
        $this->container['poids'] = $poids;

        return $this;
    }

    /**
     * Gets volume
     *
     * @return int[]|null
     */
    public function getVolume()
    {
        return $this->container['volume'];
    }

    /**
     * Sets volume
     *
     * @param int[]|null $volume Dimensions du produit en millimètres [Longueur, Largeur, Hauteur]    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setVolume($volume)
    {
        if (is_null($volume)) {
            throw new \InvalidArgumentException('non-nullable volume cannot be null');
        }
        $this->container['volume'] = $volume;

        return $this;
    }

    /**
     * Gets prix_ttc
     *
     * @return float|null
     */
    public function getPrixTtc()
    {
        return $this->container['prix_ttc'];
    }

    /**
     * Sets prix_ttc
     *
     * @param float|null $prix_ttc Prix le plus faible, promo comprise, dans le magasin physique de référence, ou à défaut prix le plus faible dans les autres magasins physiques Ce prix n'est pas a utiliser pour la gestion des soldes sur internet    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPrixTtc($prix_ttc)
    {
        if (is_null($prix_ttc)) {
            throw new \InvalidArgumentException('non-nullable prix_ttc cannot be null');
        }
        $this->container['prix_ttc'] = $prix_ttc;

        return $this;
    }

    /**
     * Gets prix_normal_ttc
     *
     * @return float|null
     */
    public function getPrixNormalTtc()
    {
        return $this->container['prix_normal_ttc'];
    }

    /**
     * Sets prix_normal_ttc
     *
     * @param float|null $prix_normal_ttc Prix le plus faible, hors promo, dans le magasin de référence, ou à défaut dans les autres magasins    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setPrixNormalTtc($prix_normal_ttc)
    {
        if (is_null($prix_normal_ttc)) {
            throw new \InvalidArgumentException('non-nullable prix_normal_ttc cannot be null');
        }
        $this->container['prix_normal_ttc'] = $prix_normal_ttc;

        return $this;
    }

    /**
     * Gets taux_tva
     *
     * @return float|null
     */
    public function getTauxTva()
    {
        return $this->container['taux_tva'];
    }

    /**
     * Sets taux_tva
     *
     * @param float|null $taux_tva Taux de TVA du produit dans le magasin de référence    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setTauxTva($taux_tva)
    {
        if (is_null($taux_tva)) {
            throw new \InvalidArgumentException('non-nullable taux_tva cannot be null');
        }
        $this->container['taux_tva'] = $taux_tva;

        return $this;
    }

    /**
     * Gets eco_participation_ht
     *
     * @return float|null
     */
    public function getEcoParticipationHt()
    {
        return $this->container['eco_participation_ht'];
    }

    /**
     * Sets eco_participation_ht
     *
     * @param float|null $eco_participation_ht Montant de l'éco-participation, hors taxe    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEcoParticipationHt($eco_participation_ht)
    {
        if (is_null($eco_participation_ht)) {
            throw new \InvalidArgumentException('non-nullable eco_participation_ht cannot be null');
        }
        $this->container['eco_participation_ht'] = $eco_participation_ht;

        return $this;
    }

    /**
     * Gets devise
     *
     * @return string|null
     */
    public function getDevise()
    {
        return $this->container['devise'];
    }

    /**
     * Sets devise
     *
     * @param string|null $devise Code international de la devise des prix annoncés    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDevise($devise)
    {
        if (is_null($devise)) {
            throw new \InvalidArgumentException('non-nullable devise cannot be null');
        }
        $this->container['devise'] = $devise;

        return $this;
    }

    /**
     * Gets en_solde
     *
     * @return bool|null
     */
    public function getEnSolde()
    {
        return $this->container['en_solde'];
    }

    /**
     * Sets en_solde
     *
     * @param bool|null $en_solde En solde dans le magasin de référence    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEnSolde($en_solde)
    {
        if (is_null($en_solde)) {
            throw new \InvalidArgumentException('non-nullable en_solde cannot be null');
        }
        $this->container['en_solde'] = $en_solde;

        return $this;
    }

    /**
     * Gets est_lot
     *
     * @return bool|null
     */
    public function getEstLot()
    {
        return $this->container['est_lot'];
    }

    /**
     * Sets est_lot
     *
     * @param bool|null $est_lot Vrai si le modèle représente un lot de modèles    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEstLot($est_lot)
    {
        if (is_null($est_lot)) {
            throw new \InvalidArgumentException('non-nullable est_lot cannot be null');
        }
        $this->container['est_lot'] = $est_lot;

        return $this;
    }

    /**
     * Gets est_service
     *
     * @return bool|null
     */
    public function getEstService()
    {
        return $this->container['est_service'];
    }

    /**
     * Sets est_service
     *
     * @param bool|null $est_service Vrai si le modèle est un service et non un produit (pas de gestion de stock)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEstService($est_service)
    {
        if (is_null($est_service)) {
            throw new \InvalidArgumentException('non-nullable est_service cannot be null');
        }
        $this->container['est_service'] = $est_service;

        return $this;
    }

    /**
     * Gets seo_modele
     *
     * @return string|null
     */
    public function getSeoModele()
    {
        return $this->container['seo_modele'];
    }

    /**
     * Sets seo_modele
     *
     * @param string|null $seo_modele Informations SEO liées au modèle    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setSeoModele($seo_modele)
    {
        if (is_null($seo_modele)) {
            throw new \InvalidArgumentException('non-nullable seo_modele cannot be null');
        }
        $this->container['seo_modele'] = $seo_modele;

        return $this;
    }

    /**
     * Gets seo_declinaison
     *
     * @return string|null
     */
    public function getSeoDeclinaison()
    {
        return $this->container['seo_declinaison'];
    }

    /**
     * Sets seo_declinaison
     *
     * @param string|null $seo_declinaison Informations SEO liées à cette déclinaison du modèle    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setSeoDeclinaison($seo_declinaison)
    {
        if (is_null($seo_declinaison)) {
            throw new \InvalidArgumentException('non-nullable seo_declinaison cannot be null');
        }
        $this->container['seo_declinaison'] = $seo_declinaison;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Description du produit    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets photos
     *
     * @return int[]|null
     */
    public function getPhotos()
    {
        return $this->container['photos'];
    }

    /**
     * Sets photos
     *
     * @param int[]|null $photos Identifiant des photos associées
     *
     * @return self
     */
    public function setPhotos($photos)
    {
        if (is_null($photos)) {
            throw new \InvalidArgumentException('non-nullable photos cannot be null');
        }
        $this->container['photos'] = $photos;

        return $this;
    }

    /**
     * Gets en_ligne
     *
     * @return bool|null
     */
    public function getEnLigne()
    {
        return $this->container['en_ligne'];
    }

    /**
     * Sets en_ligne
     *
     * @param bool|null $en_ligne Vrai si le produit est marqué comme étant publié sur le site Internet    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEnLigne($en_ligne)
    {
        if (is_null($en_ligne)) {
            throw new \InvalidArgumentException('non-nullable en_ligne cannot be null');
        }
        $this->container['en_ligne'] = $en_ligne;

        return $this;
    }

    /**
     * Gets mis_en_ligne
     *
     * @return \DateTime|null
     */
    public function getMisEnLigne()
    {
        return $this->container['mis_en_ligne'];
    }

    /**
     * Sets mis_en_ligne
     *
     * @param \DateTime|null $mis_en_ligne Date de première mise en ligne du produit    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setMisEnLigne($mis_en_ligne)
    {
        if (is_null($mis_en_ligne)) {
            array_push($this->openAPINullablesSetToNull, 'mis_en_ligne');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('mis_en_ligne', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['mis_en_ligne'] = $mis_en_ligne;

        return $this;
    }

    /**
     * Gets derniere_modification
     *
     * @return \DateTime|null
     */
    public function getDerniereModification()
    {
        return $this->container['derniere_modification'];
    }

    /**
     * Sets derniere_modification
     *
     * @param \DateTime|null $derniere_modification Date de dernière modification des propriétés du produit    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereModification($derniere_modification)
    {
        if (is_null($derniere_modification)) {
            throw new \InvalidArgumentException('non-nullable derniere_modification cannot be null');
        }
        $this->container['derniere_modification'] = $derniere_modification;

        return $this;
    }

    /**
     * Gets derniere_changement
     *
     * @return \DateTime|null
     */
    public function getDerniereChangement()
    {
        return $this->container['derniere_changement'];
    }

    /**
     * Sets derniere_changement
     *
     * @param \DateTime|null $derniere_changement Date de dernière modification des propriétés du produit, des stocks et des prix    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereChangement($derniere_changement)
    {
        if (is_null($derniere_changement)) {
            throw new \InvalidArgumentException('non-nullable derniere_changement cannot be null');
        }
        $this->container['derniere_changement'] = $derniere_changement;

        return $this;
    }

    /**
     * Gets quarantaine
     *
     * @return bool|null
     */
    public function getQuarantaine()
    {
        return $this->container['quarantaine'];
    }

    /**
     * Sets quarantaine
     *
     * @param bool|null $quarantaine Vrai si le produit n'est plus utilisé et sera supprimé à terme    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setQuarantaine($quarantaine)
    {
        if (is_null($quarantaine)) {
            throw new \InvalidArgumentException('non-nullable quarantaine cannot be null');
        }
        $this->container['quarantaine'] = $quarantaine;

        return $this;
    }

    /**
     * Gets themes
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\ProduitTheme[]|null
     */
    public function getThemes()
    {
        return $this->container['themes'];
    }

    /**
     * Sets themes
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\ProduitTheme[]|null $themes Thèmes
     *
     * @return self
     */
    public function setThemes($themes)
    {
        if (is_null($themes)) {
            throw new \InvalidArgumentException('non-nullable themes cannot be null');
        }
        $this->container['themes'] = $themes;

        return $this;
    }

    /**
     * Gets proprietes
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\ProduitPropriete[]|null
     */
    public function getProprietes()
    {
        return $this->container['proprietes'];
    }

    /**
     * Sets proprietes
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\ProduitPropriete[]|null $proprietes Propriétés
     *
     * @return self
     */
    public function setProprietes($proprietes)
    {
        if (is_null($proprietes)) {
            throw new \InvalidArgumentException('non-nullable proprietes cannot be null');
        }
        $this->container['proprietes'] = $proprietes;

        return $this;
    }

    /**
     * Gets last_modif
     *
     * @return string|null
     */
    public function getLastModif()
    {
        return $this->container['last_modif'];
    }

    /**
     * Sets last_modif
     *
     * @param string|null $last_modif 
     *
     * @return self
     */
    public function setLastModif($last_modif)
    {
        if (is_null($last_modif)) {
            throw new \InvalidArgumentException('non-nullable last_modif cannot be null');
        }
        $this->container['last_modif'] = $last_modif;

        return $this;
    }

    /**
     * Gets last_changement
     *
     * @return string|null
     */
    public function getLastChangement()
    {
        return $this->container['last_changement'];
    }

    /**
     * Sets last_changement
     *
     * @param string|null $last_changement 
     *
     * @return self
     */
    public function setLastChangement($last_changement)
    {
        if (is_null($last_changement)) {
            throw new \InvalidArgumentException('non-nullable last_changement cannot be null');
        }
        $this->container['last_changement'] = $last_changement;

        return $this;
    }

    /**
     * Gets tailles
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\ProduitDetailTaille[]|null
     */
    public function getTailles()
    {
        return $this->container['tailles'];
    }

    /**
     * Sets tailles
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\ProduitDetailTaille[]|null $tailles Tailles
     *
     * @return self
     */
    public function setTailles($tailles)
    {
        if (is_null($tailles)) {
            throw new \InvalidArgumentException('non-nullable tailles cannot be null');
        }
        $this->container['tailles'] = $tailles;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


