<?php
/**
 * MetierCPCarteWebConnectCartePrePayeeClient
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 13.3.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model;

use \ArrayAccess;
use \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;

/**
 * MetierCPCarteWebConnectCartePrePayeeClient Class Doc Comment
 *
 * @category Class
 * @description (fullname : piu_Ventes.MetierCPCarte.WebConnectCartePrePayeeClient)
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MetierCPCarteWebConnectCartePrePayeeClient implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MetierCPCarte_WebConnectCartePrePayeeClient';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'client' => '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientId',
        'code' => 'string',
        'montant' => 'float',
        'date_emission' => '\DateTime',
        'date_validite' => '\DateTime',
        'date_passage' => '\DateTime',
        'date_depart' => '\DateTime',
        'est_valide' => 'bool',
        'quarantaine' => 'bool',
        'derniere_modification' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'client' => null,
        'code' => null,
        'montant' => 'decimal',
        'date_emission' => 'date-time',
        'date_validite' => 'date-time',
        'date_passage' => 'date-time',
        'date_depart' => 'date-time',
        'est_valide' => null,
        'quarantaine' => null,
        'derniere_modification' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'client' => false,
        'code' => false,
        'montant' => true,
        'date_emission' => false,
        'date_validite' => true,
        'date_passage' => true,
        'date_depart' => true,
        'est_valide' => false,
        'quarantaine' => false,
        'derniere_modification' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'client' => 'Client',
        'code' => 'Code',
        'montant' => 'Montant',
        'date_emission' => 'DateEmission',
        'date_validite' => 'DateValidite',
        'date_passage' => 'DatePassage',
        'date_depart' => 'DateDepart',
        'est_valide' => 'EstValide',
        'quarantaine' => 'Quarantaine',
        'derniere_modification' => 'DerniereModification'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'client' => 'setClient',
        'code' => 'setCode',
        'montant' => 'setMontant',
        'date_emission' => 'setDateEmission',
        'date_validite' => 'setDateValidite',
        'date_passage' => 'setDatePassage',
        'date_depart' => 'setDateDepart',
        'est_valide' => 'setEstValide',
        'quarantaine' => 'setQuarantaine',
        'derniere_modification' => 'setDerniereModification'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'client' => 'getClient',
        'code' => 'getCode',
        'montant' => 'getMontant',
        'date_emission' => 'getDateEmission',
        'date_validite' => 'getDateValidite',
        'date_passage' => 'getDatePassage',
        'date_depart' => 'getDateDepart',
        'est_valide' => 'getEstValide',
        'quarantaine' => 'getQuarantaine',
        'derniere_modification' => 'getDerniereModification'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('client', $data ?? [], null);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('montant', $data ?? [], null);
        $this->setIfExists('date_emission', $data ?? [], null);
        $this->setIfExists('date_validite', $data ?? [], null);
        $this->setIfExists('date_passage', $data ?? [], null);
        $this->setIfExists('date_depart', $data ?? [], null);
        $this->setIfExists('est_valide', $data ?? [], false);
        $this->setIfExists('quarantaine', $data ?? [], false);
        $this->setIfExists('derniere_modification', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets client
     *
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientId|null
     */
    public function getClient()
    {
        return $this->container['client'];
    }

    /**
     * Sets client
     *
     * @param \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientId|null $client client
     *
     * @return self
     */
    public function setClient($client)
    {
        if (is_null($client)) {
            throw new \InvalidArgumentException('non-nullable client cannot be null');
        }
        $this->container['client'] = $client;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Code barres identifiant de la carte prépayée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets montant
     *
     * @return float|null
     */
    public function getMontant()
    {
        return $this->container['montant'];
    }

    /**
     * Sets montant
     *
     * @param float|null $montant Montant sur la carte prépayée)    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setMontant($montant)
    {
        if (is_null($montant)) {
            array_push($this->openAPINullablesSetToNull, 'montant');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('montant', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['montant'] = $montant;

        return $this;
    }

    /**
     * Gets date_emission
     *
     * @return \DateTime|null
     */
    public function getDateEmission()
    {
        return $this->container['date_emission'];
    }

    /**
     * Sets date_emission
     *
     * @param \DateTime|null $date_emission Date d'émission de la carte prépayée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDateEmission($date_emission)
    {
        if (is_null($date_emission)) {
            throw new \InvalidArgumentException('non-nullable date_emission cannot be null');
        }
        $this->container['date_emission'] = $date_emission;

        return $this;
    }

    /**
     * Gets date_validite
     *
     * @return \DateTime|null
     */
    public function getDateValidite()
    {
        return $this->container['date_validite'];
    }

    /**
     * Sets date_validite
     *
     * @param \DateTime|null $date_validite Date de validité sur la carte prépayée qui ont une durée de vie    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDateValidite($date_validite)
    {
        if (is_null($date_validite)) {
            array_push($this->openAPINullablesSetToNull, 'date_validite');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_validite', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_validite'] = $date_validite;

        return $this;
    }

    /**
     * Gets date_passage
     *
     * @return \DateTime|null
     */
    public function getDatePassage()
    {
        return $this->container['date_passage'];
    }

    /**
     * Sets date_passage
     *
     * @param \DateTime|null $date_passage Date du dernier passage sur la carte prépayée si elle a déjà était utilisée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDatePassage($date_passage)
    {
        if (is_null($date_passage)) {
            array_push($this->openAPINullablesSetToNull, 'date_passage');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_passage', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_passage'] = $date_passage;

        return $this;
    }

    /**
     * Gets date_depart
     *
     * @return \DateTime|null
     */
    public function getDateDepart()
    {
        return $this->container['date_depart'];
    }

    /**
     * Sets date_depart
     *
     * @param \DateTime|null $date_depart Date de début de la validité    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDateDepart($date_depart)
    {
        if (is_null($date_depart)) {
            array_push($this->openAPINullablesSetToNull, 'date_depart');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_depart', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_depart'] = $date_depart;

        return $this;
    }

    /**
     * Gets est_valide
     *
     * @return bool|null
     */
    public function getEstValide()
    {
        return $this->container['est_valide'];
    }

    /**
     * Sets est_valide
     *
     * @param bool|null $est_valide Indique vrai lorsque la carte prépayée peut-être utilisé    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setEstValide($est_valide)
    {
        if (is_null($est_valide)) {
            throw new \InvalidArgumentException('non-nullable est_valide cannot be null');
        }
        $this->container['est_valide'] = $est_valide;

        return $this;
    }

    /**
     * Gets quarantaine
     *
     * @return bool|null
     */
    public function getQuarantaine()
    {
        return $this->container['quarantaine'];
    }

    /**
     * Sets quarantaine
     *
     * @param bool|null $quarantaine Vrai quand la carte prépayée est marqué pour suppression et devrait être supprimé dans les bases des tiers    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setQuarantaine($quarantaine)
    {
        if (is_null($quarantaine)) {
            throw new \InvalidArgumentException('non-nullable quarantaine cannot be null');
        }
        $this->container['quarantaine'] = $quarantaine;

        return $this;
    }

    /**
     * Gets derniere_modification
     *
     * @return \DateTime|null
     */
    public function getDerniereModification()
    {
        return $this->container['derniere_modification'];
    }

    /**
     * Sets derniere_modification
     *
     * @param \DateTime|null $derniere_modification Date de dernière modification de la carte prépayée    *(en cas d'utilisation d'un pager et lorsqu'il est à la racine, vous pouvez trier sur ce champ)*
     *
     * @return self
     */
    public function setDerniereModification($derniere_modification)
    {
        if (is_null($derniere_modification)) {
            throw new \InvalidArgumentException('non-nullable derniere_modification cannot be null');
        }
        $this->container['derniere_modification'] = $derniere_modification;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


