<?php
namespace PrestaShop\Module\PolarisPrestaConnector\Models;

use DateTime;

/**
 * Objet d'interface contenant la définition d'un client
 */
class Customer extends SanitizedObject
{
    /**
     * Adresse mail du client
     * 
     * @param string Adresse mail du client
     */    
    public string $mail;    

    /**
     * Id client prestashop si connu, ou 0
     */
    public int $id_customer = 0;

    /**
     * Doit être effacé
     */
    public bool $delete = false;

    /**
     * Civilité
     */
    public string|null $civilite = null;

    /**
     * Nom du client
     */
    public string|null $lastname;

    /**
     * Prénom du client
     */
    public string|null $firstname;

    /**
     * Ok pour la newsletter
     */
    public bool|null $newsletter = null;

    /**
     * Démarchage ok
     */
    public bool|null $demarchage = null;
    
    /**
     * Nouvelles informations clients
     * 
     * @param int $id_customer Identifiant du client
     * @param string $mail Adresse mail du client
     */
    public function __construct(
        int $id_customer,
        string $mail,
        )
    {
        // Sanitize
        $this->id_customer = $id_customer;
        $this->mail = $mail;
    }

    /**
     * Nettoyage de la donnée sur les standards Prestashop
     */
    public function sanitize()
    {
        if ($this->civilite)
            $this->civilite = mb_strtoupper($this->sanitizeStr($this->civilite, 4));
        $this->lastname = mb_strtoupper(ltrim($this->sanitizeStr($this->lastname ?? 'INCONNU', 32)));
        $this->firstname = mb_ucwords(ltrim($this->sanitizeStr($this->firstname ?? 'Inconnu', 32)));

        // Trim all number from firstname
        $this->firstname = preg_replace('/\d/', '', $this->firstname);

        $this->mail = ltrim($this->mail);

        if (empty($this->lastname))
            $this->lastname = "INCONNU";

        if (empty($this->firstname))
            $this->firstname = "Inconnu"; 
    }
}