<?php
namespace PrestaShop\Module\PolarisPrestaConnector\Models;

/**
 * Objet d'interface contenant la définition d'un article (taille)
 */
class Article extends SanitizedObject
{
    /**
     * Référence de l'article
     *      
     */
    public string $ref;

    /**
     * Nom de la taille de l'article
     * 
     * @var string
     */
    public string $name;

    /**
     * Code EAN13 publique
     */
    public ?string $ean13 = null;

    /**
     * Prix TTC de l'article
     */
    public ?float $priceTTC = null;

    /**
     * Prix HT de l'article
     */
    public ?float $priceHT = null;

    /**
     * Zonage de l'article
     */
    public ?string $warehouseLocation = null;

    /**
     * Obtient le prix HT de l'article
     * 
     * @param Product $product Produit parent
     */
    public function getPriceHT(Product $product)
    {         
        if ($this->priceHT === NULL && $this->priceTTC !== NULL)
            $this->priceHT = round($this->priceTTC / (1 + $product->taxrate), 6);        
        return $this->priceHT;
    }

    /**
     * Obtient le prix TTC de l'article
     * 
     * @param Product $product Produit parent
     */
    public function getPriceTTC(Product $product)
    {
        if ($this->priceTTC === NULL && $this->priceHT !== NULL)
            $this->priceTTC = round($this->priceHT * (1 + $product->taxrate), 6);
        return $this->priceTTC;
    }

    /**
     * Nouvel article / taille
     * 
     * @param string $refs Codes-barre de la taille
     * @param string $name Nom de la taille de l'article
     */
    public function __construct(
        string $ref,
        string $name
        )
    {
        $this->ref = $ref;
        $this->name = $name;
    }

    /**
     * Nettoyage de la donnée sur les standards Prestashop
     */
    public function sanitize()
    {

    }
}