<?php
/**
 * VentesApi
 * PHP version 7.2
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Api;

use GuzzleHttp\Psr7\MultipartStream;
use Http\Client\Common\Plugin\ErrorPlugin;
use Http\Client\Common\Plugin\RedirectPlugin;
use Http\Client\Common\PluginClient;
use Http\Client\Common\PluginClientFactory;
use Http\Client\Exception\HttpException;
use Http\Client\HttpAsyncClient;
use Http\Discovery\HttpAsyncClientDiscovery;
use Http\Discovery\Psr17FactoryDiscovery;
use Http\Discovery\Psr18ClientDiscovery;
use Http\Message\RequestFactory;
use Http\Promise\Promise;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Configuration;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\DebugPlugin;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\HeaderSelector;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestFactoryInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\StreamFactoryInterface;
use Psr\Http\Message\UriFactoryInterface;
use Psr\Http\Message\UriInterface;
use function sprintf;

/**
 * VentesApi Class Doc Comment
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class VentesApi
{
    /**
     * @var PluginClient
     */
    protected $httpClient;

    /**
     * @var PluginClient
     */
    protected $httpAsyncClient;

    /**
     * @var UriFactoryInterface
     */
    protected $uriFactory;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @var RequestFactoryInterface
     */
    protected $requestFactory;

    /**
     * @var StreamFactoryInterface
     */
    protected $streamFactory;

    public function __construct(
        ClientInterface $httpClient = null,
        Configuration $config = null,
        HttpAsyncClient $httpAsyncClient = null,
        UriFactoryInterface $uriFactory = null,
        RequestFactoryInterface $requestFactory = null,
        StreamFactoryInterface $streamFactory = null,
        HeaderSelector $selector = null,
        ?array $plugins = null,
        $hostIndex = 0
    ) {
        $this->config = $config ?? (new Configuration())->setHost('https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api/WebConnect');
        $this->requestFactory = $requestFactory ?? Psr17FactoryDiscovery::findRequestFactory();
        $this->streamFactory = $streamFactory ?? Psr17FactoryDiscovery::findStreamFactory();

        $plugins = $plugins ?? [
            new RedirectPlugin(['strict' => true]),
            new ErrorPlugin(),
        ];

        if ($this->config->getDebug()) {
            $plugins[] = new DebugPlugin(fopen($this->config->getDebugFile(), 'ab'));
        }

        $this->httpClient = (new PluginClientFactory())->createClient(
            $httpClient ?? Psr18ClientDiscovery::find(),
            $plugins
        );

        $this->httpAsyncClient = (new PluginClientFactory())->createClient(
            $httpAsyncClient ?? HttpAsyncClientDiscovery::find(),
            $plugins
        );

        $this->uriFactory = $uriFactory ?? Psr17FactoryDiscovery::findUriFactory();

        $this->headerSelector = $selector ?? new HeaderSelector();

        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation ventesDeleteReservation
     *
     * Annule une réservation
     *
     * @param  string $code_reservation Code de la réservation à annuler (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation
     */
    public function ventesDeleteReservation($code_reservation)
    {
        list($response) = $this->ventesDeleteReservationWithHttpInfo($code_reservation);
        return $response;
    }

    /**
     * Operation ventesDeleteReservationWithHttpInfo
     *
     * Annule une réservation
     *
     * @param  string $code_reservation Code de la réservation à annuler (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation, HTTP status code, HTTP response headers (array of strings)
     */
    public function ventesDeleteReservationWithHttpInfo($code_reservation)
    {
        $request = $this->ventesDeleteReservationRequest($code_reservation);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ventesDeleteReservationAsync
     *
     * Annule une réservation
     *
     * @param  string $code_reservation Code de la réservation à annuler (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesDeleteReservationAsync($code_reservation)
    {
        return $this->ventesDeleteReservationAsyncWithHttpInfo($code_reservation)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ventesDeleteReservationAsyncWithHttpInfo
     *
     * Annule une réservation
     *
     * @param  string $code_reservation Code de la réservation à annuler (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesDeleteReservationAsyncWithHttpInfo($code_reservation)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation';
        $request = $this->ventesDeleteReservationRequest($code_reservation);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'ventesDeleteReservation'
     *
     * @param  string $code_reservation Code de la réservation à annuler (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function ventesDeleteReservationRequest($code_reservation)
    {
        // verify the required parameter 'code_reservation' is set
        if ($code_reservation === null || (is_array($code_reservation) && count($code_reservation) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $code_reservation when calling ventesDeleteReservation'
            );
        }

        $resourcePath = '/Ventes/Reservation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($code_reservation !== null) {
            if('form' === 'form' && is_array($code_reservation)) {
                foreach($code_reservation as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['codeReservation'] = $code_reservation;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('DELETE', $uri, $headers, $httpBody);
    }

    /**
     * Operation ventesDeleteVente
     *
     * Annule une vente précédemment créée sur le système. Vous ne pouvez effacer qu&#39;une vente que vous avez créé avec vos références extérieures.
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\DemandeAnnulationDebit $demande_annulation_debit Vente à annuler  (annulation) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId
     */
    public function ventesDeleteVente($demande_annulation_debit)
    {
        list($response) = $this->ventesDeleteVenteWithHttpInfo($demande_annulation_debit);
        return $response;
    }

    /**
     * Operation ventesDeleteVenteWithHttpInfo
     *
     * Annule une vente précédemment créée sur le système. Vous ne pouvez effacer qu&#39;une vente que vous avez créé avec vos références extérieures.
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\DemandeAnnulationDebit $demande_annulation_debit Vente à annuler  (annulation) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId, HTTP status code, HTTP response headers (array of strings)
     */
    public function ventesDeleteVenteWithHttpInfo($demande_annulation_debit)
    {
        $request = $this->ventesDeleteVenteRequest($demande_annulation_debit);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ventesDeleteVenteAsync
     *
     * Annule une vente précédemment créée sur le système. Vous ne pouvez effacer qu&#39;une vente que vous avez créé avec vos références extérieures.
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\DemandeAnnulationDebit $demande_annulation_debit Vente à annuler  (annulation) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesDeleteVenteAsync($demande_annulation_debit)
    {
        return $this->ventesDeleteVenteAsyncWithHttpInfo($demande_annulation_debit)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ventesDeleteVenteAsyncWithHttpInfo
     *
     * Annule une vente précédemment créée sur le système. Vous ne pouvez effacer qu&#39;une vente que vous avez créé avec vos références extérieures.
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\DemandeAnnulationDebit $demande_annulation_debit Vente à annuler  (annulation) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesDeleteVenteAsyncWithHttpInfo($demande_annulation_debit)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteId';
        $request = $this->ventesDeleteVenteRequest($demande_annulation_debit);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'ventesDeleteVente'
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\DemandeAnnulationDebit $demande_annulation_debit Vente à annuler  (annulation) (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function ventesDeleteVenteRequest($demande_annulation_debit)
    {
        // verify the required parameter 'demande_annulation_debit' is set
        if ($demande_annulation_debit === null || (is_array($demande_annulation_debit) && count($demande_annulation_debit) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $demande_annulation_debit when calling ventesDeleteVente'
            );
        }

        $resourcePath = '/Ventes/Vente';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($demande_annulation_debit)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($demande_annulation_debit));
            } else {
                $httpBody = $demande_annulation_debit;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('DELETE', $uri, $headers, $httpBody);
    }

    /**
     * Operation ventesGetReservations
     *
     * Obtenir les réservations du système
     *
     * @param  WebConnectFiltreReservation $filtre_reservations Si précisé, ne renvoi que les réservations correspondantes au filtrage (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultWebConnectReservation
     */
    public function ventesGetReservations($filtre_reservations = null, $pager = null)
    {
        list($response) = $this->ventesGetReservationsWithHttpInfo($filtre_reservations, $pager);
        return $response;
    }

    /**
     * Operation ventesGetReservationsWithHttpInfo
     *
     * Obtenir les réservations du système
     *
     * @param  WebConnectFiltreReservation $filtre_reservations Si précisé, ne renvoi que les réservations correspondantes au filtrage (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultWebConnectReservation, HTTP status code, HTTP response headers (array of strings)
     */
    public function ventesGetReservationsWithHttpInfo($filtre_reservations = null, $pager = null)
    {
        $request = $this->ventesGetReservationsRequest($filtre_reservations, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultWebConnectReservation' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultWebConnectReservation', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultWebConnectReservation';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultWebConnectReservation',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ventesGetReservationsAsync
     *
     * Obtenir les réservations du système
     *
     * @param  WebConnectFiltreReservation $filtre_reservations Si précisé, ne renvoi que les réservations correspondantes au filtrage (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesGetReservationsAsync($filtre_reservations = null, $pager = null)
    {
        return $this->ventesGetReservationsAsyncWithHttpInfo($filtre_reservations, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ventesGetReservationsAsyncWithHttpInfo
     *
     * Obtenir les réservations du système
     *
     * @param  WebConnectFiltreReservation $filtre_reservations Si précisé, ne renvoi que les réservations correspondantes au filtrage (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesGetReservationsAsyncWithHttpInfo($filtre_reservations = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultWebConnectReservation';
        $request = $this->ventesGetReservationsRequest($filtre_reservations, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'ventesGetReservations'
     *
     * @param  WebConnectFiltreReservation $filtre_reservations Si précisé, ne renvoi que les réservations correspondantes au filtrage (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function ventesGetReservationsRequest($filtre_reservations = null, $pager = null)
    {

        $resourcePath = '/Ventes/Reservations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_reservations)) {
            $filtre_reservations = ObjectSerializer::serializeCollection($filtre_reservations, '', true);
        }
        if ($filtre_reservations !== null) {
            $queryParams['filtreReservations'] = $filtre_reservations;
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation ventesGetVentes
     *
     * Liste les ventes Les données ne doivent pas être stockées sur le serveur web pour des raisons de RGPD
     *
     * @param  MetierClientWebConnectFiltreClientVente $filtre_client Si précisé, ne renvoi que les ventes correspondantes au filtrage (optional)
     * @param  \DateTime $depuis_derniere_modification Si précisé, ne renvoi que le relevé de ventes qui ont changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnextTicket
     */
    public function ventesGetVentes($filtre_client = null, $depuis_derniere_modification = null, $pager = null)
    {
        list($response) = $this->ventesGetVentesWithHttpInfo($filtre_client, $depuis_derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation ventesGetVentesWithHttpInfo
     *
     * Liste les ventes Les données ne doivent pas être stockées sur le serveur web pour des raisons de RGPD
     *
     * @param  MetierClientWebConnectFiltreClientVente $filtre_client Si précisé, ne renvoi que les ventes correspondantes au filtrage (optional)
     * @param  \DateTime $depuis_derniere_modification Si précisé, ne renvoi que le relevé de ventes qui ont changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnextTicket, HTTP status code, HTTP response headers (array of strings)
     */
    public function ventesGetVentesWithHttpInfo($filtre_client = null, $depuis_derniere_modification = null, $pager = null)
    {
        $request = $this->ventesGetVentesRequest($filtre_client, $depuis_derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnextTicket' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnextTicket', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnextTicket';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnextTicket',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ventesGetVentesAsync
     *
     * Liste les ventes Les données ne doivent pas être stockées sur le serveur web pour des raisons de RGPD
     *
     * @param  MetierClientWebConnectFiltreClientVente $filtre_client Si précisé, ne renvoi que les ventes correspondantes au filtrage (optional)
     * @param  \DateTime $depuis_derniere_modification Si précisé, ne renvoi que le relevé de ventes qui ont changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesGetVentesAsync($filtre_client = null, $depuis_derniere_modification = null, $pager = null)
    {
        return $this->ventesGetVentesAsyncWithHttpInfo($filtre_client, $depuis_derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ventesGetVentesAsyncWithHttpInfo
     *
     * Liste les ventes Les données ne doivent pas être stockées sur le serveur web pour des raisons de RGPD
     *
     * @param  MetierClientWebConnectFiltreClientVente $filtre_client Si précisé, ne renvoi que les ventes correspondantes au filtrage (optional)
     * @param  \DateTime $depuis_derniere_modification Si précisé, ne renvoi que le relevé de ventes qui ont changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesGetVentesAsyncWithHttpInfo($filtre_client = null, $depuis_derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnextTicket';
        $request = $this->ventesGetVentesRequest($filtre_client, $depuis_derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'ventesGetVentes'
     *
     * @param  MetierClientWebConnectFiltreClientVente $filtre_client Si précisé, ne renvoi que les ventes correspondantes au filtrage (optional)
     * @param  \DateTime $depuis_derniere_modification Si précisé, ne renvoi que le relevé de ventes qui ont changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function ventesGetVentesRequest($filtre_client = null, $depuis_derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Ventes/Ventes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_client)) {
            $filtre_client = ObjectSerializer::serializeCollection($filtre_client, '', true);
        }
        if ($filtre_client !== null) {
            $queryParams['filtreClient'] = $filtre_client;
        }
        // query params
        if ($depuis_derniere_modification !== null) {
            if('form' === 'form' && is_array($depuis_derniere_modification)) {
                foreach($depuis_derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['depuisDerniereModification'] = $depuis_derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation ventesPostReservation
     *
     * Crée une nouvelle réservation
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationCreation $web_connect_reservation_creation Description de la réservation à créer  (reservation) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation
     */
    public function ventesPostReservation($web_connect_reservation_creation)
    {
        list($response) = $this->ventesPostReservationWithHttpInfo($web_connect_reservation_creation);
        return $response;
    }

    /**
     * Operation ventesPostReservationWithHttpInfo
     *
     * Crée une nouvelle réservation
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationCreation $web_connect_reservation_creation Description de la réservation à créer  (reservation) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation, HTTP status code, HTTP response headers (array of strings)
     */
    public function ventesPostReservationWithHttpInfo($web_connect_reservation_creation)
    {
        $request = $this->ventesPostReservationRequest($web_connect_reservation_creation);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ventesPostReservationAsync
     *
     * Crée une nouvelle réservation
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationCreation $web_connect_reservation_creation Description de la réservation à créer  (reservation) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesPostReservationAsync($web_connect_reservation_creation)
    {
        return $this->ventesPostReservationAsyncWithHttpInfo($web_connect_reservation_creation)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ventesPostReservationAsyncWithHttpInfo
     *
     * Crée une nouvelle réservation
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationCreation $web_connect_reservation_creation Description de la réservation à créer  (reservation) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesPostReservationAsyncWithHttpInfo($web_connect_reservation_creation)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation';
        $request = $this->ventesPostReservationRequest($web_connect_reservation_creation);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'ventesPostReservation'
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationCreation $web_connect_reservation_creation Description de la réservation à créer  (reservation) (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function ventesPostReservationRequest($web_connect_reservation_creation)
    {
        // verify the required parameter 'web_connect_reservation_creation' is set
        if ($web_connect_reservation_creation === null || (is_array($web_connect_reservation_creation) && count($web_connect_reservation_creation) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $web_connect_reservation_creation when calling ventesPostReservation'
            );
        }

        $resourcePath = '/Ventes/Reservation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($web_connect_reservation_creation)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($web_connect_reservation_creation));
            } else {
                $httpBody = $web_connect_reservation_creation;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation ventesPostReservationPrepaiement
     *
     * Prépaye une réservation
     *
     * @param  string $code_reservation Code de la réservation à prépayer (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationPaiements $web_connect_reservation_paiements Paiements  (paiements) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation
     */
    public function ventesPostReservationPrepaiement($code_reservation, $web_connect_reservation_paiements)
    {
        list($response) = $this->ventesPostReservationPrepaiementWithHttpInfo($code_reservation, $web_connect_reservation_paiements);
        return $response;
    }

    /**
     * Operation ventesPostReservationPrepaiementWithHttpInfo
     *
     * Prépaye une réservation
     *
     * @param  string $code_reservation Code de la réservation à prépayer (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationPaiements $web_connect_reservation_paiements Paiements  (paiements) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation, HTTP status code, HTTP response headers (array of strings)
     */
    public function ventesPostReservationPrepaiementWithHttpInfo($code_reservation, $web_connect_reservation_paiements)
    {
        $request = $this->ventesPostReservationPrepaiementRequest($code_reservation, $web_connect_reservation_paiements);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ventesPostReservationPrepaiementAsync
     *
     * Prépaye une réservation
     *
     * @param  string $code_reservation Code de la réservation à prépayer (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationPaiements $web_connect_reservation_paiements Paiements  (paiements) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesPostReservationPrepaiementAsync($code_reservation, $web_connect_reservation_paiements)
    {
        return $this->ventesPostReservationPrepaiementAsyncWithHttpInfo($code_reservation, $web_connect_reservation_paiements)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ventesPostReservationPrepaiementAsyncWithHttpInfo
     *
     * Prépaye une réservation
     *
     * @param  string $code_reservation Code de la réservation à prépayer (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationPaiements $web_connect_reservation_paiements Paiements  (paiements) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesPostReservationPrepaiementAsyncWithHttpInfo($code_reservation, $web_connect_reservation_paiements)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservation';
        $request = $this->ventesPostReservationPrepaiementRequest($code_reservation, $web_connect_reservation_paiements);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'ventesPostReservationPrepaiement'
     *
     * @param  string $code_reservation Code de la réservation à prépayer (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\WebConnectReservationPaiements $web_connect_reservation_paiements Paiements  (paiements) (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function ventesPostReservationPrepaiementRequest($code_reservation, $web_connect_reservation_paiements)
    {
        // verify the required parameter 'code_reservation' is set
        if ($code_reservation === null || (is_array($code_reservation) && count($code_reservation) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $code_reservation when calling ventesPostReservationPrepaiement'
            );
        }
        // verify the required parameter 'web_connect_reservation_paiements' is set
        if ($web_connect_reservation_paiements === null || (is_array($web_connect_reservation_paiements) && count($web_connect_reservation_paiements) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $web_connect_reservation_paiements when calling ventesPostReservationPrepaiement'
            );
        }

        $resourcePath = '/Ventes/ReservationPrepaiement';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($code_reservation !== null) {
            if('form' === 'form' && is_array($code_reservation)) {
                foreach($code_reservation as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['codeReservation'] = $code_reservation;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($web_connect_reservation_paiements)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($web_connect_reservation_paiements));
            } else {
                $httpBody = $web_connect_reservation_paiements;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation ventesPostVente
     *
     * Crée une nouvelle vente sur le système
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteUpdateable $metier_debit_web_connect_vente_updateable Vente à créer  (vente) (required)
     * @param  bool $brouillon Demander à Polaris de calcul les prix, remise, la fidélité... (optional, default to false)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVente
     */
    public function ventesPostVente($metier_debit_web_connect_vente_updateable, $brouillon = false)
    {
        list($response) = $this->ventesPostVenteWithHttpInfo($metier_debit_web_connect_vente_updateable, $brouillon);
        return $response;
    }

    /**
     * Operation ventesPostVenteWithHttpInfo
     *
     * Crée une nouvelle vente sur le système
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteUpdateable $metier_debit_web_connect_vente_updateable Vente à créer  (vente) (required)
     * @param  bool $brouillon Demander à Polaris de calcul les prix, remise, la fidélité... (optional, default to false)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVente, HTTP status code, HTTP response headers (array of strings)
     */
    public function ventesPostVenteWithHttpInfo($metier_debit_web_connect_vente_updateable, $brouillon = false)
    {
        $request = $this->ventesPostVenteRequest($metier_debit_web_connect_vente_updateable, $brouillon);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVente' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVente', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVente';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVente',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ventesPostVenteAsync
     *
     * Crée une nouvelle vente sur le système
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteUpdateable $metier_debit_web_connect_vente_updateable Vente à créer  (vente) (required)
     * @param  bool $brouillon Demander à Polaris de calcul les prix, remise, la fidélité... (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesPostVenteAsync($metier_debit_web_connect_vente_updateable, $brouillon = false)
    {
        return $this->ventesPostVenteAsyncWithHttpInfo($metier_debit_web_connect_vente_updateable, $brouillon)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ventesPostVenteAsyncWithHttpInfo
     *
     * Crée une nouvelle vente sur le système
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteUpdateable $metier_debit_web_connect_vente_updateable Vente à créer  (vente) (required)
     * @param  bool $brouillon Demander à Polaris de calcul les prix, remise, la fidélité... (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function ventesPostVenteAsyncWithHttpInfo($metier_debit_web_connect_vente_updateable, $brouillon = false)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVente';
        $request = $this->ventesPostVenteRequest($metier_debit_web_connect_vente_updateable, $brouillon);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'ventesPostVente'
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierDebitWebConnectVenteUpdateable $metier_debit_web_connect_vente_updateable Vente à créer  (vente) (required)
     * @param  bool $brouillon Demander à Polaris de calcul les prix, remise, la fidélité... (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function ventesPostVenteRequest($metier_debit_web_connect_vente_updateable, $brouillon = false)
    {
        // verify the required parameter 'metier_debit_web_connect_vente_updateable' is set
        if ($metier_debit_web_connect_vente_updateable === null || (is_array($metier_debit_web_connect_vente_updateable) && count($metier_debit_web_connect_vente_updateable) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $metier_debit_web_connect_vente_updateable when calling ventesPostVente'
            );
        }

        $resourcePath = '/Ventes/Vente';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($brouillon !== null) {
            if('form' === 'form' && is_array($brouillon)) {
                foreach($brouillon as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['brouillon'] = $brouillon;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($metier_debit_web_connect_vente_updateable)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($metier_debit_web_connect_vente_updateable));
            } else {
                $httpBody = $metier_debit_web_connect_vente_updateable;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }


    /**
     * @param string $method
     * @param string|UriInterface $uri
     * @param array $headers
     * @param string|StreamInterface|null $body
     *
     * @return RequestInterface
     */
    protected function createRequest(string $method, $uri, array $headers = [], $body = null): RequestInterface
    {
        if ($this->requestFactory instanceof RequestFactory) {
            return $this->requestFactory->createRequest(
                $method,
                $uri,
                $headers,
                $body
            );
        }

        if (is_string($body) && '' !== $body && null === $this->streamFactory) {
            throw new \RuntimeException('Cannot create request: A stream factory is required to create a request with a non-empty string body.');
        }

        $request = $this->requestFactory->createRequest($method, $uri);

        foreach ($headers as $key => $value) {
            $request = $request->withHeader($key, $value);
        }

        if (null !== $body && '' !== $body) {
            $request = $request->withBody(
                is_string($body) ? $this->streamFactory->createStream($body) : $body
            );
        }

        return $request;
    }

    private function createUri(
        string $operationHost,
        string $resourcePath,
        array $queryParams
    ): UriInterface {
        $parsedUrl = parse_url($operationHost);

        $host = $parsedUrl['host'] ?? null;
        $scheme = $parsedUrl['scheme'] ?? null;
        $basePath = $parsedUrl['path'] ?? null;
        $port = $parsedUrl['port'] ?? null;
        $user = $parsedUrl['user'] ?? null;
        $password = $parsedUrl['pass'] ?? null;

        $uri = $this->uriFactory->createUri($basePath . $resourcePath)
            ->withHost($host)
            ->withScheme($scheme)
            ->withPort($port)
            ->withQuery(ObjectSerializer::buildQuery($queryParams));

        if ($user) {
            $uri = $uri->withUserInfo($user, $password);
        }

        return $uri;
    }
}
