<?php
/**
 * StocksApi
 * PHP version 7.2
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Api;

use GuzzleHttp\Psr7\MultipartStream;
use Http\Client\Common\Plugin\ErrorPlugin;
use Http\Client\Common\Plugin\RedirectPlugin;
use Http\Client\Common\PluginClient;
use Http\Client\Common\PluginClientFactory;
use Http\Client\Exception\HttpException;
use Http\Client\HttpAsyncClient;
use Http\Discovery\HttpAsyncClientDiscovery;
use Http\Discovery\Psr17FactoryDiscovery;
use Http\Discovery\Psr18ClientDiscovery;
use Http\Message\RequestFactory;
use Http\Promise\Promise;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Configuration;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\DebugPlugin;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\HeaderSelector;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestFactoryInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\StreamFactoryInterface;
use Psr\Http\Message\UriFactoryInterface;
use Psr\Http\Message\UriInterface;
use function sprintf;

/**
 * StocksApi Class Doc Comment
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class StocksApi
{
    /**
     * @var PluginClient
     */
    protected $httpClient;

    /**
     * @var PluginClient
     */
    protected $httpAsyncClient;

    /**
     * @var UriFactoryInterface
     */
    protected $uriFactory;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @var RequestFactoryInterface
     */
    protected $requestFactory;

    /**
     * @var StreamFactoryInterface
     */
    protected $streamFactory;

    public function __construct(
        ClientInterface $httpClient = null,
        Configuration $config = null,
        HttpAsyncClient $httpAsyncClient = null,
        UriFactoryInterface $uriFactory = null,
        RequestFactoryInterface $requestFactory = null,
        StreamFactoryInterface $streamFactory = null,
        HeaderSelector $selector = null,
        ?array $plugins = null,
        $hostIndex = 0
    ) {
        $this->config = $config ?? (new Configuration())->setHost('https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api/WebConnect');
        $this->requestFactory = $requestFactory ?? Psr17FactoryDiscovery::findRequestFactory();
        $this->streamFactory = $streamFactory ?? Psr17FactoryDiscovery::findStreamFactory();

        $plugins = $plugins ?? [
            new RedirectPlugin(['strict' => true]),
            new ErrorPlugin(),
        ];

        if ($this->config->getDebug()) {
            $plugins[] = new DebugPlugin(fopen($this->config->getDebugFile(), 'ab'));
        }

        $this->httpClient = (new PluginClientFactory())->createClient(
            $httpClient ?? Psr18ClientDiscovery::find(),
            $plugins
        );

        $this->httpAsyncClient = (new PluginClientFactory())->createClient(
            $httpAsyncClient ?? HttpAsyncClientDiscovery::find(),
            $plugins
        );

        $this->uriFactory = $uriFactory ?? Psr17FactoryDiscovery::findUriFactory();

        $this->headerSelector = $selector ?? new HeaderSelector();

        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation stocksGetCommandes
     *
     * Obtient les commandes en cours. ATTENTION : les données de L&#39;API ne font ressortir que les quantités en commandes supérieures à zéro. Donc quand un article n&#39;est plus en commande les données n&#39;existent pas dans le JSON de retour
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveCde
     */
    public function stocksGetCommandes($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        list($response) = $this->stocksGetCommandesWithHttpInfo($filtre_produit, $derniere_modification, $pager);
        return $response;
    }

    /**
     * Operation stocksGetCommandesWithHttpInfo
     *
     * Obtient les commandes en cours. ATTENTION : les données de L&#39;API ne font ressortir que les quantités en commandes supérieures à zéro. Donc quand un article n&#39;est plus en commande les données n&#39;existent pas dans le JSON de retour
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveCde, HTTP status code, HTTP response headers (array of strings)
     */
    public function stocksGetCommandesWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $request = $this->stocksGetCommandesRequest($filtre_produit, $derniere_modification, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveCde' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveCde', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveCde';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveCde',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation stocksGetCommandesAsync
     *
     * Obtient les commandes en cours. ATTENTION : les données de L&#39;API ne font ressortir que les quantités en commandes supérieures à zéro. Donc quand un article n&#39;est plus en commande les données n&#39;existent pas dans le JSON de retour
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetCommandesAsync($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        return $this->stocksGetCommandesAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation stocksGetCommandesAsyncWithHttpInfo
     *
     * Obtient les commandes en cours. ATTENTION : les données de L&#39;API ne font ressortir que les quantités en commandes supérieures à zéro. Donc quand un article n&#39;est plus en commande les données n&#39;existent pas dans le JSON de retour
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetCommandesAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveCde';
        $request = $this->stocksGetCommandesRequest($filtre_produit, $derniere_modification, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'stocksGetCommandes'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function stocksGetCommandesRequest($filtre_produit = null, $derniere_modification = null, $pager = null)
    {

        $resourcePath = '/Stocks/Commandes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation stocksGetDetailsPromotions
     *
     * Obtient les détails des plans de promotions.
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les détails ayant changés depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  string $code_promotion Si précisé, ne renvoi que les détails correspondant à la promotion spécifiée par son code (optional)
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les détails correspondant aux produits (déclinaisons) sélectionnés (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultDetailPromotion
     */
    public function stocksGetDetailsPromotions($derniere_modification = null, $only_active = true, $code_promotion = null, $filtre_produit = null, $pager = null)
    {
        list($response) = $this->stocksGetDetailsPromotionsWithHttpInfo($derniere_modification, $only_active, $code_promotion, $filtre_produit, $pager);
        return $response;
    }

    /**
     * Operation stocksGetDetailsPromotionsWithHttpInfo
     *
     * Obtient les détails des plans de promotions.
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les détails ayant changés depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  string $code_promotion Si précisé, ne renvoi que les détails correspondant à la promotion spécifiée par son code (optional)
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les détails correspondant aux produits (déclinaisons) sélectionnés (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultDetailPromotion, HTTP status code, HTTP response headers (array of strings)
     */
    public function stocksGetDetailsPromotionsWithHttpInfo($derniere_modification = null, $only_active = true, $code_promotion = null, $filtre_produit = null, $pager = null)
    {
        $request = $this->stocksGetDetailsPromotionsRequest($derniere_modification, $only_active, $code_promotion, $filtre_produit, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultDetailPromotion' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultDetailPromotion', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultDetailPromotion';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultDetailPromotion',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation stocksGetDetailsPromotionsAsync
     *
     * Obtient les détails des plans de promotions.
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les détails ayant changés depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  string $code_promotion Si précisé, ne renvoi que les détails correspondant à la promotion spécifiée par son code (optional)
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les détails correspondant aux produits (déclinaisons) sélectionnés (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetDetailsPromotionsAsync($derniere_modification = null, $only_active = true, $code_promotion = null, $filtre_produit = null, $pager = null)
    {
        return $this->stocksGetDetailsPromotionsAsyncWithHttpInfo($derniere_modification, $only_active, $code_promotion, $filtre_produit, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation stocksGetDetailsPromotionsAsyncWithHttpInfo
     *
     * Obtient les détails des plans de promotions.
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les détails ayant changés depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  string $code_promotion Si précisé, ne renvoi que les détails correspondant à la promotion spécifiée par son code (optional)
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les détails correspondant aux produits (déclinaisons) sélectionnés (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetDetailsPromotionsAsyncWithHttpInfo($derniere_modification = null, $only_active = true, $code_promotion = null, $filtre_produit = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultDetailPromotion';
        $request = $this->stocksGetDetailsPromotionsRequest($derniere_modification, $only_active, $code_promotion, $filtre_produit, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'stocksGetDetailsPromotions'
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les détails ayant changés depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  string $code_promotion Si précisé, ne renvoi que les détails correspondant à la promotion spécifiée par son code (optional)
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les détails correspondant aux produits (déclinaisons) sélectionnés (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function stocksGetDetailsPromotionsRequest($derniere_modification = null, $only_active = true, $code_promotion = null, $filtre_produit = null, $pager = null)
    {

        $resourcePath = '/Stocks/DetailsPromotions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if ($only_active !== null) {
            if('form' === 'form' && is_array($only_active)) {
                foreach($only_active as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['onlyActive'] = $only_active;
            }
        }
        // query params
        if ($code_promotion !== null) {
            if('form' === 'form' && is_array($code_promotion)) {
                foreach($code_promotion as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['codePromotion'] = $code_promotion;
            }
        }
        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation stocksGetPromotions
     *
     * Obtient les promotions en cours et à venir
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les promotions ayant changées depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultPromotion
     */
    public function stocksGetPromotions($derniere_modification = null, $only_active = true, $pager = null)
    {
        list($response) = $this->stocksGetPromotionsWithHttpInfo($derniere_modification, $only_active, $pager);
        return $response;
    }

    /**
     * Operation stocksGetPromotionsWithHttpInfo
     *
     * Obtient les promotions en cours et à venir
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les promotions ayant changées depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultPromotion, HTTP status code, HTTP response headers (array of strings)
     */
    public function stocksGetPromotionsWithHttpInfo($derniere_modification = null, $only_active = true, $pager = null)
    {
        $request = $this->stocksGetPromotionsRequest($derniere_modification, $only_active, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultPromotion' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultPromotion', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultPromotion';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultPromotion',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation stocksGetPromotionsAsync
     *
     * Obtient les promotions en cours et à venir
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les promotions ayant changées depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetPromotionsAsync($derniere_modification = null, $only_active = true, $pager = null)
    {
        return $this->stocksGetPromotionsAsyncWithHttpInfo($derniere_modification, $only_active, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation stocksGetPromotionsAsyncWithHttpInfo
     *
     * Obtient les promotions en cours et à venir
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les promotions ayant changées depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetPromotionsAsyncWithHttpInfo($derniere_modification = null, $only_active = true, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultPromotion';
        $request = $this->stocksGetPromotionsRequest($derniere_modification, $only_active, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'stocksGetPromotions'
     *
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que les promotions ayant changées depuis cette date (optional)
     * @param  bool $only_active Si vrai, ne renvoi que les promotions en cours et futures (optional, default to true)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function stocksGetPromotionsRequest($derniere_modification = null, $only_active = true, $pager = null)
    {

        $resourcePath = '/Stocks/Promotions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if ($only_active !== null) {
            if('form' === 'form' && is_array($only_active)) {
                foreach($only_active as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['onlyActive'] = $only_active;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation stocksGetStocks
     *
     * Obtient les changements de stocks et de prix.
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveStock
     */
    public function stocksGetStocks($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null)
    {
        list($response) = $this->stocksGetStocksWithHttpInfo($filtre_produit, $derniere_modification, $pager, $date_solde, $is_solde, $is_promo, $is_internet, $is_magasin, $code_promo);
        return $response;
    }

    /**
     * Operation stocksGetStocksWithHttpInfo
     *
     * Obtient les changements de stocks et de prix.
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveStock, HTTP status code, HTTP response headers (array of strings)
     */
    public function stocksGetStocksWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null)
    {
        $request = $this->stocksGetStocksRequest($filtre_produit, $derniere_modification, $pager, $date_solde, $is_solde, $is_promo, $is_internet, $is_magasin, $code_promo);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveStock' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveStock', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveStock';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveStock',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation stocksGetStocksAsync
     *
     * Obtient les changements de stocks et de prix.
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetStocksAsync($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null)
    {
        return $this->stocksGetStocksAsyncWithHttpInfo($filtre_produit, $derniere_modification, $pager, $date_solde, $is_solde, $is_promo, $is_internet, $is_magasin, $code_promo)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation stocksGetStocksAsyncWithHttpInfo
     *
     * Obtient les changements de stocks et de prix.
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetStocksAsyncWithHttpInfo($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultReleveStock';
        $request = $this->stocksGetStocksRequest($filtre_produit, $derniere_modification, $pager, $date_solde, $is_solde, $is_promo, $is_internet, $is_magasin, $code_promo);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'stocksGetStocks'
     *
     * @param  FiltreProduit $filtre_produit Si précisé, ne renvoi que les articles des produits correspondants au filtrage (optional)
     * @param  \DateTime $derniere_modification Si précisé, ne renvoi que le relevé de stock des articles dont le stock ou le prix ou une promotion attachée à ce produit a changé depuis la date précisée (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     * @param  \DateTime $date_solde Date de prise en compte des plans de promotion ou de solde, par défaut la date de jour est utilisé (optional)
     * @param  bool $is_solde Le plan est en plan de solde (optional, default to true)
     * @param  bool $is_promo Le plan est en plan de promotions (optional, default to true)
     * @param  bool $is_internet Le plan est valable sur internet (optional, default to true)
     * @param  bool $is_magasin Le plan est valable en boutique (optional, default to true)
     * @param  string $code_promo Code du plan (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function stocksGetStocksRequest($filtre_produit = null, $derniere_modification = null, $pager = null, $date_solde = null, $is_solde = true, $is_promo = true, $is_internet = true, $is_magasin = true, $code_promo = null)
    {

        $resourcePath = '/Stocks/Stocks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_produit)) {
            $filtre_produit = ObjectSerializer::serializeCollection($filtre_produit, '', true);
        }
        if ($filtre_produit !== null) {
            $queryParams['filtreProduit'] = $filtre_produit;
        }
        // query params
        if ($derniere_modification !== null) {
            if('form' === 'form' && is_array($derniere_modification)) {
                foreach($derniere_modification as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModification'] = $derniere_modification;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }
        // query params
        if ($date_solde !== null) {
            if('form' === 'form' && is_array($date_solde)) {
                foreach($date_solde as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['dateSolde'] = $date_solde;
            }
        }
        // query params
        if ($is_solde !== null) {
            if('form' === 'form' && is_array($is_solde)) {
                foreach($is_solde as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['isSolde'] = $is_solde;
            }
        }
        // query params
        if ($is_promo !== null) {
            if('form' === 'form' && is_array($is_promo)) {
                foreach($is_promo as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['isPromo'] = $is_promo;
            }
        }
        // query params
        if ($is_internet !== null) {
            if('form' === 'form' && is_array($is_internet)) {
                foreach($is_internet as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['isInternet'] = $is_internet;
            }
        }
        // query params
        if ($is_magasin !== null) {
            if('form' === 'form' && is_array($is_magasin)) {
                foreach($is_magasin as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['isMagasin'] = $is_magasin;
            }
        }
        // query params
        if ($code_promo !== null) {
            if('form' === 'form' && is_array($code_promo)) {
                foreach($code_promo as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['codePromo'] = $code_promo;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation stocksGetTransfert
     *
     * Contrôler un mouvement de stock
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert
     */
    public function stocksGetTransfert($ref_transfert)
    {
        list($response) = $this->stocksGetTransfertWithHttpInfo($ref_transfert);
        return $response;
    }

    /**
     * Operation stocksGetTransfertWithHttpInfo
     *
     * Contrôler un mouvement de stock
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert, HTTP status code, HTTP response headers (array of strings)
     */
    public function stocksGetTransfertWithHttpInfo($ref_transfert)
    {
        $request = $this->stocksGetTransfertRequest($ref_transfert);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation stocksGetTransfertAsync
     *
     * Contrôler un mouvement de stock
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetTransfertAsync($ref_transfert)
    {
        return $this->stocksGetTransfertAsyncWithHttpInfo($ref_transfert)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation stocksGetTransfertAsyncWithHttpInfo
     *
     * Contrôler un mouvement de stock
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetTransfertAsyncWithHttpInfo($ref_transfert)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert';
        $request = $this->stocksGetTransfertRequest($ref_transfert);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'stocksGetTransfert'
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function stocksGetTransfertRequest($ref_transfert)
    {
        // verify the required parameter 'ref_transfert' is set
        if ($ref_transfert === null || (is_array($ref_transfert) && count($ref_transfert) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $ref_transfert when calling stocksGetTransfert'
            );
        }

        $resourcePath = '/Stocks/Transfert';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($ref_transfert !== null) {
            if('form' === 'form' && is_array($ref_transfert)) {
                foreach($ref_transfert as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['refTransfert'] = $ref_transfert;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation stocksGetVenteEnGros
     *
     * Contrôler une vente en gros
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros
     */
    public function stocksGetVenteEnGros($ref_transfert)
    {
        list($response) = $this->stocksGetVenteEnGrosWithHttpInfo($ref_transfert);
        return $response;
    }

    /**
     * Operation stocksGetVenteEnGrosWithHttpInfo
     *
     * Contrôler une vente en gros
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros, HTTP status code, HTTP response headers (array of strings)
     */
    public function stocksGetVenteEnGrosWithHttpInfo($ref_transfert)
    {
        $request = $this->stocksGetVenteEnGrosRequest($ref_transfert);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation stocksGetVenteEnGrosAsync
     *
     * Contrôler une vente en gros
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetVenteEnGrosAsync($ref_transfert)
    {
        return $this->stocksGetVenteEnGrosAsyncWithHttpInfo($ref_transfert)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation stocksGetVenteEnGrosAsyncWithHttpInfo
     *
     * Contrôler une vente en gros
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksGetVenteEnGrosAsyncWithHttpInfo($ref_transfert)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros';
        $request = $this->stocksGetVenteEnGrosRequest($ref_transfert);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'stocksGetVenteEnGros'
     *
     * @param  string $ref_transfert Référence unique du transfert (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function stocksGetVenteEnGrosRequest($ref_transfert)
    {
        // verify the required parameter 'ref_transfert' is set
        if ($ref_transfert === null || (is_array($ref_transfert) && count($ref_transfert) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $ref_transfert when calling stocksGetVenteEnGros'
            );
        }

        $resourcePath = '/Stocks/VenteEnGros';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($ref_transfert !== null) {
            if('form' === 'form' && is_array($ref_transfert)) {
                foreach($ref_transfert as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['refTransfert'] = $ref_transfert;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation stocksPostConfirmationTransfert
     *
     * Indique la confirmation d&#39;un transfert ou d&#39;une commande interne
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreation $metier_mvt_web_connect_confirmation_transfert_creation Description de la confirmation de transfert de marchandise  (transfert) (required)
     * @param  bool $terminer_transfert Précise que la commande est finie et que toutes les quantités non confirmées doivent être annulées ou refusées (optional, default to true)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreationReponse
     */
    public function stocksPostConfirmationTransfert($metier_mvt_web_connect_confirmation_transfert_creation, $terminer_transfert = true)
    {
        list($response) = $this->stocksPostConfirmationTransfertWithHttpInfo($metier_mvt_web_connect_confirmation_transfert_creation, $terminer_transfert);
        return $response;
    }

    /**
     * Operation stocksPostConfirmationTransfertWithHttpInfo
     *
     * Indique la confirmation d&#39;un transfert ou d&#39;une commande interne
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreation $metier_mvt_web_connect_confirmation_transfert_creation Description de la confirmation de transfert de marchandise  (transfert) (required)
     * @param  bool $terminer_transfert Précise que la commande est finie et que toutes les quantités non confirmées doivent être annulées ou refusées (optional, default to true)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreationReponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function stocksPostConfirmationTransfertWithHttpInfo($metier_mvt_web_connect_confirmation_transfert_creation, $terminer_transfert = true)
    {
        $request = $this->stocksPostConfirmationTransfertRequest($metier_mvt_web_connect_confirmation_transfert_creation, $terminer_transfert);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreationReponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreationReponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreationReponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreationReponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation stocksPostConfirmationTransfertAsync
     *
     * Indique la confirmation d&#39;un transfert ou d&#39;une commande interne
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreation $metier_mvt_web_connect_confirmation_transfert_creation Description de la confirmation de transfert de marchandise  (transfert) (required)
     * @param  bool $terminer_transfert Précise que la commande est finie et que toutes les quantités non confirmées doivent être annulées ou refusées (optional, default to true)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksPostConfirmationTransfertAsync($metier_mvt_web_connect_confirmation_transfert_creation, $terminer_transfert = true)
    {
        return $this->stocksPostConfirmationTransfertAsyncWithHttpInfo($metier_mvt_web_connect_confirmation_transfert_creation, $terminer_transfert)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation stocksPostConfirmationTransfertAsyncWithHttpInfo
     *
     * Indique la confirmation d&#39;un transfert ou d&#39;une commande interne
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreation $metier_mvt_web_connect_confirmation_transfert_creation Description de la confirmation de transfert de marchandise  (transfert) (required)
     * @param  bool $terminer_transfert Précise que la commande est finie et que toutes les quantités non confirmées doivent être annulées ou refusées (optional, default to true)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksPostConfirmationTransfertAsyncWithHttpInfo($metier_mvt_web_connect_confirmation_transfert_creation, $terminer_transfert = true)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreationReponse';
        $request = $this->stocksPostConfirmationTransfertRequest($metier_mvt_web_connect_confirmation_transfert_creation, $terminer_transfert);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'stocksPostConfirmationTransfert'
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectConfirmationTransfertCreation $metier_mvt_web_connect_confirmation_transfert_creation Description de la confirmation de transfert de marchandise  (transfert) (required)
     * @param  bool $terminer_transfert Précise que la commande est finie et que toutes les quantités non confirmées doivent être annulées ou refusées (optional, default to true)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function stocksPostConfirmationTransfertRequest($metier_mvt_web_connect_confirmation_transfert_creation, $terminer_transfert = true)
    {
        // verify the required parameter 'metier_mvt_web_connect_confirmation_transfert_creation' is set
        if ($metier_mvt_web_connect_confirmation_transfert_creation === null || (is_array($metier_mvt_web_connect_confirmation_transfert_creation) && count($metier_mvt_web_connect_confirmation_transfert_creation) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $metier_mvt_web_connect_confirmation_transfert_creation when calling stocksPostConfirmationTransfert'
            );
        }

        $resourcePath = '/Stocks/ConfirmationTransfert';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($terminer_transfert !== null) {
            if('form' === 'form' && is_array($terminer_transfert)) {
                foreach($terminer_transfert as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['terminerTransfert'] = $terminer_transfert;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($metier_mvt_web_connect_confirmation_transfert_creation)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($metier_mvt_web_connect_confirmation_transfert_creation));
            } else {
                $httpBody = $metier_mvt_web_connect_confirmation_transfert_creation;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation stocksPostTransfert
     *
     * Créer un mouvement de stock en deux magasins
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfertCreation $metier_mvt_web_connect_transfert_creation Description du transfert de marchandise  (transfert) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert
     */
    public function stocksPostTransfert($metier_mvt_web_connect_transfert_creation)
    {
        list($response) = $this->stocksPostTransfertWithHttpInfo($metier_mvt_web_connect_transfert_creation);
        return $response;
    }

    /**
     * Operation stocksPostTransfertWithHttpInfo
     *
     * Créer un mouvement de stock en deux magasins
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfertCreation $metier_mvt_web_connect_transfert_creation Description du transfert de marchandise  (transfert) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert, HTTP status code, HTTP response headers (array of strings)
     */
    public function stocksPostTransfertWithHttpInfo($metier_mvt_web_connect_transfert_creation)
    {
        $request = $this->stocksPostTransfertRequest($metier_mvt_web_connect_transfert_creation);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation stocksPostTransfertAsync
     *
     * Créer un mouvement de stock en deux magasins
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfertCreation $metier_mvt_web_connect_transfert_creation Description du transfert de marchandise  (transfert) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksPostTransfertAsync($metier_mvt_web_connect_transfert_creation)
    {
        return $this->stocksPostTransfertAsyncWithHttpInfo($metier_mvt_web_connect_transfert_creation)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation stocksPostTransfertAsyncWithHttpInfo
     *
     * Créer un mouvement de stock en deux magasins
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfertCreation $metier_mvt_web_connect_transfert_creation Description du transfert de marchandise  (transfert) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksPostTransfertAsyncWithHttpInfo($metier_mvt_web_connect_transfert_creation)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfert';
        $request = $this->stocksPostTransfertRequest($metier_mvt_web_connect_transfert_creation);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'stocksPostTransfert'
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectTransfertCreation $metier_mvt_web_connect_transfert_creation Description du transfert de marchandise  (transfert) (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function stocksPostTransfertRequest($metier_mvt_web_connect_transfert_creation)
    {
        // verify the required parameter 'metier_mvt_web_connect_transfert_creation' is set
        if ($metier_mvt_web_connect_transfert_creation === null || (is_array($metier_mvt_web_connect_transfert_creation) && count($metier_mvt_web_connect_transfert_creation) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $metier_mvt_web_connect_transfert_creation when calling stocksPostTransfert'
            );
        }

        $resourcePath = '/Stocks/Transfert';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($metier_mvt_web_connect_transfert_creation)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($metier_mvt_web_connect_transfert_creation));
            } else {
                $httpBody = $metier_mvt_web_connect_transfert_creation;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation stocksPostVenteEnGros
     *
     * Créer d&#39;une vente en gros
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGrosCreation $metier_mvt_web_connect_vente_en_gros_creation Description du transfert de marchandise  (venteEnGros) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros
     */
    public function stocksPostVenteEnGros($metier_mvt_web_connect_vente_en_gros_creation)
    {
        list($response) = $this->stocksPostVenteEnGrosWithHttpInfo($metier_mvt_web_connect_vente_en_gros_creation);
        return $response;
    }

    /**
     * Operation stocksPostVenteEnGrosWithHttpInfo
     *
     * Créer d&#39;une vente en gros
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGrosCreation $metier_mvt_web_connect_vente_en_gros_creation Description du transfert de marchandise  (venteEnGros) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros, HTTP status code, HTTP response headers (array of strings)
     */
    public function stocksPostVenteEnGrosWithHttpInfo($metier_mvt_web_connect_vente_en_gros_creation)
    {
        $request = $this->stocksPostVenteEnGrosRequest($metier_mvt_web_connect_vente_en_gros_creation);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation stocksPostVenteEnGrosAsync
     *
     * Créer d&#39;une vente en gros
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGrosCreation $metier_mvt_web_connect_vente_en_gros_creation Description du transfert de marchandise  (venteEnGros) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksPostVenteEnGrosAsync($metier_mvt_web_connect_vente_en_gros_creation)
    {
        return $this->stocksPostVenteEnGrosAsyncWithHttpInfo($metier_mvt_web_connect_vente_en_gros_creation)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation stocksPostVenteEnGrosAsyncWithHttpInfo
     *
     * Créer d&#39;une vente en gros
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGrosCreation $metier_mvt_web_connect_vente_en_gros_creation Description du transfert de marchandise  (venteEnGros) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function stocksPostVenteEnGrosAsyncWithHttpInfo($metier_mvt_web_connect_vente_en_gros_creation)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGros';
        $request = $this->stocksPostVenteEnGrosRequest($metier_mvt_web_connect_vente_en_gros_creation);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'stocksPostVenteEnGros'
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierMvtWebConnectVenteEnGrosCreation $metier_mvt_web_connect_vente_en_gros_creation Description du transfert de marchandise  (venteEnGros) (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function stocksPostVenteEnGrosRequest($metier_mvt_web_connect_vente_en_gros_creation)
    {
        // verify the required parameter 'metier_mvt_web_connect_vente_en_gros_creation' is set
        if ($metier_mvt_web_connect_vente_en_gros_creation === null || (is_array($metier_mvt_web_connect_vente_en_gros_creation) && count($metier_mvt_web_connect_vente_en_gros_creation) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $metier_mvt_web_connect_vente_en_gros_creation when calling stocksPostVenteEnGros'
            );
        }

        $resourcePath = '/Stocks/VenteEnGros';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($metier_mvt_web_connect_vente_en_gros_creation)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($metier_mvt_web_connect_vente_en_gros_creation));
            } else {
                $httpBody = $metier_mvt_web_connect_vente_en_gros_creation;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }


    /**
     * @param string $method
     * @param string|UriInterface $uri
     * @param array $headers
     * @param string|StreamInterface|null $body
     *
     * @return RequestInterface
     */
    protected function createRequest(string $method, $uri, array $headers = [], $body = null): RequestInterface
    {
        if ($this->requestFactory instanceof RequestFactory) {
            return $this->requestFactory->createRequest(
                $method,
                $uri,
                $headers,
                $body
            );
        }

        if (is_string($body) && '' !== $body && null === $this->streamFactory) {
            throw new \RuntimeException('Cannot create request: A stream factory is required to create a request with a non-empty string body.');
        }

        $request = $this->requestFactory->createRequest($method, $uri);

        foreach ($headers as $key => $value) {
            $request = $request->withHeader($key, $value);
        }

        if (null !== $body && '' !== $body) {
            $request = $request->withBody(
                is_string($body) ? $this->streamFactory->createStream($body) : $body
            );
        }

        return $request;
    }

    private function createUri(
        string $operationHost,
        string $resourcePath,
        array $queryParams
    ): UriInterface {
        $parsedUrl = parse_url($operationHost);

        $host = $parsedUrl['host'] ?? null;
        $scheme = $parsedUrl['scheme'] ?? null;
        $basePath = $parsedUrl['path'] ?? null;
        $port = $parsedUrl['port'] ?? null;
        $user = $parsedUrl['user'] ?? null;
        $password = $parsedUrl['pass'] ?? null;

        $uri = $this->uriFactory->createUri($basePath . $resourcePath)
            ->withHost($host)
            ->withScheme($scheme)
            ->withPort($port)
            ->withQuery(ObjectSerializer::buildQuery($queryParams));

        if ($user) {
            $uri = $uri->withUserInfo($user, $password);
        }

        return $uri;
    }
}
