<?php
/**
 * ClientsApi
 * PHP version 7.2
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Polaris WebConnect
 *
 * L'API WebConnect vous permet d'interconnecter facilement votre solution Polaris avec un site Internet en permettant à ce dernier de télécharger votre catalogue, vos clients, votre fidélité       *Pour rappel, la spécification OpenAPI est une spécification de fichiers d'interface lisibles par une machine pour décrire, produire, consommer et visualiser les services Web REST de manière automatisée. Vous pouvez donc utiliser des outils comme [Swagger](https://editor.swagger.io/) pour générer automatiquement une bibliothèque cliente dans le langage de votre choix.*    **IMPORTANT / NOTE SUR LES ÉNUMÉRATEURS** : si vous générez un client avec OpenAPI Generator ou Swagger, appelez les API avec un User-Agent qui contient la chaîne 'enum_as_str;' afin que les énumérateurs soient gérés sous forme de chaîne de caractères et non de constantes entières.   **Voir la documentation générale : [https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc=WebConnect)**
 *
 * The version of the OpenAPI document: 14.1.99.65534
 * Contact: assistance@vega-info.fr
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.8.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Api;

use GuzzleHttp\Psr7\MultipartStream;
use Http\Client\Common\Plugin\ErrorPlugin;
use Http\Client\Common\Plugin\RedirectPlugin;
use Http\Client\Common\PluginClient;
use Http\Client\Common\PluginClientFactory;
use Http\Client\Exception\HttpException;
use Http\Client\HttpAsyncClient;
use Http\Discovery\HttpAsyncClientDiscovery;
use Http\Discovery\Psr17FactoryDiscovery;
use Http\Discovery\Psr18ClientDiscovery;
use Http\Message\RequestFactory;
use Http\Promise\Promise;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Configuration;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\DebugPlugin;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\HeaderSelector;
use PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ObjectSerializer;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestFactoryInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\StreamFactoryInterface;
use Psr\Http\Message\UriFactoryInterface;
use Psr\Http\Message\UriInterface;
use function sprintf;

/**
 * ClientsApi Class Doc Comment
 *
 * @category Class
 * @package  PrestaShop\Module\PolarisPrestaConnector\pol\api\lib
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ClientsApi
{
    /**
     * @var PluginClient
     */
    protected $httpClient;

    /**
     * @var PluginClient
     */
    protected $httpAsyncClient;

    /**
     * @var UriFactoryInterface
     */
    protected $uriFactory;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @var RequestFactoryInterface
     */
    protected $requestFactory;

    /**
     * @var StreamFactoryInterface
     */
    protected $streamFactory;

    public function __construct(
        ClientInterface $httpClient = null,
        Configuration $config = null,
        HttpAsyncClient $httpAsyncClient = null,
        UriFactoryInterface $uriFactory = null,
        RequestFactoryInterface $requestFactory = null,
        StreamFactoryInterface $streamFactory = null,
        HeaderSelector $selector = null,
        ?array $plugins = null,
        $hostIndex = 0
    ) {
        $this->config = $config ?? (new Configuration())->setHost('https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api/WebConnect');
        $this->requestFactory = $requestFactory ?? Psr17FactoryDiscovery::findRequestFactory();
        $this->streamFactory = $streamFactory ?? Psr17FactoryDiscovery::findStreamFactory();

        $plugins = $plugins ?? [
            new RedirectPlugin(['strict' => true]),
            new ErrorPlugin(),
        ];

        if ($this->config->getDebug()) {
            $plugins[] = new DebugPlugin(fopen($this->config->getDebugFile(), 'ab'));
        }

        $this->httpClient = (new PluginClientFactory())->createClient(
            $httpClient ?? Psr18ClientDiscovery::find(),
            $plugins
        );

        $this->httpAsyncClient = (new PluginClientFactory())->createClient(
            $httpAsyncClient ?? HttpAsyncClientDiscovery::find(),
            $plugins
        );

        $this->uriFactory = $uriFactory ?? Psr17FactoryDiscovery::findUriFactory();

        $this->headerSelector = $selector ?? new HeaderSelector();

        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation clientsDeleteClient
     *
     * Marque un compte client pour sa suppression.
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du compte client à marque pour suppression (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient
     */
    public function clientsDeleteClient($id)
    {
        list($response) = $this->clientsDeleteClientWithHttpInfo($id);
        return $response;
    }

    /**
     * Operation clientsDeleteClientWithHttpInfo
     *
     * Marque un compte client pour sa suppression.
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du compte client à marque pour suppression (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsDeleteClientWithHttpInfo($id)
    {
        $request = $this->clientsDeleteClientRequest($id);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsDeleteClientAsync
     *
     * Marque un compte client pour sa suppression.
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du compte client à marque pour suppression (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsDeleteClientAsync($id)
    {
        return $this->clientsDeleteClientAsyncWithHttpInfo($id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsDeleteClientAsyncWithHttpInfo
     *
     * Marque un compte client pour sa suppression.
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du compte client à marque pour suppression (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsDeleteClientAsyncWithHttpInfo($id)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient';
        $request = $this->clientsDeleteClientRequest($id);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsDeleteClient'
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du compte client à marque pour suppression (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsDeleteClientRequest($id)
    {
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling clientsDeleteClient'
            );
        }

        $resourcePath = '/Clients/Client';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($id)) {
            $id = ObjectSerializer::serializeCollection($id, '', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $id;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('DELETE', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsGetBon
     *
     * Obtient un bon en fonction de son code
     *
     * @param  string $code_bon Code du bon à obtenir (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient
     */
    public function clientsGetBon($code_bon)
    {
        list($response) = $this->clientsGetBonWithHttpInfo($code_bon);
        return $response;
    }

    /**
     * Operation clientsGetBonWithHttpInfo
     *
     * Obtient un bon en fonction de son code
     *
     * @param  string $code_bon Code du bon à obtenir (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsGetBonWithHttpInfo($code_bon)
    {
        $request = $this->clientsGetBonRequest($code_bon);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsGetBonAsync
     *
     * Obtient un bon en fonction de son code
     *
     * @param  string $code_bon Code du bon à obtenir (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetBonAsync($code_bon)
    {
        return $this->clientsGetBonAsyncWithHttpInfo($code_bon)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsGetBonAsyncWithHttpInfo
     *
     * Obtient un bon en fonction de son code
     *
     * @param  string $code_bon Code du bon à obtenir (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetBonAsyncWithHttpInfo($code_bon)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient';
        $request = $this->clientsGetBonRequest($code_bon);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsGetBon'
     *
     * @param  string $code_bon Code du bon à obtenir (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsGetBonRequest($code_bon)
    {
        // verify the required parameter 'code_bon' is set
        if ($code_bon === null || (is_array($code_bon) && count($code_bon) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $code_bon when calling clientsGetBon'
            );
        }

        $resourcePath = '/Clients/Bon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($code_bon !== null) {
            if('form' === 'form' && is_array($code_bon)) {
                foreach($code_bon as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['codeBon'] = $code_bon;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsGetBons
     *
     * Obtient une liste de bons
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des bons à rétribuer (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierBonWebConnectBonClient
     */
    public function clientsGetBons($derniere_modif_date = null, $pager = null)
    {
        list($response) = $this->clientsGetBonsWithHttpInfo($derniere_modif_date, $pager);
        return $response;
    }

    /**
     * Operation clientsGetBonsWithHttpInfo
     *
     * Obtient une liste de bons
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des bons à rétribuer (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierBonWebConnectBonClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsGetBonsWithHttpInfo($derniere_modif_date = null, $pager = null)
    {
        $request = $this->clientsGetBonsRequest($derniere_modif_date, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierBonWebConnectBonClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierBonWebConnectBonClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierBonWebConnectBonClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierBonWebConnectBonClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsGetBonsAsync
     *
     * Obtient une liste de bons
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des bons à rétribuer (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetBonsAsync($derniere_modif_date = null, $pager = null)
    {
        return $this->clientsGetBonsAsyncWithHttpInfo($derniere_modif_date, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsGetBonsAsyncWithHttpInfo
     *
     * Obtient une liste de bons
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des bons à rétribuer (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetBonsAsyncWithHttpInfo($derniere_modif_date = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierBonWebConnectBonClient';
        $request = $this->clientsGetBonsRequest($derniere_modif_date, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsGetBons'
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des bons à rétribuer (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsGetBonsRequest($derniere_modif_date = null, $pager = null)
    {

        $resourcePath = '/Clients/Bons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($derniere_modif_date !== null) {
            if('form' === 'form' && is_array($derniere_modif_date)) {
                foreach($derniere_modif_date as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModifDate'] = $derniere_modif_date;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsGetCartePrePaye
     *
     * Obtient une carte prépayée en fonction de son code
     *
     * @param  string $code_carte Code de la carte prépayée à obtenir (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCPCarteWebConnectCartePrePayeeClient
     */
    public function clientsGetCartePrePaye($code_carte)
    {
        list($response) = $this->clientsGetCartePrePayeWithHttpInfo($code_carte);
        return $response;
    }

    /**
     * Operation clientsGetCartePrePayeWithHttpInfo
     *
     * Obtient une carte prépayée en fonction de son code
     *
     * @param  string $code_carte Code de la carte prépayée à obtenir (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCPCarteWebConnectCartePrePayeeClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsGetCartePrePayeWithHttpInfo($code_carte)
    {
        $request = $this->clientsGetCartePrePayeRequest($code_carte);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCPCarteWebConnectCartePrePayeeClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCPCarteWebConnectCartePrePayeeClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCPCarteWebConnectCartePrePayeeClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCPCarteWebConnectCartePrePayeeClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsGetCartePrePayeAsync
     *
     * Obtient une carte prépayée en fonction de son code
     *
     * @param  string $code_carte Code de la carte prépayée à obtenir (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetCartePrePayeAsync($code_carte)
    {
        return $this->clientsGetCartePrePayeAsyncWithHttpInfo($code_carte)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsGetCartePrePayeAsyncWithHttpInfo
     *
     * Obtient une carte prépayée en fonction de son code
     *
     * @param  string $code_carte Code de la carte prépayée à obtenir (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetCartePrePayeAsyncWithHttpInfo($code_carte)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCPCarteWebConnectCartePrePayeeClient';
        $request = $this->clientsGetCartePrePayeRequest($code_carte);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsGetCartePrePaye'
     *
     * @param  string $code_carte Code de la carte prépayée à obtenir (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsGetCartePrePayeRequest($code_carte)
    {
        // verify the required parameter 'code_carte' is set
        if ($code_carte === null || (is_array($code_carte) && count($code_carte) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $code_carte when calling clientsGetCartePrePaye'
            );
        }

        $resourcePath = '/Clients/CartePrePaye';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($code_carte !== null) {
            if('form' === 'form' && is_array($code_carte)) {
                foreach($code_carte as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['codeCarte'] = $code_carte;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsGetCartePrePayes
     *
     * Obtient une liste des cartes prépayées
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des cartes prépayées (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCPCarteWebConnectCartePrePayeeClient
     */
    public function clientsGetCartePrePayes($derniere_modif_date = null, $pager = null)
    {
        list($response) = $this->clientsGetCartePrePayesWithHttpInfo($derniere_modif_date, $pager);
        return $response;
    }

    /**
     * Operation clientsGetCartePrePayesWithHttpInfo
     *
     * Obtient une liste des cartes prépayées
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des cartes prépayées (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCPCarteWebConnectCartePrePayeeClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsGetCartePrePayesWithHttpInfo($derniere_modif_date = null, $pager = null)
    {
        $request = $this->clientsGetCartePrePayesRequest($derniere_modif_date, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCPCarteWebConnectCartePrePayeeClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCPCarteWebConnectCartePrePayeeClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCPCarteWebConnectCartePrePayeeClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCPCarteWebConnectCartePrePayeeClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsGetCartePrePayesAsync
     *
     * Obtient une liste des cartes prépayées
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des cartes prépayées (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetCartePrePayesAsync($derniere_modif_date = null, $pager = null)
    {
        return $this->clientsGetCartePrePayesAsyncWithHttpInfo($derniere_modif_date, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsGetCartePrePayesAsyncWithHttpInfo
     *
     * Obtient une liste des cartes prépayées
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des cartes prépayées (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetCartePrePayesAsyncWithHttpInfo($derniere_modif_date = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierCPCarteWebConnectCartePrePayeeClient';
        $request = $this->clientsGetCartePrePayesRequest($derniere_modif_date, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsGetCartePrePayes'
     *
     * @param  \DateTime $derniere_modif_date Date de la dernière modification des cartes prépayées (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsGetCartePrePayesRequest($derniere_modif_date = null, $pager = null)
    {

        $resourcePath = '/Clients/CartePrePayes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($derniere_modif_date !== null) {
            if('form' === 'form' && is_array($derniere_modif_date)) {
                foreach($derniere_modif_date as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['derniereModifDate'] = $derniere_modif_date;
            }
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsGetClient
     *
     * Obtient un client précis
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient
     */
    public function clientsGetClient($id)
    {
        list($response) = $this->clientsGetClientWithHttpInfo($id);
        return $response;
    }

    /**
     * Operation clientsGetClientWithHttpInfo
     *
     * Obtient un client précis
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsGetClientWithHttpInfo($id)
    {
        $request = $this->clientsGetClientRequest($id);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsGetClientAsync
     *
     * Obtient un client précis
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetClientAsync($id)
    {
        return $this->clientsGetClientAsyncWithHttpInfo($id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsGetClientAsyncWithHttpInfo
     *
     * Obtient un client précis
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetClientAsyncWithHttpInfo($id)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient';
        $request = $this->clientsGetClientRequest($id);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsGetClient'
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsGetClientRequest($id)
    {
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling clientsGetClient'
            );
        }

        $resourcePath = '/Clients/Client';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($id)) {
            $id = ObjectSerializer::serializeCollection($id, '', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $id;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsGetClients
     *
     * Obtient les clients
     *
     * @param  MetierClientWebConnectFiltreClient $filtre_client Structure représentant un filtage des clients (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnectClient
     */
    public function clientsGetClients($filtre_client = null, $pager = null)
    {
        list($response) = $this->clientsGetClientsWithHttpInfo($filtre_client, $pager);
        return $response;
    }

    /**
     * Operation clientsGetClientsWithHttpInfo
     *
     * Obtient les clients
     *
     * @param  MetierClientWebConnectFiltreClient $filtre_client Structure représentant un filtage des clients (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnectClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsGetClientsWithHttpInfo($filtre_client = null, $pager = null)
    {
        $request = $this->clientsGetClientsRequest($filtre_client, $pager);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnectClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnectClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnectClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnectClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsGetClientsAsync
     *
     * Obtient les clients
     *
     * @param  MetierClientWebConnectFiltreClient $filtre_client Structure représentant un filtage des clients (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetClientsAsync($filtre_client = null, $pager = null)
    {
        return $this->clientsGetClientsAsyncWithHttpInfo($filtre_client, $pager)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsGetClientsAsyncWithHttpInfo
     *
     * Obtient les clients
     *
     * @param  MetierClientWebConnectFiltreClient $filtre_client Structure représentant un filtage des clients (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetClientsAsyncWithHttpInfo($filtre_client = null, $pager = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\PagedResultMetierClientWebConnectClient';
        $request = $this->clientsGetClientsRequest($filtre_client, $pager);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsGetClients'
     *
     * @param  MetierClientWebConnectFiltreClient $filtre_client Structure représentant un filtage des clients (optional)
     * @param  Pager $pager Configuration de la sortie d&#39;un résultat      Une documentation complémentaire est disponible à l&#39;adresse [/api?doc&#x3D;WebConnect.Pager](https://nur1.pl-vega-0001.polarisgestionmag.net:3443/api?doc&#x3D;WebConnect.Pager) (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsGetClientsRequest($filtre_client = null, $pager = null)
    {

        $resourcePath = '/Clients/Clients';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($filtre_client)) {
            $filtre_client = ObjectSerializer::serializeCollection($filtre_client, '', true);
        }
        if ($filtre_client !== null) {
            $queryParams['filtreClient'] = $filtre_client;
        }
        // query params
        if (is_array($pager)) {
            $pager = ObjectSerializer::serializeCollection($pager, '', true);
        }
        if ($pager !== null) {
            $queryParams['pager'] = $pager;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsGetDiffusion
     *
     * Obtient les listes de diffusion des clients
     *
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCliDiffusionWebConnecListDiffusionId[]
     */
    public function clientsGetDiffusion()
    {
        list($response) = $this->clientsGetDiffusionWithHttpInfo();
        return $response;
    }

    /**
     * Operation clientsGetDiffusionWithHttpInfo
     *
     * Obtient les listes de diffusion des clients
     *
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCliDiffusionWebConnecListDiffusionId[], HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsGetDiffusionWithHttpInfo()
    {
        $request = $this->clientsGetDiffusionRequest();

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCliDiffusionWebConnecListDiffusionId[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCliDiffusionWebConnecListDiffusionId[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCliDiffusionWebConnecListDiffusionId[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCliDiffusionWebConnecListDiffusionId[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsGetDiffusionAsync
     *
     * Obtient les listes de diffusion des clients
     *
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetDiffusionAsync()
    {
        return $this->clientsGetDiffusionAsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsGetDiffusionAsyncWithHttpInfo
     *
     * Obtient les listes de diffusion des clients
     *
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsGetDiffusionAsyncWithHttpInfo()
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierCliDiffusionWebConnecListDiffusionId[]';
        $request = $this->clientsGetDiffusionRequest();

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsGetDiffusion'
     *
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsGetDiffusionRequest()
    {

        $resourcePath = '/Clients/Diffusion';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsPostBon
     *
     * Crée un nouveau bon
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClientUpdateable $metier_bon_web_connect_bon_client_updateable Bon à créer  (bon) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient
     */
    public function clientsPostBon($metier_bon_web_connect_bon_client_updateable)
    {
        list($response) = $this->clientsPostBonWithHttpInfo($metier_bon_web_connect_bon_client_updateable);
        return $response;
    }

    /**
     * Operation clientsPostBonWithHttpInfo
     *
     * Crée un nouveau bon
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClientUpdateable $metier_bon_web_connect_bon_client_updateable Bon à créer  (bon) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsPostBonWithHttpInfo($metier_bon_web_connect_bon_client_updateable)
    {
        $request = $this->clientsPostBonRequest($metier_bon_web_connect_bon_client_updateable);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsPostBonAsync
     *
     * Crée un nouveau bon
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClientUpdateable $metier_bon_web_connect_bon_client_updateable Bon à créer  (bon) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsPostBonAsync($metier_bon_web_connect_bon_client_updateable)
    {
        return $this->clientsPostBonAsyncWithHttpInfo($metier_bon_web_connect_bon_client_updateable)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsPostBonAsyncWithHttpInfo
     *
     * Crée un nouveau bon
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClientUpdateable $metier_bon_web_connect_bon_client_updateable Bon à créer  (bon) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsPostBonAsyncWithHttpInfo($metier_bon_web_connect_bon_client_updateable)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClient';
        $request = $this->clientsPostBonRequest($metier_bon_web_connect_bon_client_updateable);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsPostBon'
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierBonWebConnectBonClientUpdateable $metier_bon_web_connect_bon_client_updateable Bon à créer  (bon) (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsPostBonRequest($metier_bon_web_connect_bon_client_updateable)
    {
        // verify the required parameter 'metier_bon_web_connect_bon_client_updateable' is set
        if ($metier_bon_web_connect_bon_client_updateable === null || (is_array($metier_bon_web_connect_bon_client_updateable) && count($metier_bon_web_connect_bon_client_updateable) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $metier_bon_web_connect_bon_client_updateable when calling clientsPostBon'
            );
        }

        $resourcePath = '/Clients/Bon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($metier_bon_web_connect_bon_client_updateable)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($metier_bon_web_connect_bon_client_updateable));
            } else {
                $httpBody = $metier_bon_web_connect_bon_client_updateable;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsPostClient
     *
     * Créer un nouveau client ou modifie un client existant s&#39;il est déjà trouvé dans la base de données.
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientUpdateable $metier_client_web_connect_client_updateable Client  (client) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient
     */
    public function clientsPostClient($metier_client_web_connect_client_updateable)
    {
        list($response) = $this->clientsPostClientWithHttpInfo($metier_client_web_connect_client_updateable);
        return $response;
    }

    /**
     * Operation clientsPostClientWithHttpInfo
     *
     * Créer un nouveau client ou modifie un client existant s&#39;il est déjà trouvé dans la base de données.
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientUpdateable $metier_client_web_connect_client_updateable Client  (client) (required)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsPostClientWithHttpInfo($metier_client_web_connect_client_updateable)
    {
        $request = $this->clientsPostClientRequest($metier_client_web_connect_client_updateable);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsPostClientAsync
     *
     * Créer un nouveau client ou modifie un client existant s&#39;il est déjà trouvé dans la base de données.
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientUpdateable $metier_client_web_connect_client_updateable Client  (client) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsPostClientAsync($metier_client_web_connect_client_updateable)
    {
        return $this->clientsPostClientAsyncWithHttpInfo($metier_client_web_connect_client_updateable)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsPostClientAsyncWithHttpInfo
     *
     * Créer un nouveau client ou modifie un client existant s&#39;il est déjà trouvé dans la base de données.
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientUpdateable $metier_client_web_connect_client_updateable Client  (client) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsPostClientAsyncWithHttpInfo($metier_client_web_connect_client_updateable)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient';
        $request = $this->clientsPostClientRequest($metier_client_web_connect_client_updateable);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsPostClient'
     *
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClientUpdateable $metier_client_web_connect_client_updateable Client  (client) (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsPostClientRequest($metier_client_web_connect_client_updateable)
    {
        // verify the required parameter 'metier_client_web_connect_client_updateable' is set
        if ($metier_client_web_connect_client_updateable === null || (is_array($metier_client_web_connect_client_updateable) && count($metier_client_web_connect_client_updateable) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $metier_client_web_connect_client_updateable when calling clientsPostClient'
            );
        }

        $resourcePath = '/Clients/Client';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($metier_client_web_connect_client_updateable)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($metier_client_web_connect_client_updateable));
            } else {
                $httpBody = $metier_client_web_connect_client_updateable;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation clientsPutClientCarte
     *
     * Modifie le nombre de points
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectCarteFideliteModification $metier_client_web_connect_carte_fidelite_modification Client  (carteModification) (required)
     * @param  string $code_carte Code de la carte client à modifier. Si non précisée, la première carte valide dans le magasin de référence sera utilisée, à défaut, la première carte trouvée. (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient
     */
    public function clientsPutClientCarte($id, $metier_client_web_connect_carte_fidelite_modification, $code_carte = null)
    {
        list($response) = $this->clientsPutClientCarteWithHttpInfo($id, $metier_client_web_connect_carte_fidelite_modification, $code_carte);
        return $response;
    }

    /**
     * Operation clientsPutClientCarteWithHttpInfo
     *
     * Modifie le nombre de points
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectCarteFideliteModification $metier_client_web_connect_carte_fidelite_modification Client  (carteModification) (required)
     * @param  string $code_carte Code de la carte client à modifier. Si non précisée, la première carte valide dans le magasin de référence sera utilisée, à défaut, la première carte trouvée. (optional)
     *
     * @throws \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient, HTTP status code, HTTP response headers (array of strings)
     */
    public function clientsPutClientCarteWithHttpInfo($id, $metier_client_web_connect_carte_fidelite_modification, $code_carte = null)
    {
        $request = $this->clientsPutClientCarteRequest($id, $metier_client_web_connect_carte_fidelite_modification, $code_carte);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    if ('\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation clientsPutClientCarteAsync
     *
     * Modifie le nombre de points
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectCarteFideliteModification $metier_client_web_connect_carte_fidelite_modification Client  (carteModification) (required)
     * @param  string $code_carte Code de la carte client à modifier. Si non précisée, la première carte valide dans le magasin de référence sera utilisée, à défaut, la première carte trouvée. (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsPutClientCarteAsync($id, $metier_client_web_connect_carte_fidelite_modification, $code_carte = null)
    {
        return $this->clientsPutClientCarteAsyncWithHttpInfo($id, $metier_client_web_connect_carte_fidelite_modification, $code_carte)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation clientsPutClientCarteAsyncWithHttpInfo
     *
     * Modifie le nombre de points
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectCarteFideliteModification $metier_client_web_connect_carte_fidelite_modification Client  (carteModification) (required)
     * @param  string $code_carte Code de la carte client à modifier. Si non précisée, la première carte valide dans le magasin de référence sera utilisée, à défaut, la première carte trouvée. (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function clientsPutClientCarteAsyncWithHttpInfo($id, $metier_client_web_connect_carte_fidelite_modification, $code_carte = null)
    {
        $returnType = '\PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectClient';
        $request = $this->clientsPutClientCarteRequest($id, $metier_client_web_connect_carte_fidelite_modification, $code_carte);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'clientsPutClientCarte'
     *
     * @param  MetierClientWebConnectClientId $id Identifiants du client (required)
     * @param  \PrestaShop\Module\PolarisPrestaConnector\pol\api\lib\Model\MetierClientWebConnectCarteFideliteModification $metier_client_web_connect_carte_fidelite_modification Client  (carteModification) (required)
     * @param  string $code_carte Code de la carte client à modifier. Si non précisée, la première carte valide dans le magasin de référence sera utilisée, à défaut, la première carte trouvée. (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function clientsPutClientCarteRequest($id, $metier_client_web_connect_carte_fidelite_modification, $code_carte = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling clientsPutClientCarte'
            );
        }
        // verify the required parameter 'metier_client_web_connect_carte_fidelite_modification' is set
        if ($metier_client_web_connect_carte_fidelite_modification === null || (is_array($metier_client_web_connect_carte_fidelite_modification) && count($metier_client_web_connect_carte_fidelite_modification) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $metier_client_web_connect_carte_fidelite_modification when calling clientsPutClientCarte'
            );
        }

        $resourcePath = '/Clients/ClientCarte';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($id)) {
            $id = ObjectSerializer::serializeCollection($id, '', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $id;
        }
        // query params
        if ($code_carte !== null) {
            if('form' === 'form' && is_array($code_carte)) {
                foreach($code_carte as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['codeCarte'] = $code_carte;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($metier_client_web_connect_carte_fidelite_modification)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($metier_client_web_connect_carte_fidelite_modification));
            } else {
                $httpBody = $metier_client_web_connect_carte_fidelite_modification;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-API-Key');
        if ($apiKey !== null) {
            $headers['X-API-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('PUT', $uri, $headers, $httpBody);
    }


    /**
     * @param string $method
     * @param string|UriInterface $uri
     * @param array $headers
     * @param string|StreamInterface|null $body
     *
     * @return RequestInterface
     */
    protected function createRequest(string $method, $uri, array $headers = [], $body = null): RequestInterface
    {
        if ($this->requestFactory instanceof RequestFactory) {
            return $this->requestFactory->createRequest(
                $method,
                $uri,
                $headers,
                $body
            );
        }

        if (is_string($body) && '' !== $body && null === $this->streamFactory) {
            throw new \RuntimeException('Cannot create request: A stream factory is required to create a request with a non-empty string body.');
        }

        $request = $this->requestFactory->createRequest($method, $uri);

        foreach ($headers as $key => $value) {
            $request = $request->withHeader($key, $value);
        }

        if (null !== $body && '' !== $body) {
            $request = $request->withBody(
                is_string($body) ? $this->streamFactory->createStream($body) : $body
            );
        }

        return $request;
    }

    private function createUri(
        string $operationHost,
        string $resourcePath,
        array $queryParams
    ): UriInterface {
        $parsedUrl = parse_url($operationHost);

        $host = $parsedUrl['host'] ?? null;
        $scheme = $parsedUrl['scheme'] ?? null;
        $basePath = $parsedUrl['path'] ?? null;
        $port = $parsedUrl['port'] ?? null;
        $user = $parsedUrl['user'] ?? null;
        $password = $parsedUrl['pass'] ?? null;

        $uri = $this->uriFactory->createUri($basePath . $resourcePath)
            ->withHost($host)
            ->withScheme($scheme)
            ->withPort($port)
            ->withQuery(ObjectSerializer::buildQuery($queryParams));

        if ($user) {
            $uri = $uri->withUserInfo($user, $password);
        }

        return $uri;
    }
}
