---
title: "PolarisPrestaConnector - Migration depuis PolarisLink"
header-left: "PolarisPrestaConnector - Migration depuis PolarisLink"
footer-center: "[page]"
pdf-engine: wkhtmltopdf
...

# Manuel de migration

Ce document a pour but de présenter les étapes exhaustives d'une migration du module `PolarisLink` édité par la société VEGA Informatique vers le module `PolarisPrestaConnector`.

Chaque étape y est décrite, aucune étape n'est optionnelle et elles sont à réaliser dans cet ordre précis. 

Prévoyez que pour éviter toute perte de donnée, votre site doit être fermé pendant la migration pendant la phase 3 ! 

**Merci d'arrêter le processus dès qu'une erreur survient.** 



⚠️ Nous vous conseillons de tester la migration sur une copie de votre site pour vous assurez de son bon fonctionnement avant de lancer la procédure sur votre site de production. 

**Dans ce cas :** 

- effectuez la phase 1 normalement ;
- effectuez la phase 2 sur le **site de production** ;
- effectuez la phase 3 sur une copie du site réalisée après la phase 2 ;
- ignorez la phase 5 tant que le site de production n'a pas été migré.



## Phase 1 : préparation de Polaris

*Cette phase est à réaliser par le client, aidé ou non par l'assistance Polaris.*

- assurez-vous d'être au minimum dans la **version 14 de Polaris** ;
- sous Polaris, en *administrateur* ou un profil ayant des droits de configuration, dans le menu `Système / Gestion des appareils` ; créez un `nouveau prestataire` à l'aide du bouton idoine ;
- sélectionnez `WebConnect`; si cette option est désactivée, votre licence n'a probablement pas encore été convertie, merci de contacter votre commercial pour déverrouiller son accès ;
- choisissez dans le nouveau panneau quel est votre magasin de référence et choisissez de reprendre les descriptions de votre ancien site internet en le sélectionnant dans `Utiliser les descriptions du site Internet` ;
- choisissez les options qui conviennent, comme paramétrer le code caisse et les magasins dont vous exposez le stock sur votre site ;
- notez le code PIN qui est communiqué dans la messagerie, vous en aurez besoin ; *⚠️ Si jamais le code PIN périme ou vient à devoir être regénéré, vous pourrez revenir dans cette fenêtre à cette fin ;*



## Phase 2 : préparation de Prestashop

*Cette phase est à réaliser par le webmestre du client avec le concours du client. Cette phase peut être longue et s'étirer sur plusieurs jours selon les options retenues.*



**Avant de préparer Prestashop, merci de noter :**

- normalement PolarisLink et le nouveau connecteur sont compatibles entre-eux de sorte à ce que PolarisPrestaConnector arrive à reprendre vos anciennes références ;
- la référence des produits Prestashop est maintenant strictement égale à votre code modèle Polaris, y compris si ce dernier se décline en plusieurs coloris ;
- le nouveau connecteur ne crée pas automatiquement une catégorie Prestashop pour chaque rayon, famille et sous-famille de Polaris. Vous devez créer ces catégories manuellement et choisir quelles RFS/Catégories Polaris ventiler dans quelles catégories Prestashop ;
- si vous aviez défini un mappage des classifications Polaris avec PolarisLink, le module essaye de la récupérer automatiquement ;
- il en fait de même pour les marques ;



**Pour préparer Prestashop :**

- téléchargez et installez la dernière version du module disponible : [https://ftp.vega-net.net/dists/polarisprestaconnector/stable/latest/polarisprestaconnector.zip](https://ftp.vega-net.net/dists/polarisprestaconnector/stable/latest/polarisprestaconnector.zip) ;
- si cette étape a déjà été réalisée auparavant, assurez-vous d'utilisez la dernière version disponible ; 
- dans les options du module, connectez le module au backoffice Polaris à l'aide du numéro de licence et du code PIN fourni à la phase 1 ;
- une fois la connexion établie, vous avez accès aux paramètres du module, assurez-vous dans le panneau `Options générales` que l'option `Synchronisation activée` est bien **désactivée**, si ce n'est pas le cas, faites-le maintenant ;
- vous allez devoir maintenant configurer l'intégralité du module avant de réactiver cette option. Assurez-vous de bien lire et détailler chaque option pour reproduire le comportement de l'ancienne passerelle ou définir le nouveau comportement souhaité. Commencez par choisir le mode de synchronisation : `basique` si vous ne voulez que le stock et les prix, `complet` autrement ;
- mettez en place la tâche de synchronisation (tâche cron) demandée ;
- dans l'onglet `Paramètres du catalogue`, **choisissez les attributs discriminants et le mappage des attributs de produit**. C'est le paramètre le plus important, notamment que faire avec la couleur. Par défaut, le module créera 1 produit Prestashop pour chaque déclinaison Polaris *(i.e. 1 modèle Prestashop par couleur)*. Nous conseillons ce paramétrage ;
- ⚠️⚠️⚠️ dans l'onglet `Paramètres des commandes`, reportez l'ID de la dernière commande dans le champ `ID minimal d'exportation` pour ne pas réimporter vos anciennes commandes sur Polaris ;
- dans ce même onglet, remplissez vos modes de règlement et vos références pour les frais de port ; par défaut, si le mode de règlement n'est pas mappé, le module utilisera `CC` ;
- dans les configurations de mappage (bouton `Mappings` tout en haut), vérifiez/corrigez le mapping des marques, des grilles de taille et des autres catégories ; 
- il est normal de ne pas retrouver vos grilles de tailles avant votre première synchronisation ; si vous utilisez plusieurs grilles de tailles différentes sur Prestashop, faites une synchronisation à vide (laissez `Toutes les autres` sur la valeur `Ne pas importer les produits avec cette grille de tailles `) pour peupler cette valeur, sinon, réglez `Toutes les autres` sur le groupe d'attributs qui contient vos tailles/pointures ;
- choisissez un produit de test et notez ses données principales (libellé, stock, description, photo, déclinaisons) ;



## Phase 3 : migration

*Cette phase est à réaliser par le webmestre du client.*

- fermez le site Internet aux internautes en le passant en maintenance ;
- ⚠️**effectuez une sauvegarde complète de la base de données du site ;**
- dans les options du module `PolarisLink`, désactivez la synchronisation en désactivant l'option `Accès actif` ; *ne désactivez pas le module !!*
- attendez ou stoppez la fin de toute synchronisation éventuellement en cours ;
- dans les options du module `PolarisPrestaConnector`, activez la synchronisation en activant l'option `Synchronisation activée` dans les `Options générales` ;
- cliquez sur le bouton `Resynchroniser` tout en haut de la page ;
- attendez la fin de la synchronisation ;
- vérifiez que les produits tests sont corrects ;



## Phase 4 : nettoyage Prestashop

*Cette phase est à réaliser par le webmestre du client quand il est sûr qu'aucun retour en arrière n'est envisagé.*

- désinstallez et supprimez le module `PolarisLink` ;
- si vous ne les utilisez pas, supprimez toutes les catégories filles et petites filles de la catégorie `Classification Polaris` : *très nombreuses, elles peuvent vite ralentir votre site, même si elles ne sont pas utilisées* ;
- à l'aide d'un outil de base de données, supprimez toutes les tables `ps_polarislink_*` pour nettoyer les données du module ;



## Phase 5 : nettoyage Polaris

*Cette phase est à réaliser par le client, aidé ou non par l'assistance Polaris.*

- supprimer toutes les tâches automatisées de type `Prestashop` ;



## En cas d'erreur

### En cas d'erreur en phase 3

Les erreurs en phase 3 sont problématiques car elle peuvent conduire à un mauvais fonctionnement du connecteur impactant le front : références en plusieurs exemplaires, remontée des ventes en double, stock faux, etc ...
Il est essentiel de n'avoir **AUCUNE** erreur en phase 3.

- notez le message d'erreur ou décrivez le comportement/le résultat que vous attendiez et le comportement/résultat que vous avez obtenu ;
- si votre problème est clairement visible sur une référence, notez là ;
- faîte une copie d'écran qui montre le problème ;
- restaurez la sauvegarde effectuée préalablement au début de la phase 3 ;
- contactez VEGA Informatique ;

### Erreur en phase 1 à 2 :

- contactez VEGA Informatique ;

### Erreurs en phase 4 ou 5 : 

Les erreurs à ce stade ne sont vraiment pas impactantes et peuvent être ignorées.