<?php

use PrestaShop\Module\PolarisPrestaConnector\BridgeAdapter;
use PrestaShop\Module\PolarisPrestaConnector\SyncConfiguration;

/**
 * Boucle principale de synchronisation 
 * 
 * Pour éxécuter les tâches asynchrones, il faudra appeler ce contrôleur via tâches automatisées le plus fréquemment
 * possible.
 */

class PolarisPrestaConnectorCronModuleFrontController extends \ModuleFrontController
{
    /**
     * Page de maintenance ?
     * 
     */
    protected function displayMaintenancePage()
    {
        // Pas de maintenance pour ce contrôleur !
    }

   /**
    * Appel ici
    */
   public function display()
    {
        // Est-ce le bon token ?        
        $module = $this->module;

        // Module est un \PrestraConnector, on le signale en PHPdoc pour avoir l'autocomplétion
        /** @var PrestaShop\Module\PolarisPrestaConnector\PolarisPrestaConnector $module */
               
        $token_to_have = $module->getCfg()->get(SyncConfiguration::CFG_GUARD_TOKEN);
        if (Tools::getValue('guard') != $token_to_have)
        {           
            // Code réponse 403
            http_response_code(403); 
            echo 'Token de sécurité incorrect';
            return;
        }

        // Get absolute URL for index page
        $context = Context::getContext();
        $url = $context->link->getBaseLink();

        // Add admin directory
        // Search the first sub directory with an index.php file which contains "Symfony"
        // use glob ?
        $adminDir = '';
        foreach (scandir(_PS_ROOT_DIR_) as $fileOrDir)
        {
            if (is_dir(_PS_ROOT_DIR_ . DIRECTORY_SEPARATOR . $fileOrDir) &&
                preg_match('/^admin/', $fileOrDir) &&
                !preg_match('/^admin-api/', $fileOrDir) &&
                file_exists(_PS_ROOT_DIR_ . DIRECTORY_SEPARATOR . $fileOrDir . DIRECTORY_SEPARATOR . 'index.php'))
            {
                $content = file_get_contents(_PS_ROOT_DIR_ . DIRECTORY_SEPARATOR . $fileOrDir . DIRECTORY_SEPARATOR . 'index.php');
                if (strpos($content, 'Symfony') !== false)
                {
                    $adminDir = $fileOrDir;
                    break;
                }
            }
        }

        $url .= $adminDir . '/modules/' . $module->name . '/cron?guard=' . urlencode($token_to_have);
        
        // Redirection vers le contrôleur symfony
        Tools::redirect($url);
    }
}