$(document).ready(function() {
        
    const choiceTreeElement = document.querySelector('.type-material_choice_tree');
    if (choiceTreeElement) {
        new window.prestashop.component.ChoiceTree(choiceTreeElement);
    }
    
  });

  
document.addEventListener('DOMContentLoaded', function () {    
    const baseUrl = $('body').data('base-url');
    const token = $('body').data('token');    
    
    /**
     * 
     */
    function prestashopconnector_verifyLogin() {
        let button = $("#polarisprestaconnector_login #btn-verify");
        button.html('<div class="loader2"></div>Interrogation en cours').attr("disabled", "disabled");
        
        // S'il y a une erreur, la journaliser dans le console.log

         $.ajax({
            url: `${baseUrl}/modules/polarisprestaconnector/connect?_token=${token}`,
            method: 'POST',
            data: { 
                address: $("#address").val(),
                fingerprint: $("#fingerprint").val(),
                username: $("#user").val(),
                password: $("#password").val(),
                pincode: $("#pincode").val(),
             },
            dataType: 'json',            
        })    
        .fail(function (jqXHR, textStatus, errorThrown) {            
            // L'erreur est dans le body de la réponse
            let data = JSON.parse(jqXHR.responseText);
            
            // On arrête la progression
            button.html('Suivant').attr("disabled", false);
            // S'il y a eu une erreur, on affiche l'erreur
            $(".error-msg").html(`Prestashop a renvoyé une erreur ${data.status} : ${data.detail}`);
        })
        .done(function (data) {

            // On arrête la progression
            button.html('Suivant').attr("disabled", false);

            // S'il y a eu une erreur, on affiche l'erreur
            $(".error-msg").html(data.message);

            if (data.success)
            {
                window.location.href = `${baseUrl}/modules/polarisprestaconnector/configuration/information?_token=${token}`;
            }
            else
            {
                // Erreur inférieure à 10 : problème avec l'adresse
                $(".address").hide();
                $(".fingerprint").hide();
                $(".user-mdp").hide();
                $(".pincode").hide();

                if (data.code < 10) {
                    $(".address").show();                    
                } else if (data.code > 13 && data.code < 20) {
                    // Erreur > 13 et < 20 : problème avec le fingerprint
                    $("#fingerprint").val(data.fingerprint);
                    $(".fingerprint").show();
                } else if (data.code >= 20 && data.code < 30) {
                    // Erreur >=20 : erreur avec les users/mdp
                    $(".user-mdp").show();
                } else if (data.code >= 30 && data.code < 40) {
                    // Erreur >=30 : erreur avec les pincodes
                    $(".pincode").show();
                }
            }
        });
    }    

    $("#polarisprestaconnector_login #btn-verify").on("click", prestashopconnector_verifyLogin);

    // TODO : Ajouter les autres fonctions de configuration ici

    // On met en place un évènement toutes les 10 secondes qui contrôle si une synchronisation est en cours
    // avec setTimeout pour le relancer uniquement lorsque le contrôle est fait
    (function checkSync() {
        setTimeout(async function () {
            await polarisprestaconnector_adminSyncProgressCheck();
            // On relance la vérification
            checkSync();
        }, 10000);
    })();

    /**
     * Active un onglet en fonction de sa classe
     * Pour que ça fonctionne il faut que l'id de l'objet soit égal à nav + son nom de route
     * 
     * @returns 
     */
    function activateTabs() {
        const navElement = document.querySelector(`.pc-nav`);
        if (!navElement) return;

        // Récupère l'URL actuelle
        let currentUrl = window.location.href;

        // Pour chaque élément fils immédiats de navElement ayant pour classe nav-link
        navElement.querySelectorAll('.nav-link').forEach(el => {
            el.classList.remove('active');
            // on extrait de l'id l'identifiant de la route : nav-identifiant
            let id = el.id.split('-')[1] ?? null;
            if (id && currentUrl.includes('/' + id))
                el.classList.add('active');
        });
    }

    activateTabs();
});