<?php
namespace PrestaShop\Module\PolarisPrestaConnector\Forms;

use PrestaShop\Module\PolarisPrestaConnector\SyncConfiguration;
use PrestaShopBundle\Form\Admin\Type\ButtonCollectionType;
use PrestaShopBundle\Form\Admin\Type\FormattedTextareaType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class ColorMapType extends ConnectorType {

    
    public function buildForm(FormBuilderInterface $builder, array $options)
    {   
        // Obtenir la liste des équivalences actuelles
        $colorMap = $this->module->getCfg()->get(SyncConfiguration::CFG_COLOR_MAP);
        if (!isset($colorMap))
            $colorMap = [];
        if (!isset($colorMap["strict"]))
            $colorMap["strict"] = [];

        // On génère la liste des couleurs, on transforme clé => valeur en CSV
        $list = '';
        foreach ($colorMap["strict"] as $k => $v)
            $list .= "$k;$v\n";        
        
        $builder->add('choice', FormattedTextareaType::class, [
            'help' => null,
            'required' => false,
            'data' => $list,
            'limit' => 1000000,
            'autoload' => false,
        ]);
        
        $builder->add('actions', ButtonCollectionType::class, [
            'required' => false,
            'buttons' => [
                'submit' => [
                    'type' => SubmitType::class,
                    'options' => [
                        'label' => 'Modifier',
                        'attr' => ['class' => 'btn-form-valid btn-primary']
                    ]
                ],            
            ],
            'attr' => [
                'class' => 'prestaconnector-row-actions',
            ],        
        ]);
    }

}