/*
    Ajout de fonctions personnalisées au serviceWorker généré par @angular/pwa
*/
try
{
    importScripts('./ngsw-worker.js');
    console.debug("Service worker up !");
}
catch (e)
{
    console.warn("Cette erreur est normale en développement avec ng serve et peut être ignorée : par contre, l'application ne sera pas accessible hors ligne !");
}

/**
 * Installation du service worker
 */
self.addEventListener('install', function (event) {
    // On utilise cette version du worker TOUT DE SUITE !!
    event.waitUntil(self.skipWaiting());
});

/**
 * Initialisation du worker
 */
self.addEventListener('activate', function (event) {    
    // On utilise cette version du worker TOUT DE SUITE !!
    event.waitUntil(self.clients.claim());
});

/**
 * Envoi une copie d'un message à tous les clients connectés
 */
 async function broadcastMsg(msg) {
    // includeUncontrolled: true permet de dispatcher à tous les clients à l'intérieur des iframes contenues : pratique pour home !
    self.clients.matchAll({includeUncontrolled: true, type: 'window'}).then((clients) => {
        clients.forEach(client => {
            client.postMessage(msg);
        });
    });
}

/**
 * Surveille les messages et redispatch les messages entrants vers les process fils
 * 
 */
self.addEventListener('message', function (e) {
    if (e.data["type"] == "polaris-dispatch-msg")
        this.self.broadcastMsg({ type: "polaris-msg", msg: e.data["msg"] });
});
