{extends file='customer/page.tpl'} 
{* Étend le template de base des pages client *}

{block name='page_title_customer'}
  <div class="title-user">
    {l s='Wishlist' d='Shop.Theme.Customeraccount'} 
    {* Affiche le titre "Wishlist" traduit *}
  </div>
{/block}

{block name='page_content'}
  {if $wishlist|@count > 0} 
    {* Vérifie si la wishlist contient des produits *}
    <div class="wishlist-products">

      {foreach from=$wishlist item=product}
        {* Boucle sur chaque produit de la wishlist *}
        <div class="col-xxs-6 col-sm-6 col-md-4 product-card">
          <article>

            {* Lien vers la page produit *}
            <a href="{$product.link}">
              {assign var='has_cover' value=false}

              {* Boucle sur toutes les images du produit *}
              {foreach from=$product.image item=image}
                {if $image.id_image == $product.id_cover}
                  {* Si c’est l’image de couverture, on l’affiche *}
                  {assign var='has_cover' value=true}
                  <img src="{$urls.base_url}{$image.id_image}-medium_default/{$product.name|escape:'html':'UTF-8'}.jpg"
                       alt="{$product.name|escape:'html':'UTF-8'}"
                       loading="lazy">
                {/if}
              {/foreach}

              {* Si aucune image de couverture n’a été trouvée, on affiche l’image par défaut *}
              {if !$has_cover}
                <img src="{$urls.base_url}img/p/fr-default-medium_default.jpg"
                     alt="{$product.name|escape:'html':'UTF-8'}"
                     loading="lazy">
              {/if}
            </a>

            {* Nom du produit *}
            <p class="h3 product-title">
              {$product.name|escape:'html':'UTF-8'}
            </p>

            {* Prix du produit *}
            <p class="price product-price-and-shipping">
              {$product.price_ttc|number_format:2:'.':' '} €
            </p>

            {* Bloc des actions produit (formulaire d’ajout au panier) *}
            <div class="product-actions js-product-actions">

              {* Formulaire avec dataset contenant les combinaisons pour le JS *}
              <form class="add-to-cart-form"
                    action="{$link->getPageLink('cart', true, null, ['add' => 1])}"
                    method="post"
                    data-combinations='{$product.combinations_json|escape:"html"}'>

                {* Champs cachés pour l’ajout au panier *}
                <input type="hidden" name="id_product" value="{$product.id_product}">
                <input type="hidden" name="qty" value="1">
                <input type="hidden" name="id_product_attribute" class="id_product_attribute_field" value="">

                {* Boucle sur les groupes d’attributs (taille, couleur, etc.) *}
                {foreach from=$product.attributes key=attr_group_id item=group}
                  <div class="clearfix product-variants-item">

                    {* Liste déroulante pour choisir la valeur de l’attribut *}
                    <select class="form-control form-control-select"
                            data-attr-group="{$group.id_attribute_group}"
                            name="group[{$group.id_attribute_group}]">
                      <option value="">
                        {l s='Choisir' d='Shop.Theme.Catalog'}
                      </option>
                      {foreach from=$group.options item=opt}
                        <option value="{$opt.id_attribute}">
                          {$opt.attribute_name}
                        </option>
                      {/foreach}
                    </select>
                  </div>
                {/foreach}

                {* Bouton pour ajouter au panier *}
                <div class="product-add-to-cart js-product-add-to-cart">
                  <button data-button-action="add-to-cart"
                          type="submit"
                          class="btn btn-primary add-to-cart">
                    {l s='Ajouter au panier' d='Shop.Theme.Catalog'}
                  </button>
                </div>
              </form>
            </div>
          </article>
        </div>
      {/foreach}
    </div>

  {else} 
    {* Si la wishlist est vide *}
    <p>{l s='Votre wishlist est vide.' d='Shop.Theme.Customeraccount'}</p>
  {/if}
{/block}