<?php 
/**
 * 
 */

declare(strict_types=1);

namespace PrestaShop\Module\LCVPrestaTheme\Config;

class ConfigGeneral{

    /**
     * Selection du theme  
     *
     * @var  string
     */
    public $theme = '';


    /**
     * Selection de la couleur principale
     *
     * @var  string
     */
    public $primary = '';


    /**
     * Selection de la couleur secondaire
     *
     * @var  string
     */
    public $secondary = '';


     /**
     * Selection de la police pour les titres 
     *
     * @var  string
     */
    public $fontTitle = '';


    
     /**
     * Selection de la police pour le texte
     *
     * @var  string
     */
    public $fontText = '';


    public function fontUpdate(){
        $filePath = _PS_ROOT_DIR_ . '/themes/presta_theme/assets/css/font.css';

        $fontCss  = "@font-face { font-family: '" . $this->fontTitle . "'; src: url('../fonts/" . $this->fontTitle . "-Regular.ttf') format('truetype'); }\n";
        $fontCss .= "@font-face { font-family: '" . $this->fontTitle . "-Italic'; src: url('../fonts/" . $this->fontTitle . "-Italic.ttf') format('truetype'); }\n";
        $fontCss .= "@font-face { font-family: '" . $this->fontText . "'; src: url('../fonts/" . $this->fontText . "-Regular.ttf') format('truetype'); }\n";
        $fontCss .= "@font-face { font-family: '" . $this->fontText . "-Italic'; src: url('../fonts/" . $this->fontText . "-Italic.ttf') format('truetype'); }\n";

        file_put_contents($filePath, $fontCss);

    }


}