{if $saleProducts}
<div class="container product-container home">
    <h2 class="product-title">PRODUITS EN PROMOTIONS</h2>

    <div class="slider-wrapper" data-slider="sale">
        <div class="slider-track">
            {foreach from=$saleProducts item=product}
                <div class="col-xxs-6 col-sm-6 col-md-3 product-card">
                    <article>
                        <a href="{$product.link}">
                            <p class="product-flag on-sale"> - {$product.discount_percentage} %</p>
                            {foreach from=$product['image'] item=image}
                                {if $image.id_image == $product.id_cover}
                                    <img class="cover" src="{$urls.base_url}{$image.id_image}-medium_default/{$product.name}.jpg" alt="{$product.name}" loading="lazy">
                                {/if}
                            {/foreach}
                        
                            {if empty($product.id_cover)}<img src="{$urls.base_url}img/p/fr-default-medium_default.jpg" alt="" loading="lazy">{/if}
                        </a>
                        <p class="h3 product-title">{$product.name}</p>
                        <p class="price product-price-and-shipping">{$product.price_discount|number_format:2:'.':' '} €  <span class="regular-price scratch-price">{$product.price|number_format:2:'.':' '} €</span></p>                
                    </article>
                </div>
            {/foreach}
        </div>
        
    </div>

    {if count($saleProducts) > 4}
        <button data-slider="sale" class="prevBtn prev"><svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M400-80 0-480l400-400 71 71-329 329 329 329-71 71Z"/></svg></button>
        <button data-slider="sale" class="nextBtn next"><svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="m321-80-71-71 329-329-329-329 71-71 400 400L321-80Z"/></svg></button>
    {/if}
</div> 
{/if}
<script src="{$urls.base_url}modules/lcvprestatheme/views/js/productSlide.js"></script>
