<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class StoreType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('name', TextType::class, [
                'label' => 'Nom du magasin',
                'required' => false,
                'help' => 'laisser vide pour ne pas afficher de titre',
                'empty_data' => '',
                 "attr"=>[
                "placeholder" => "Ajouter un nom"
                ]
            ])
        ->add('url', TextType::class, [
                'label' => 'Url',
                'required' => false,
                'empty_data' => '',
                  "attr"=>[
                "placeholder" => "Url du magasin"
            ]
            ])
            ->add('image', FileType::class, [
                'label' => 'Image',
                'required' => false,
                'mapped' => false,
            ])

         ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                    'data-hex' => 'true'
                ],
            ]);
    }



       public static function getIntro(): ?string
    {
        return 'Cette page vous permet d’ajouter un magasins afin que les clients soient redirigés vers le site correspondant à leur localisation.</br>
        - Ajoutez un nom de magasin (facultatif) : laissez vide si vous ne souhaitez pas l\'afficher.</br>
        - indiquez l\'URL du magasin</br>
        - Sélectionnez une image en cliquant sur "Choisir un(des) fichier(s)".</br>
        ';
    }

        public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }

}