<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Context;
use Category;


class MenuParentType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $categories_parent = Category::getCategories(
            Context::getContext()->language->id,
            true, // active
            false // id_parent = 1
        );

        $choices = [];
        foreach ($categories_parent as $category) {
            $choices[$category['name']] = $category['id_category'];
        }
        
        $builder
        ->add('isVisible',SwitchType::class, [
            'required' => false,
            'label' => 'Activer la visibilité',
        ])

        ->add('menu', ChoiceType::class, [
            'label' => 'Sélectionner la catégorie parent du menu ',
            'multiple' => false,
            'choices' => $choices,
            'required' => true,

        ])


       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ]);
    
    }


    public static function getIntro(): ?string
    {
        return 'Cette page vous permet de définir le menu principal (niveau 1) et de lier une catégorie parente.</br>
        - Sélectionnez la catégorie principale à associer à ce menu (ex. : "Homme", "Femme", etc.).</br>
        - Activez ou désactivez la visibilité du menu via le bouton dédié.</br>
        ';
    }



}