<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class LivraisonType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'required' => false,
            'label' => 'Activer la visibilité',
        ])
        
        ->add('freeDelivery', IntegerType::class,[
            'label'    => 'Montant pour benificier de la livraison gratuite',
             "attr"=>[
                "placeholder" => "Ajouter le montant minimum pour la livraison gratuite"
            ]
         ])

        ->add('deliveryTime', IntegerType::class,[
            'label'    => 'durée de la livraison',
             "attr"=>[
                "placeholder" => "Ajouter le nombre de jours pour la livraison"
            ]
         ])
         
        ->add('shippingTime', IntegerType::class,[
            'label'    => 'heure maximum pour que le colis soit envoyé le jour meme',
             "attr"=>[
                "placeholder" => "Ajouter l'heure maximum pour l'envoi du colis le jour même"
            ]
         ])

         // Ajout du champ pour sélectionner les jours de la semaine
         ->add('noShippingDays', ChoiceType::class, [
            'label' => 'Jours sans envoi de colis',
            'choices' => [
                'Lundi' => 'monday',
                'Mardi' => 'tuesday',
                'Mercredi' => 'wednesday',
                'Jeudi' => 'thursday',
                'Vendredi' => 'friday',
                'Samedi' => 'saturday',
                'Dimanche' => 'sunday',
            ],
            'multiple' => true, // Permet de choisir plusieurs jours
            'expanded' => true, // Utilise des cases à cocher pour chaque jour
            'required' => false, // Facultatif si vous souhaitez que ce soit optionnel
        ])

       
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }

    public static function getIntro(): ?string
    {
        return 'Cette page vous permet de définir les paramètres liés à la livraison pour votre boutique.</br>
        - Activez ou désactivez l\'affichage des informations de livraison sur le site.</br>
        - Définissez le montant minimum pour bénéficier de la livraison gratuite : ce montant est utilisé pour afficher une barre de progression animée dans le panier.</br>
        - Indiquez la durée estimée de livraison (en jours ouvrés) pour informer vos clients.</br>
        - Définissez l\'heure limite d\'expédition le jour même : les commandes passées après cette heure seront envoyées le jour suivant..</br>
        - Sélectionnez les jours sans envoi de colis (ex. : week-ends ou jours de fermeture logistique).</br>
        - Une fois tous les champs remplis, cliquez sur "Enregistrer" pour enregistrer les modifications.</br></br>

        Ces paramètres permettent d’améliorer la transparence de votre boutique et d’inciter à l’achat grâce à une estimation claire et à une barre d\'encouragement pour la livraison gratuite.
        ';
    }


}