<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ColorType;

class HeaderType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('header', ChoiceType::class, [
                'choices' => [
                    'Header 1' => 'header1',
                    'Header 2' => 'header2',
                    'Header 3' => 'header3',
                ],
                'label' => 'Choisissez un syle d\'en-tête',
                'expanded' => true, // Pour afficher les options sous forme de boutons radio
                'multiple' => false, // Un seul choix possible
                'attr' => [
                    'class' => 'theme-choice',
                ],

                'choice_label' => function($choice) {
                $baseUri = __PS_BASE_URI__; // Récupère l'URL de base de PrestaShop
                // Associe chaque option à une image
                switch ($choice) {
                    case 'header1':
                        return '<img src="' . $baseUri . 'modules/lcvprestatheme/img/header1.png" alt="header 1" />';
                    case 'header2':
                        return '<img src="' . $baseUri . 'modules/lcvprestatheme/img/header1.png" alt="header 2" /> ';
                    case 'header3':
                        return '<img src="' . $baseUri . 'modules/lcvprestatheme/img/header1.png" alt="header 3" /> ';
                }
            },
            ])

            ->add('background',ColorType::class, [
                'label' => 'Couleur de fond',
                'attr' => [
                    'class' => 'color-picker',
                    'data-hex' => 'true'
                ],
            ])

            ->add('color',ColorType::class, [
                'label' => 'Couleur du texte',
                'attr' => [
                    'class' => 'color-picker',
                    'data-hex' => 'true'
                ],
            ])

            ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
        ;
       
    }

    public static function getIntro(): ?string
    {
        return 'Cette page vous permet de personnaliser l’apparence de l’en-tête (header) de votre boutique.</br>
        - Choisissez un style d’en-tête en cliquant sur le modèle de votre choix.</br>
        - Définissez la couleur de fond de l’en-tête.</br>
        - Choisissez la couleur du texte affiché dans l’en-tête</br>
        - Une fois tous les champs remplis, cliquez sur "Enregistrer" pour enregistrer les modifications.
        ';
    }

}