<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ColorType;


class GeneralType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $alphabet = 'Aa Bb Cc Dd Ee Ff Gg Hh Ii Jj Kk Ll Mm Nn Oo Pp Qq Rr Ss Tt Uu Vv Ww Xx Yy Zz';
        $fontChoices = [
        // idéalement, utilise les noms exacts des familles comme *valeurs*
        'Lato' => 'Lato',
        'Poppins' => 'Poppins',
        'Roboto' => 'Roboto',
        'Raleway' => 'Raleway',
        'Montserrat' => 'Montserrat',
        'Comic Neue' => 'Comic Neue',
        'Courier Prime' => 'CourierPrime',
        'Nanum Brush Script' => 'NanumBrushScript',
        'Open Sans' => 'OpenSans',
        ];


        $builder
            ->add('theme', ChoiceType::class, [
                'choices' => [
                    'Thème 1' => 'theme1',
                    'Thème 2' => 'theme2',
                    'Thème 3' => 'theme3',
                ],
                'label' => 'Choisissez un style de thème',
                'expanded' => true, // Pour afficher les options sous forme de boutons radio
                'multiple' => false, // Un seul choix possible
                'attr' => [
                    'class' => 'theme-choice',
                ],

                'choice_label' => function($choice) {
                $baseUri = __PS_BASE_URI__; // Récupère l'URL de base de PrestaShop
                // Associe chaque option à une image
                switch ($choice) {
                    case 'theme1':
                        return '<img src="' . $baseUri . 'modules/lcvprestatheme/img/Theme1.png" alt="theme 1" />';
                    case 'theme2':
                        return '<img src="' . $baseUri . 'modules/lcvprestatheme/img/Theme1.png" alt="theme 1" /> ';
                    case 'theme3':
                        return '<img src="' . $baseUri . 'modules/lcvprestatheme/img/Theme1.png" alt="theme 1" /> ';
                }
            },
        
            'required' => true,
            ])

           

            ->add('primary', ColorType::class, [
                'label' => 'Couleur Principale',
                'attr' => [
                    'class' => 'color-picker',
                    'data-hex' => 'true'
                ],
            ])
            

            ->add('secondary',ColorType::class, [
                'label' => 'Couleur secondaire',
                'attr' => [
                    'class' => 'color-picker',
                    'data-hex' => 'true'
                ],
            ])


            ->add('fontTitle', ChoiceType::class, [
                'label' => 'Choisissez la police des Titres',
                'choices' => $fontChoices,
                'help' => $alphabet,
                'help_attr' => ['class' => 'fontTitleHelp'], // 👈 classes CSS pour le help
            ])

            ->add('fontText', ChoiceType::class, [
                'label' => 'Choisissez la police des Textes',
                'choices' => $fontChoices,
                'help' => $alphabet,

            ])

            ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
        ;
       
    }

    public static function getIntro(): ?string
    {
        return 'Cette page vous permet de personnaliser l’apparence globale de votre boutique.</br>
        - Choisissez un style de thème parmi les modèles proposés en cliquant sur le visuel souhaité.</br>
        - Définissez les couleurs principales de votre site (couleur principale et couleur secondaire)</br>
        - Sélectionnez la police d’écriture utilisée pour les titres et pour les textes</br>
        - Une fois tous les champs remplis, cliquez sur "Enregistrer" pour enregistrer les modifications.
        ';
    }

}