<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class CategoryParameterType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

            ->add('isVisible',SwitchType::class, [
                'required' => false,
                'label' => 'Activer la visibilité du bloc Visuels par catégorie',
            ])

            ->add('style', ChoiceType::class, [
                'choices' => [
                    'Block categorie 1' => 'categorie1',
                    'Block categorie 2' => 'categorie2',
                    'Block categorie 3' => 'categorie3',
                ],
                'label' => 'Choisissez un style de bloc Visuels par catégorie',
                'expanded' => true, // Pour afficher les options sous forme de boutons radio
                'multiple' => false, // Un seul choix possible
                'attr' => [
                    'class' => 'theme-choice',
                ],

                'choice_label' => function($choice) {
                $baseUri = __PS_BASE_URI__; // Récupère l'URL de base de PrestaShop
                // Associe chaque option à une image
                switch ($choice) {
                    case 'categorie1':
                        return '<img src="' . $baseUri . 'modules/lcvprestatheme/img/blockcategorie1.jpeg" alt="Block categorie 1" />';
                    case 'categorie2':
                        return '<img src="' . $baseUri . 'modules/lcvprestatheme/img/blockcategorie2.jpeg" alt="Block categorie 2" /> ';
                    case 'categorie3':
                        return '<img src="' . $baseUri . 'modules/lcvprestatheme/img/blockcategorie3.jpeg" alt="Block categorie 3" /> ';
                }
            },
        
            'required' => true,
            ])

            
            ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
        ;
       
    }


      public static function getIntro(): ?string
    {
        return 'Cette page permet de configurer le style des visuels par catégorie </br>
        - Cliquez sur le design de votre choix pour le sélectionner, puis cliquez sur Enregistrer.</br>
        - Si vous ne souhaitez pas afficher ce bloc, décochez l’option « Activer la visibilité du bloc Visuels par catégorie »</br>
        ';
    }

}