// Attend que le DOM soit complètement chargé avant d’exécuter le script
document.addEventListener('DOMContentLoaded', function () {

  // 🔗 Sélection des éléments du DOM pour la bannière et les blocs
  const banner = document.getElementById('cookie-banner'); // Récupère l’élément de la bannière
  const bannerContent = document.querySelector('.cookie-banner-content'); // Récupère le contenu de la bannière
  const customizeBlock = document.getElementById('cookie-customize'); // Récupère le bloc de personnalisation

  // 🔘 Boutons d’interaction utilisateur
  const customizeBtn = document.getElementById('customize'); // Bouton "Personnaliser"
  const returnBtn = document.getElementById('return'); // Bouton "Retour"
  const acceptAllBtn = document.getElementById('accept-all'); // Bouton "Tout accepter"
  const refuseAllBtn = document.getElementById('refuse-all'); // Bouton "Tout refuser"
  const savePrefsBtn = document.getElementById('save-preferences'); // Bouton "Enregistrer les préférences"
  

  const cookieMainBtn = document.getElementById('cookie-main-btn'); // Bouton flottant d’ouverture/fermeture de la bannière

  // Si aucun cookie de consentement n’est présent, on affiche la bannière
  if (!getCookie('rgpd_consent')) {
    banner.style.display = 'block'; // Affiche la bannière
  }

  // ⬇️ Gère le clic sur le bouton principal flottant
  cookieMainBtn?.addEventListener('click', () => {
    const isVisible = banner.style.display === 'block'; // Vérifie si la bannière est actuellement visible
    const img = cookieMainBtn.querySelector('img'); // Récupère l’image à l’intérieur du bouton

    if (isVisible) { // Si la bannière est visible
      banner.style.display = 'none'; // La masquer
      img.src = window.prestashop.urls.base_url + "modules/lcvprestatheme/img/cookie.png"; // Mettre l’icône cookie
    } else { // Sinon
      banner.style.display = 'block'; // Afficher la bannière
      img.src = window.prestashop.urls.base_url +"modules/lcvprestatheme/img/close.png"; // Mettre l’icône de fermeture
    }
  });

  // ⬇️ Gère le clic sur "Personnaliser"
  customizeBtn?.addEventListener('click', () => {
    applyConsentToUI();
    bannerContent.style.display = 'none'; // Masquer le contenu principal
    customizeBlock.style.display = 'block'; // Afficher les options personnalisées
    returnBtn.style.display = 'block'; // Afficher le bouton retour
    savePrefsBtn.style.display = 'block'; // Afficher le bouton enregistrer
    refuseAllBtn.style.display = 'none'; // Masquer le bouton "Tout refuser"
    customizeBtn.style.display = 'none'; // Masquer le bouton "Personnaliser"
  });

  // ⬇️ Gère le clic sur "Retour"
  returnBtn?.addEventListener('click', () => {
    customizeBlock.style.display = 'none'; // Masquer les options personnalisées
    bannerContent.style.display = 'block'; // Réafficher le contenu principal
    returnBtn.style.display = 'none'; // Masquer le bouton retour
    savePrefsBtn.style.display = 'none'; // Masquer le bouton enregistrer
    refuseAllBtn.style.display = 'block'; // Réafficher le bouton "Tout refuser"
    customizeBtn.style.display = 'block'; // Réafficher le bouton "Personnaliser"
  });

  // ⬇️ Gère le clic sur "Tout accepter"
  acceptAllBtn?.addEventListener('click', () => {
    const consent = {}; // Initialise un objet vide
    getAllCookieTypes().forEach(type => consent[type] = true); // Marque tous les types comme acceptés
    saveConsent(consent); // Enregistre le consentement
  });

  // ⬇️ Gère le clic sur "Tout refuser"
  refuseAllBtn?.addEventListener('click', () => {
    const consent = {}; // Initialise un objet vide
    getAllCookieTypes().forEach(type => consent[type] = false); // Marque tous les types comme refusés
    saveConsent(consent); // Enregistre le consentement
  });

  // ⬇️ Gère le clic sur "Enregistrer les préférences"
  savePrefsBtn?.addEventListener('click', () => {
    const consent = {}; // Initialise un objet vide
    document.querySelectorAll('[data-cookie-type]').forEach(input => { // Pour chaque élément avec type
      const type = input.dataset.cookieType; // Récupère le type de cookie
      consent[type] = input.checked; // Stocke l’état (coché ou non)
    });
    saveConsent(consent); // Enregistre le consentement
    customizeBlock.style.display = 'none'; // Masquer les options personnalisées
    bannerContent.style.display = 'block'; // Réafficher le contenu principal
    returnBtn.style.display = 'none'; // Masquer le bouton retour
    savePrefsBtn.style.display = 'none'; // Masquer le bouton enregistrer
    refuseAllBtn.style.display = 'block'; // Réafficher le bouton "Tout refuser"
    customizeBtn.style.display = 'block'; // Réafficher le bouton "Personnaliser"
  });

  // 🔁 Met à jour les switchs selon le consentement stocké
  function applyConsentToUI() {
    const consentRaw = getCookie('rgpd_consent');
    if (!consentRaw) return;

    try {
      const consent = JSON.parse(consentRaw);
      document.querySelectorAll('[data-cookie-type]').forEach(input => {
        const type = input.dataset.cookieType;
        if (typeof consent[type] !== 'undefined') {
          input.checked = consent[type]; // ✅ Met à jour l'état du switch
        }
      });
    } catch (e) {
      console.warn('Consentement invalide :', e);
    }
  }

  // 📂 Fonction d’enregistrement du consentement
  function saveConsent(consent) {
    setCookie('rgpd_consent', JSON.stringify(consent), 365); // Enregistre le cookie pendant 365 jours
    banner.style.display = 'none'; // Cache la bannière
    cookieMainBtn.style.display = 'block'; // Affiche le bouton flottant
    clearTracking(consent); // Supprime les cookies refusés
    loadTrackingScripts() // Charge des scripts de tracking si consentement
    const img = cookieMainBtn.querySelector('img'); // Récupère l’image à l’intérieur du bouton
    img.src = window.prestashop.urls.base_url + "modules/lcvprestatheme/img/cookie.png"; // Met l’icône cookie
  }

  // 🔍 Fonction pour récupérer tous les types de cookies uniques
  function getAllCookieTypes() {
    const types = new Set(); // Crée un Set pour éviter les doublons
    document.querySelectorAll('[data-cookie-type]').forEach(input => {
      types.add(input.dataset.cookieType); // Ajoute chaque type dans le Set
    });
    return [...types]; // Retourne un tableau avec les types
  }

  // 🔐 Fonction pour enregistrer un cookie
  function setCookie(name, value, days) {
    const expires = new Date(Date.now() + days * 864e5).toUTCString(); // Calcule la date d’expiration
    document.cookie = `${name}=${encodeURIComponent(value)}; expires=${expires}; path=/`; // Définit le cookie
  }

  // 🔓 Fonction pour lire un cookie
  function getCookie(name) {
    const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)')); // Cherche le cookie dans document.cookie
    return match ? decodeURIComponent(match[2]) : null; // Retourne la valeur ou null
  }

  // 🧹 Supprime les cookies de tracking si le consentement est refusé
function clearTracking(consent) {
  // 🎯 Motifs pour identifier les cookies de Google Analytics et publicité
  const analyticsPatterns = [/^_ga$/, /^_ga_/, /^_gat/, /^_gid$/]; // Google Analytics
  const adsPatterns = [/^_gcl_au$/, /^IDE$/, /^test_cookie$/, /^NID$/, /^__Secure-ENID$/, /^_fbp$/, /^_fbc$/]; // Publicité (Google Ads, Facebook Pixel, etc.)

  // 🧾 Récupération de tous les cookies présents dans le navigateur
  const allCookies = document.cookie.split(';').map(c => c.trim().split('=')[0]);

  // 🔁 Fonction utilitaire pour supprimer les cookies correspondant à une liste de motifs
  const removeCookiesByPatterns = (patterns) => {
    allCookies.forEach(name => {
      if (patterns.some(p => p.test(name))) deleteCookie(name);
    });
  };

  // 🧯 Fonction pour désactiver Facebook Pixel si chargé
  const disableFacebookPixel = () => {
    if (window.fbPixelScriptLoaded) {
      window.fbq = function () {}; // Neutralise la fonction fbq
      document.querySelectorAll('script[src*="fbevents.js"]').forEach(el => el.remove()); // Supprime les scripts Facebook Pixel
      window.fbPixelScriptLoaded = false;
    }
  };

  // 📉 Cas : l'utilisateur refuse les analytics mais accepte la publicité
  if (!consent.analytics && consent.ads) {
    removeCookiesByPatterns(analyticsPatterns); // Supprime cookies analytics
  }

  // 📢 Cas : l'utilisateur refuse la publicité mais accepte les analytics
  if (!consent.ads && consent.analytics) {
    removeCookiesByPatterns(adsPatterns); // Supprime cookies publicitaires
    disableFacebookPixel();               // Désactive le pixel Facebook
  }

  // 🚫 Cas : l'utilisateur refuse tout (ni analytics, ni publicité)
  if (!consent.analytics && !consent.ads) {
    removeCookiesByPatterns([...analyticsPatterns, ...adsPatterns]); // Supprime tous les cookies de tracking

    disableFacebookPixel(); // Désactive le pixel Facebook
  }

  // 🔄 Mise à jour du consentement dans Google Tag
  if (typeof gtag === 'function') {
    gtag('consent', 'update', {
      ad_storage: consent.ads ? 'granted' : 'denied',
      analytics_storage: consent.analytics ? 'granted' : 'denied'
    });
  }
}

// 🗑️ Fonction pour supprimer un cookie (y compris sur les domaines parents)
function deleteCookie(name) {
  // Supprime le cookie courant
  document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/`;

  // 🔁 Supprime le cookie sur les domaines parents possibles (ex. : .example.com)
  const parts = window.location.hostname.split('.');
  for (let i = 0; i < parts.length - 1; i++) {
    const domain = '.' + parts.slice(i).join('.');
    document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/; domain=${domain};`;
  }
}



  function loadTrackingScripts() {
    const consentRaw = getCookie('rgpd_consent');
    if (!consentRaw) return;

    try {
      const consent = JSON.parse(consentRaw);
      if (typeof gtag_id !== 'undefined' && (consent.analytics || consent.ads)) {
        console.log('Chargement de Google Tag Manager');
        loadGoogleTagManager(gtag_id, consent);
      }

      if (typeof fb_id !== 'undefined' && consent.ads) {
        console.log('Chargement de Facebook Pixel');
        loadFacebookPixel(fb_id);
      }

    } catch (e) {
      console.warn('Erreur RGPD tracking :', e);
    }
  }



  function loadGoogleTagManager(id) {
  if (window.gtmScriptLoaded) return;
  window.gtmScriptLoaded = true;

  const script = document.createElement('script');
  script.innerHTML = `(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;f.parentNode.insertBefore(j,f);
  })(window,document,'script','dataLayer','${id}');`;
  document.head.appendChild(script);
}

function loadFacebookPixel(id) {
  if (window.fbPixelScriptLoaded) return;
  window.fbPixelScriptLoaded = true;

  const script = document.createElement('script');
  script.innerHTML = `!function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src=v;s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script',
  'https://connect.facebook.net/en_US/fbevents.js');
  fbq('init', '${id}');
  fbq('track', 'PageView');`;
  document.head.appendChild(script);
}

applyConsentToUI()
loadTrackingScripts();
clearTracking(JSON.parse(getCookie('rgpd_consent'))); // Nettoie les cookies de tracking au chargement

}); // Fin de DOMContentLoaded
