<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;


class TrackingType  extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder


         ->add('gtag', TextType::class, [
            'label' => 'Google Tag Manager ID',
            'empty_data' => '',
            'required' => false,
            'attr' => [
                'placeholder' => 'GTM-XXXXXX',
            ]
        ])


        ->add('fbPixel', TextType::class, [
            'label' => 'Facebook Pixel ID',
            'empty_data' => '',
            'required' => false,
            'attr' => [
                'placeholder' => 'XXXXXXXXXXXXXXX',
            ]
            
        ])
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }


     public static function getIntro(): ?string
    {
        return 'Cette page vous permet d’ajouter des outils de suivi pour analyser le comportement des visiteurs sur votre boutique.</br>
        - Google Tag Manager ID : permet d’intégrer des balises de suivi (Google Analytics, conversions, remarketing, etc.) via la plateforme GTM.</br>
        - Facebook Pixel ID : permet de suivre les conversions et d’optimiser vos campagnes publicitaires sur Facebook.</br><br>

        Ces outils sont essentiels pour mesurer la performance de votre site et adapter votre stratégie marketing.
        ';
    }


}