<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;


class ResauxType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'required' => false,
            'label' => 'Activer la visibilité ',
        ])

        ->add('image', FileType::class ,[
            'label' => 'logo du reseaux',
            'mapped' => false, // Important si ce champ n'est pas lié directement à l'entité
            'required' => false,
        ])

        ->add('url', UrlType::class, [
            'label' => 'Url',
            'empty_data' => '',
            'required' => false,
              "attr"=>[
                "placeholder" => "Url de votre résaux sociaux"
            ]
        ])

        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
        ])
        ;
       
    }

    public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }

      public static function getIntro(): ?string
    {
        return 'Cette page vous permet d’ajouter des liens personnalisés vers vos réseaux sociaux, accompagnés de leurs logos.</br>
        - Activez ou désactivez l’affichage de ce bloc avec le bouton "Activer la visibilité".</br>
        - Téléversez le logo du réseau social à l’aide du bouton "Choisir un(des) fichier(s)".</br>
        - Indiquez l’URL du profil ou de la page correspondante (ex. : https://facebook.com/votrepage).</br></br>
        
        Voici un lien pour accéder aux icônes : <a style="color:black; font-weight:700;" href="https://www.flaticon.com">ICI</a> exportez vos icônes en format 64px maximum pour garantir un affichage optimal
        ';
    }

}