<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use PrestaShop\Module\LCVPrestaTheme\Forms\ImageMediaType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class MenuMediaType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'label' => 'Activer la visibilité',
            'required' => false,
        ])
        ->add('medias', CollectionType::class, [
        'entry_type' => ImageMediaType::class,
         'entry_options' => [
            'parent_id' => $options['parent_id'], // 🔥 Ici on passe l'option
            'label' => false
        ],
        'allow_add' => true,
        'allow_delete' => true,
        'by_reference' => false,
        'prototype' => true,
        'label' => false,
        ])
         ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                    'data-hex' => 'true'
                ],
            ]);
    }


    public function configureOptions(\Symfony\Component\OptionsResolver\OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'parent_id' => null, // attendue depuis CreateConfigurationForm() via options
        ]);
    }

       public static function getIntro(): ?string
    {
        return 'Cette page vous permet d’ajouter un média personnalisé  à votre sous-menu.</br>
        - Ajoutez un titre (facultatif) : laissez vide si vous ne souhaitez pas l\'afficher.</br>
        - Facultativement, indiquez une URL de redirection : si elle est renseignée, le clic sur l’image redirigera vos clients vers cette adresse.</br>
        - Sélectionnez une image en cliquant sur "Choisir un(des) fichier(s)".</br>
        - Utilisez le bouton "Ajouter un média" pour ajouter plusieurs médias à votre sous-menu.</br>
        - Utilisez le bouton "Supprimer" pour retirer un média si nécessaire.</br></br>

        Vous pouvez ajouter jusqu’à 3 médias par colonne de sous-menu. Chaque média peut servir à mettre en avant une page, une catégorie ou une promotion visuelle.
        ';
    }

}