<?php
namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;

use PrestaShopBundle\Form\Admin\Type\FormattedTextareaType;

class CssType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
        ->add('css', FormattedTextareaType::class, [
            'label' => 'ajouter votre css personnalisé ici',
            'attr' => [
                'class' => 'prestashop-textarea', // Ajout d'une classe pour l'initialisation de TinyMCE
                'style' => 'width: 100%; height: 100vh;', // Taille du textarea
            ],
            'empty_data' => '',
            'required' => false,
        ])

        ->add('save', SubmitType::class , [
            'label' => 'Enregistrer',
            'attr' => [
                'class' => 'btn btn-primary',
            ],
        ]);

    }
}