{extends file=$layout}

{block name='content'}
  <section id="main">

    {block name='brand_header'}
      <div class="brand-index">
        {assign var='letters' value=['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z']}
        {foreach from=$letters item=letter}
          <a href="#brand-{strtolower($letter)}">{$letter}</a>
        {/foreach}
      </div>
    {/block}

    {block name='brand_list'}
      {assign var='brands_by_letter' value=[]}
      {foreach from=$brands item=brand}
        {assign var='firstLetter' value=$brand.name|substr:0:1|upper}
        {if !isset($brands_by_letter.$firstLetter)}
          {assign var=tmp value=[]}
          {assign var='brands_by_letter' value=$brands_by_letter|@array_merge:[$firstLetter => $tmp]}
        {/if}
        {assign var=tmp value=$brands_by_letter.$firstLetter}
        {append var=tmp value=$brand}
        {assign var='brands_by_letter' value=$brands_by_letter|@array_merge:[$firstLetter => $tmp]}
      {/foreach}

      {foreach from=$brands_by_letter key=letter item=brands}
        <div id="brand-{strtolower($letter)}" class="brand-group">
          <h2>{$letter}</h2>
          <ul class="brand-list">
            {foreach from=$brands item=brand}
              {include file='catalog/_partials/miniatures/brand.tpl' brand=$brand}
            {/foreach}
          </ul>
        </div>
      {/foreach}
    {/block}

  </section>
{/block}
