
{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<span class="product-image">
    <img src="{$product.cover.bySize.cart_default.url}" alt="{$product.name}" class="img-fluid">
</span>
<div class="product-infos">
    <div>
        <a class="product-name" href="{$product.url}">{$product.name|truncate:20:'...'}</a>
        <div class="product-line-info">
            {foreach from=$product.attributes key="attribute" item="value"}
                <span class="value">{$value}</span>
            {/foreach}
        </div>
        <span class="product-price">{$product.price}</span>
    </div>
    <div class="product-qty">
        <div class="product-qty-container">
            <div class="quantity-button quantity-down">–</div>
            <input
            class="product-qty-input js-cart-line-product-quantity"
            data-down-url="{$product.down_quantity_url}"
            data-up-url="{$product.up_quantity_url}"
            data-update-url="{$product.update_quantity_url}"
            data-product-id="{$product.id_product}"
            type="text"
            step="1"
            value="{$product.quantity}"
            name="product-qty-spin"
            min="{$product.minimal_quantity}"
            />
            <div class="quantity-button quantity-up">+</div>
        </div>
        <div class="product-remove">
            <a
            class                       = "remove-from-cart"s
            rel                         = "nofollow"
            href                        = "{$product.remove_from_cart_url}"
            data-link-action            = "delete-from-cart"
            title                       = "{l s='remove from cart' d='Shop.Theme.Actions'}"
            > 
                {if !isset($product.is_gift) || !$product.is_gift}
                    <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e3e3e3"><path d="M280-120q-33 0-56.5-23.5T200-200v-520h-40v-80h200v-40h240v40h200v80h-40v520q0 33-23.5 56.5T680-120H280Zm400-600H280v520h400v-520ZM360-280h80v-360h-80v360Zm160 0h80v-360h-80v360ZM280-720v520-520Z"/></svg>
                {/if}
            </a>
        </div>
    </div>
</div>