<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class SliderType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'label' => 'Activer la visibilité ',
            'required' => false,
        ])

        ->add('textPosition', ChoiceType::class, [
            'choices' => [
                'Gauche' => 'left',
                'Centre' => 'center',
                'Droite' => 'right',
            ],
            'label' => 'Choisissez la position du texte',
            'expanded' => true, // Pour afficher les options sous forme de boutons radio
            'multiple' => false, // Un seul choix possible
            'attr' => [
                'class' => 'theme-choice',
            ],
        ])
        
        ->add('title', TextType::class,[
            'label'    => 'Titre',
            'required' => false,
            'empty_data' => '',
            'help' => 'Laisser vide pour ne pas afficher de titre',
            "attr"=>[
                "placeholder" => "Ajouter un titre du slider"
            ]
        ])

        ->add('subTitle', TextType::class,[
            'label'    => 'Sous titre',
            'required' => false,
            'empty_data' => '',
            'help' => 'Laisser vide pour ne pas afficher de sous titre',
            "attr"=>[
                "placeholder" => "Ajouter un sous titre du slider"
            ]
        ])
       
        ->add('image', FileType::class ,[
            'label' => 'Image du slider',
            'mapped' => false, // Important si ce champ n'est pas lié directement à l'entité
            'required' => false,
        ])

        ->add('button', TextType::class ,[
            'label'    => 'Bouton',
            'required' => false,
            'empty_data' => '',
            'help' => 'Laisser vide pour ne pas afficher de bouton',
            "attr"=>[
                "placeholder" => "Ajouter un texte du bouton"
            ]
        ])

        ->add('url', TextType::class ,[
                'label'    => 'Lien',
                'empty_data' => '',
            "attr"=>[
                "placeholder" => "Url de la page souhaitée"
            ]
        ])
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }

      public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }

       public static function getIntro(): ?string
    {
        return 'Cette page vous permet de personnaliser un slide de votre diaporama d’accueil.</br>
        - Activez ou désactivez l’affichage de ce slide avec le bouton "Activer la visibilité".</br>
        - Choisissez la position du texte sur l’image (gauche, centre ou droite).</br>
        - Ajoutez un titre, un sous-titre (facultatif), et une image pour illustrer le slide.</br>
        - Ajoutez un texte de bouton d’action (facultatif), comme "En savoir plus".<br>
        - Définissez un lien de redirection vers la page de votre choix (produit, catégorie, offre, etc.).<br>
        - Si vous ne souhaitez pas afficher de titre, de sous-titre ou de bouton, laissez ces champs vides.</br>
        ';
    }

}