<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class CategoryType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

        ->add('isVisible',SwitchType::class, [
            'required' => false,
            'label' => 'Activer la visibilité',
        ])
        
        ->add('title', TextType::class,[
            'label'    => 'Titre',
            'empty_data' => '',
            "attr"=>[
                "placeholder" => "Ajouter un titre de la catégorie"
            ]
         ])


         ->add('subTitle', TextType::class,[
            'label'    => 'sous-titre',
            'required' => false,
            'empty_data' => '',
            "attr"=>[
                "placeholder" => "sous titre de la catégorie"
            ]
         ])
       
        ->add('image', FileType::class ,[
            'label' => 'Image de la catégorie',
            'mapped' => false, // Important si ce champ n'est pas lié directement à l'entité
            'required' => false,
        ])

        ->add('url', TextType::class ,[
                'label'    => 'url',
                'empty_data' => '',
              "attr"=>[
                "placeholder" => "Url de la categorie souhaitée"
            ]
        ])
       
        ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
    ;
    }

      public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }

        public static function getIntro(): ?string
    {
        return 'Cette page vous permet d’ajouter un visuel personnalisé pour chaque catégorie </br>
        - Renseignez un titre pour la catégorie. Le sous-titre est facultatif et peut être laissé vide.</br>
        - Ajoutez une image représentative de la catégorie en cliquant sur "Choisir un(des) fichier(s)"</br>
        - Facultativement, indiquez une URL de redirection : en cliquant sur l’image, vos clients seront redirigés vers cette adresse.</br>
        - Une fois tous les champs remplis, cliquez sur "Enregistrer" pour enregistrer les modifications.
        ';
    }

}