// Slider produit 
document.addEventListener("DOMContentLoaded", function () {
        // Sélectionne tous les éléments avec la classe "slider-wrapper" (conteneurs des sliders)
        const sliders = document.querySelectorAll(".slider-wrapper");

        // Pour chaque slider trouvé sur la page
        sliders.forEach(wrapper => {
            // Récupère l'identifiant du slider via l'attribut data-slider
            const sliderId = wrapper.dataset.slider;
    
            // Sélectionne la piste de slide (le conteneur qui contient les cartes produit)
            const track = wrapper.querySelector(".slider-track");
    
            // Sélectionne toutes les cartes produit dans ce slider
            const cards = wrapper.querySelectorAll(".product-card");
    
            // Sélectionne les boutons précédent et suivant correspondant à ce slider
            const prevBtn = document.querySelector(`.prevBtn[data-slider="${sliderId}"]`);
            const nextBtn = document.querySelector(`.nextBtn[data-slider="${sliderId}"]`);
    
            // Détecte si l'appareil est tactile (mobile ou tablette)
            let isTouchDevice = 'ontouchstart' in window || navigator.maxTouchPoints > 0;
    
            // Variables de contrôle pour le glissement souris ou tactile
            let isDown = false;        // l'utilisateur est-il en train de "cliquer/glisser" ?
            let startX;                // position de départ du curseur/toucher
            let scrollStart;           // position initiale du scroll
            let moved = false;         // l'utilisateur a-t-il vraiment déplacé la souris ?
    
            // Variables pour le défilement avec les flèches
            let currentPosition = 0;                 // position actuelle du scroll
            const cardWidth = cards[0].offsetWidth;  // largeur d'une carte (supposée identique)
    
            // --- Boutons précédent / suivant ---
            if (prevBtn && nextBtn) {
                // Clic sur le bouton précédent
                prevBtn.addEventListener("click", () => {
                    // Décale vers la gauche, sans dépasser le début
                    currentPosition = Math.max(currentPosition - cardWidth, 0);
                    wrapper.scrollTo({ left: currentPosition, behavior: "smooth" });
                });
    
                // Clic sur le bouton suivant
                nextBtn.addEventListener("click", () => {
                    // Décale vers la droite, sans dépasser la fin du contenu
                    const maxScroll = track.scrollWidth - wrapper.clientWidth;
                    currentPosition = Math.min(currentPosition + cardWidth, maxScroll);
                    wrapper.scrollTo({ left: currentPosition, behavior: "smooth" });
                });
            }
    
            // --- Glissement tactile (mobile/tablette uniquement) ---
            if (isTouchDevice) {
                wrapper.addEventListener("touchstart", (e) => {
                    // Début du glissement : on enregistre la position de départ
                    isDown = true;
                    startX = e.touches[0].pageX;
                    scrollStart = wrapper.scrollLeft;
                });
    
                wrapper.addEventListener("touchend", () => {
                    // Fin du glissement
                    isDown = false;
                });
    
                wrapper.addEventListener("touchmove", (e) => {
                    // Pendant le glissement, on met à jour le scroll
                    if (!isDown) return;
                    const walk = (e.touches[0].pageX - startX) * 1.5;
                    wrapper.scrollLeft = scrollStart - walk;
                });
    
            } else {
                // --- Glissement souris (ordinateur uniquement) ---
                wrapper.addEventListener("mousedown", (e) => {
                    // Début du clic : enregistre position initiale
                    isDown = true;
                    startX = e.pageX;
                    scrollStart = wrapper.scrollLeft;
                    moved = false; // Réinitialise le statut de mouvement
                    wrapper.classList.add("dragging"); // Classe CSS optionnelle pour effet visuel
                });
    
                document.addEventListener("mouseup", () => {
                    // Fin du clic/glissement
                    if (isDown && moved) {
                        // Si mouvement réel, on peut faire une action ici (facultatif)
                    }
                    isDown = false;
                    wrapper.classList.remove("dragging"); // Retire effet visuel
                });
    
                document.addEventListener("mousemove", (e) => {
                    // Si on ne tient pas le clic, on ne fait rien
                    if (!isDown) return;
    
                    // Calcul de la distance parcourue
                    const walk = (e.pageX - startX) * 1.5;
    
                    // Si l'utilisateur a déplacé suffisamment la souris, on considère que c'est un glissement
                    if (Math.abs(e.pageX - startX) > 5) {
                        moved = true;
                        wrapper.scrollLeft = scrollStart - walk;
                    }
                });
            }
        });
});
