<?php

namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\ColorType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class TopBandeauParameterType extends AbstractType{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

            ->add('isVisible',SwitchType::class, [
                'required' => false,
                'label' => 'Activer la visibilité du bloc Bandeau',
            ])

            ->add('background',ColorType::class, [
                'label' => 'Couleur de fond',
                'attr' => [
                    'class' => 'color-picker',
                    'data-hex' => 'true'
                ],
            ])

            ->add('color',ColorType::class, [
                'label' => 'Couleur du texte',
                'attr' => [
                    'class' => 'color-picker',
                    'data-hex' => 'true'
                ],
            ])

            
            ->add('save', SubmitType::class , [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary',
                ],
            ])
        ;
       
    }

       public static function getIntro(): ?string
    {
        return 'Cette page vous permet de personnaliser le bandeau informatif situé en haut de votre site (ex. : message promotionnel, info livraison, etc.).</br>
        - Activer ou désactiver l’affichage du bloc avec l’interrupteur dédié.</br>
        - Définir la couleur de fond du bandeau.</br>
        - Choisir la couleur du texte affiché à l’intérieur du bandeau.</br>
        ';
    }

}