<?php
namespace PrestaShop\Module\LCVPrestaTheme\Forms;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;

class ImageMediaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder

           ->add('parent_id', HiddenType::class, [
                'data' => $options['parent_id'], // valeur injectée depuis le contrôleur via options
            ])

        
            ->add('title', TextType::class, [
                'label' => 'Titre',
                'required' => false,
                'help' => 'laisser vide pour ne pas afficher de titre',
                'empty_data' => '',
                 "attr"=>[
                "placeholder" => "Ajouter un titre"
                ]
            ])
            ->add('url', TextType::class, [
                'label' => 'Url',
                'required' => false,
                'empty_data' => '',
                  "attr"=>[
                "placeholder" => "Url de la page souhaitée"
            ]
            ])
            ->add('image', FileType::class, [
                'label' => 'Image',
                'required' => false,
                'mapped' => false,
            ]);
    }

     public function configureOptions(\Symfony\Component\OptionsResolver\OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'parent_id' => null, // attendue depuis CreateConfigurationForm() via options
        ]);
    }
    
    public function getName()
    {
        return '';
    }
    
    public function getBlockPrefix()
    {
        return '';
    }
}