<?php
namespace PrestaShop\Module\LCVPrestaTheme\Config;

use Category;
use Context;
use Link;

class ConfigMenuChild
{
    /**
     * ID du parent dans lequel on va injecter les enfants
     *
     * @var string
     */
    public $parent_id;

    /**
     * Liste des enfants à injecter
     *
     * @var array
     */
    public $child = [];

    /**
     * visibilité du bloc 
     *
     * @var bool
     */
    public $isVisible = true;



    /**
     * Injecte directement une colonne d'enfants dans le bon parent
    */
    public function injectInto(array &$parents, ?int $columnIndex = null , $action): void
    {
        $config = ConfigTheme::load();

        // On parcourt tous les menus parents pour trouver celui correspondant à l'injection
        foreach ($parents as &$parent) {
            // Vérifie si le parent est celui ciblé par l'injection
            if ($parent->menu['id'] == $this->parent_id) {

                 $column = $this->buildTree($columnIndex);

                if($action === 'delete'){
                    // Si l'action est de supprimer, on supprime la colonne
                    if ($columnIndex !== null && isset($parent->menu['columns'][$columnIndex])) {
                        unset($parent->menu['columns'][$columnIndex]);
                    }
                    // On sort de la boucle après la suppression
                    break;
                }

                if($action === 'edit'){
                 
                  
                  if ($columnIndex !== null && isset($parent->menu['columns'][$columnIndex])) {
                    
                        // recuperation de l'index source de la colonne existante
                        $oldColumn = $parent->menu['columns'][$columnIndex];
                        $oldSourceIndex = $oldColumn['sourceIndex'] ?? 0;
                        
                        // Remplace entièrement la colonne existante
                        $parent->menu['columns'][$columnIndex] = [
                            'columnIndex' => $columnIndex,
                            'blocks' => $column,
                            'type' => 'category',
                            'sourceIndex' =>  $oldSourceIndex ,
                            'isVisible' => $this->isVisible
                        ];
                    }
                    break;
                }


                if($action == "add"){
                    
                     // On construit la structure des blocs (catégories + enfants) pour cette colonne
                    $existingIndexes = array_keys($parent->menu['columns'] ?? []);
                    $existingIndexes = array_map('intval', $existingIndexes);
                    $nextIndex = empty($existingIndexes) ? 1 : max($existingIndexes) + 1;
                    

                    // Sinon, ajout de la colonne à la fin du tableau
                   $parent->menu['columns'][$nextIndex] = [
                        'columnIndex' => $nextIndex,
                        'blocks' => $column,
                        'type' => 'category',
                        'sourceIndex' => count($config->configMenuChild),
                        'isVisible' => $this->isVisible
                    ];
                    // Une fois la colonne injectée, on sort de la boucle
                    break;
                }

              
            }
        }
    }


    /**
     * Construit l’arbre d’enfants à partir de $this->child
     */
    private function buildTree(): array
    {
        // Récupère l'identifiant de la langue courante (utilisé pour charger les noms des catégories)
        $id_lang = Context::getContext()->language->id;

        // Initialise un objet Link pour générer les URLs des catégories
        $link = new Link();

        // Tableau qui contiendra toutes les catégories chargées, indexées par leur ID
        $categories = [];

        // Parcourt tous les IDs de catégories enfants définis dans $this->child
        foreach ($this->child as $id) {
            // Charge l'objet Category en fonction de l'ID et de la langue
            $cat = new Category((int) $id, $id_lang);

            // Stocke les informations de la catégorie dans un tableau
            $categories[$id] = [
                'id_parent' => $cat->id_parent, // ID du parent 
                'id' => $cat->id,               // ID de la catégorie
                'name' => $cat->name,           // Nom de la catégorie dans la langue courante
                'url' => $link->getCategoryLink($cat), // URL de la catégorie
                'children' => [],               // Tableau des enfants 
            ];
        }

        // Tableau final qui contiendra les catégories racines (celles sans parent connu dans $categories)
        $tree = [];

        // Reconstitue l’arbre de catégories 
        foreach ($categories as $id => &$cat) {
            // Si le parent est dans la liste, on ajoute cette catégorie comme enfant
            if (isset($categories[$cat['id_parent']])) {
                $categories[$cat['id_parent']]['children'][] = &$cat;
            } else {
                // Sinon, c’est une racine : on l’ajoute directement dans $tree
                $tree[] = &$cat;
            }
        }

        // Retourne l’arbre complet (chaque nœud pouvant contenir ses enfants récursivement)
        return $tree;
    }

    
}