$(document).ready(function () {
   // Si on est sur mobile/tablette (<= 768px)
    if ($(window).width() <= 768) {
    // Si les éléments existent, on déplace le widget de recherche dans le menu mobile
    if ($('#_mobile_search').length && $('#search_widget').length) {
        $('#_mobile_search').append($('#search_widget'));
    }
    $('#top-menu').detach().appendTo('#mobile_top_menu_wrapper');
    }

    // Au clic sur l'icône de recherche
    $('.search-icon').on('click', function (e) {
        e.stopPropagation(); // Empêche le clic de remonter au document
        $('.search-icon').toggleClass('search-position'); 
        $('#search_widget').toggleClass('search-width');
        $('.search-input').toggleClass('search-active'); 
    });

    // Clic à l'intérieur de la search input : ne fait rien (évite de fermer trop vite)
    $('.search-input').on('click', function (e) {
        e.stopPropagation();
    });

    // Clic en dehors : referme uniquement si la search bar est ouverte
    $(document).on('click', function () {
        if ($('.search-input').hasClass('search-active')) {
            $('.search-input').removeClass('search-active');
            $('#search_widget').removeClass('search-width');
            $('.search-icon').removeClass('search-position');
        }
    }); 

});

// Ouvre les sous menu des liens en version mobile
document.addEventListener("DOMContentLoaded", function () {
    const menuWrapper = document.querySelector('#mobile_top_menu_wrapper');
    
    if (!menuWrapper) return;
  
    // Écoute les clics sur toute la zone du menu mobile
    menuWrapper.addEventListener('click', function (e) {
      // Si on a cliqué sur une icône "add"
      if (e.target && e.target.classList.contains('add')) {
        const menuItem = e.target.closest('.menu-item');
        if (menuItem) {
          // Toggle class open
          menuItem.classList.toggle('open');
        }
      }
    });
});

//Ajout de la class header-top pour changer le background du header pour ne pas qu'il soit tout le temps transparent
document.addEventListener("DOMContentLoaded", function () {
    // Sélection des éléments nécessaires
  let header = document.querySelector(".header-top");
  if (header) { //controle de l'existance de la variable
    window.addEventListener("scroll", function () {
        if (window.scrollY > 50) { //Ajout de la class après un scroll de 50px
            header.classList.add("scrolled");
        } else {
            header.classList.remove("scrolled");
        }
    });
  }

});

//Ajout de la class not-above pour ne pas avoir le header par dessus le slider
document.addEventListener("DOMContentLoaded", function () {
  // Sélection des éléments nécessaires
  let header = document.querySelector(".not-above");
  if (header) { //controle de l'existance de la variable
    window.addEventListener("scroll", function () {
        if (window.scrollY > 1) { //Ajout de la class après un scroll de 1px
            header.classList.add("fixed-header");
        } else {
            header.classList.remove("fixed-header");
        }
    });
  }
});

//scroll to top
document.addEventListener("DOMContentLoaded", function () {
  // Sélection des éléments nécessaires
  let scrollToTop = document.getElementById("scrollToTop");

  if (scrollToTop) { //controle de l'existance de la variable
    window.addEventListener("scroll", function () {
      if (window.scrollY > 100) { //affichage du bouton après un scroll de 100px
        scrollToTop.classList.add("show");
      } else {
        scrollToTop.classList.remove("show");
      }
    });

    scrollToTop.addEventListener("click", function () {
      window.scrollTo({ top: 0, behavior: "smooth" });
    });
  }
});

// Bandeau top 
document.addEventListener("DOMContentLoaded", function () {
       // Récupère tous les éléments ayant la classe "bandeau-item"
       const items = document.querySelectorAll(".bandeau-item");

       // Durée du fondu en millisecondes (1s)
       const fadeTime = 1000;
   
       // Durée d'affichage de chaque bandeau (5s)
       const displayTime = 5000;
   
       // Index de l'élément actuellement affiché
       let currentIndex = 0;
   
       // Si aucun élément n'est trouvé, on arrête l'exécution
       if (items.length === 0) return;
   
       // Fonction pour activer un élément (le rendre visible)
       const activateItem = (index) => {
           items[index].classList.add("active");      // Ajoute la classe "active" (utile pour CSS si besoin)
           items[index].style.opacity = "1";          // Rend l'élément totalement visible
       };
   
       // Fonction pour désactiver un élément (le cacher)
       const deactivateItem = (index) => {
           items[index].style.opacity = "0";          // Rend l'élément invisible par fondu
   
           // Supprime la classe "active" après le temps du fondu
           setTimeout(() => {
               items[index].classList.remove("active");
           }, fadeTime);
       };
   
       // Fonction principale : affiche l'élément suivant dans la liste
       const showNextItem = () => {
           // Calcule l'index suivant (boucle infinie grâce au modulo)
           const nextIndex = (currentIndex + 1) % items.length;
   
           // Cache l'élément actuel
           deactivateItem(currentIndex);
   
           // Affiche le prochain élément
           activateItem(nextIndex);
   
           // Met à jour l'index courant
           currentIndex = nextIndex;
       };
   
       // Affiche le premier élément dès le chargement
       activateItem(currentIndex);
   
       // Lance un intervalle qui affiche l'élément suivant toutes les X secondes
       setInterval(showNextItem, displayTime);
}); 









  
  
  
  
  








