<?php
if (!defined('_PS_VERSION_'))
    exit;	

/**
 * Supprime un répertoire et tout son contenu
 * 
 */
function deleteDirectory($dir) {
    // Vérifie si le répertoire existe
    if (!file_exists($dir)) {
        return false;
    }

    // Vérifie si c'est bien un répertoire
    if (!is_dir($dir)) {
        return false;
    }

    // Parcourt tous les fichiers et sous-répertoires
    $items = array_diff(scandir($dir), ['.', '..']);
    foreach ($items as $item) {
        $path = $dir . DIRECTORY_SEPARATOR . $item;

        // Si c'est un répertoire, on appelle la fonction récursivement
        if (is_dir($path)) {
            deleteDirectory($path);
        } else {
            // Sinon, on supprime le fichier
            unlink($path);
        }
    }

    // Enfin, on supprime le répertoire vide
    return rmdir($dir);
}

/**
 * Cette fonction se contente de remplacer les binaires du modules
 * par ceux qui sont actuellement dans update/latest/
 */
function upgrade_module($module)
{    
    try
    {        
        $moduleDir = $module->getLocalPath();
        // On supprime le / terminal
        if (substr($moduleDir, -1) == '/')
            $moduleDir = substr($moduleDir, 0, -1);

        // On va remplacer le contenu du répertoire du module par celui de l'archive
        $updateDir = $moduleDir . '/updates/latest/'.$module->name.'/';
        if (!file_exists($updateDir))
            throw new Exception("Impossible de trouver le répertoire de mise à jour du module");
        
        // On supprime le répertoire backup
        deleteDirectory($moduleDir . '.backup');

        // On renomme le répertoire du module en .backup
        if (!rename($moduleDir, $moduleDir . '.backup'))
            throw new Exception("Impossible de réaliser le backup du module !");

        // Puis on copie le répertoire de mise à jour à la place du répertoire du module
        if (!rename($moduleDir . '.backup/updates/latest/'.$module->name, $moduleDir))
            throw new Exception("Impossible d'installer la mise à jour !");

        // Si on arrive là, c'est que c'est bon, on nettoie
        // On supprime le répertoire backup
        deleteDirectory($moduleDir . '.backup');
    }
    catch (Exception $ex)
    {
        // On log l'erreur
        PrestaShopLogger::addLog('LCVPrestaConnector : Erreur lors de la mise à jour du module : '.$ex->getMessage(), 3);
        
        return false;
    }
    
    return true;
 }
