<?php
namespace PrestaShop\Module\LCVPrestaConnector\Models;

/**
 * Objet d'interface contenant la définition d'un produit
 */
class AttributeRef extends SanitizedObject
{
    /**
     * Identifiant de l'attribut
     */
    public string $id;

    /**
     * Nom de l'attribut
     */
    public string $name;

    /**
     * Nouvel attribut
     * 
     * @param string $id Identifiant de l'attribut
     * @param string $name Nom
     */
    public function __construct(
        string $id,
        ?string $name = null
        )
    {
        $this->id = $id;
        if ($name === null) {
            $name = $id;    // Si le nom est null, alors c'est le même que l'id
        }
        $this->name = $name;
    }

    /**
     * Nettoyage de la donnée sur les standards Prestashop
     */
    public function sanitize()
    {
        $this->id = $this->sanitizeStr($this->id, 32);
        $this->name = $this->sanitizeStr($this->name, 128);
        if ($this->name === '') {
            $this->name = 'Aucune';
        }
    }
}